/* Defines ******************************************************************/

#define _CRT_SECURE_NO_WARNINGS
#define _CRT_NONSTDC_NO_DEPRECATE

/* Includes *****************************************************************/

#include <windows.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include <direct.h>
#include <cryptuiapi.h>

/* Libraries ****************************************************************/

#pragma comment(lib, "crypt32.lib")
#pragma comment(lib, "cryptui.lib")

/* Constants ****************************************************************/

const char *title = "AMD/ATI Pixel Clock Patcher 1.4.12";

const char *driver_dir = "drivers\\atikmdag-patched";
const char *driver_sys = "drivers\\atikmdag-patched\\atikmdag.sys";
const char *driver_new = "drivers\\atikmdag.sys.new";

const char *driver_files[] =
{
	"ati*.dll",
	"ati*.dat",
	"amd*.dll",
	"amd*.dat",
	"amf*.dll",
	"detoured*.dll",
	"gamemanager*.dll",
	"mantle*.dll",
	"mcl*.dll",
	"rapidfire*.dll",
	"vulkan*.dll",
	NULL
};

const char *old_driver_sys = "drivers\\atikmdag.sys";
const char *old_driver_bak = "drivers\\atikmdag.sys.bak";

const char *old_files[] =
{
	"drivers\\atikmdag.sys.new",
	"drivers\\atikmdag.sys.tmp",
	"drivers\\patcher.tmp",
	NULL
};

const char *service_key1 = "SYSTEM\\CurrentControlSet\\Services\\amdwddmg";
const char *service_key2 = "SYSTEM\\CurrentControlSet\\Services\\amdkmdag";
const char *service_key3 = "SYSTEM\\CurrentControlSet\\Services\\atikmdag";

const unsigned char patch1[] = {0x45, 0x64, 0x67, 0x61, 0x72, 0x64, 0x20, 0x52, 0x6F, 0x62, 0x65, 0x72, 0x74, 0x6F, 0x20, 0x56, 0x69, 0x65, 0x72, 0x61};
const unsigned char patch2[] = {0x50, 0x69, 0x78, 0x65, 0x6C, 0x20, 0x43, 0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72};

const unsigned max_file_size = 200000000;

/* Limits *******************************************************************/

const unsigned old_sl_limit = 165000;
const unsigned new_sl_limit = 660000;

const unsigned old_sl_dl_limit = 165000;
const unsigned new_sl_dl_limit = 230000;

const unsigned old_hdmi13_limit = 297000;
const unsigned new_hdmi13_limit = 660000;

const unsigned old_tmds_limit = 225000;
const unsigned new_tmds_limit = 660000;

const unsigned old_crossfire_limit = 330000;
const unsigned new_crossfire_limit = 660000;

const unsigned old_vga_limit = 400000;
const unsigned new_vga_limit = 660000;

const unsigned old_hblank_limit = 56;
const unsigned new_hblank_limit = 1;

const unsigned old_low_res_limit = 400;
const unsigned new_low_res_limit = 100;

const unsigned old_low_res_limit_x = 640;
const unsigned old_low_res_limit_y = 480;

const unsigned new_low_res_limit_x = 100;
const unsigned new_low_res_limit_y = 100;

/* Globals ******************************************************************/

unsigned new_version = 0;

unsigned dvi_hdmi_limit_found = 0;
unsigned dvi_hdmi_limit_patched = 0;

unsigned sl_dvi_hdmi_limit_found = 0;
unsigned sl_dvi_hdmi_limit_patched = 0;

unsigned sl_dl_limit_found = 0;
unsigned sl_dl_limit_patched = 0;

unsigned dp_dvi_hdmi_limit_found = 0;
unsigned dp_dvi_hdmi_limit_patched = 0;

unsigned hdmi_dvi_limit_found = 0;
unsigned hdmi_dvi_limit_patched = 0;

unsigned hdmi_limit_found = 0;
unsigned hdmi_limit_patched = 0;

unsigned hdmi13_limit_found = 0;
unsigned hdmi13_limit_patched = 0;

unsigned tmds_limit_found = 0;
unsigned tmds_limit_patched = 0;

unsigned crossfire_limit_found = 0;
unsigned crossfire_limit_patched = 0;

unsigned vga_limit_found = 0;
unsigned vga_limit_patched = 0;

unsigned hblank_limit_found = 0;
unsigned hblank_limit_patched = 0;

unsigned res_limit_found = 0;
unsigned res_limit_patched = 0;

unsigned low_res_limit_found = 0;
unsigned low_res_limit_patched = 0;

unsigned bios_check_found = 0;
unsigned bios_check_patched = 0;

/* Options ******************************************************************/

BOOL option_bios = FALSE;
BOOL option_165 = FALSE;
BOOL option_660 = FALSE;

/* Functions ****************************************************************/

BOOL parse_options()
{
	char path[MAX_PATH];
	char *file;
	char *option;

	if (!GetModuleFileName(NULL, path, MAX_PATH))
		return FALSE;

	file = strrchr(path, '\\');

	if (!file)
		file = path;

	option = strrchr(file, '.');

	if (option)
		*option = 0;

	strlwr(file);
	option = strtok(file, "-");

	if (!option)
		return TRUE;

	while (option = strtok(NULL, "-"))
	{
		if (strcmp(option, "bios") == 0)
		{
			option_bios = TRUE;
			continue;
		}

		if (strcmp(option, "165") == 0 || strcmp(option, "dl") == 0 || strcmp(option, "dual") == 0)
		{
			option_165 = TRUE;
			continue;
		}

		if (strcmp(option, "660") == 0 || strcmp(option, "sl") == 0 || strcmp(option, "single") == 0)
		{
			option_660 = TRUE;
			continue;
		}
	}

	return TRUE;
}

/****************************************************************************/

int error_message(char *text)
{
	MessageBox(NULL, text, title, MB_ICONERROR);
	return 1;
}

/****************************************************************************/

BOOL search_bytes(unsigned char *buffer, int start, int end, char *bytes, unsigned size)
{
	int index;

	for (index = start; index <= end; index++)
		if (memcmp(&buffer[index], bytes, size) == 0)
			return TRUE;

	return FALSE;
}

/****************************************************************************/

BOOL replace_value(unsigned *value, unsigned old_value, unsigned new_value, unsigned *value_found, unsigned *value_patched)
{
	if (*value == old_value || *value == new_value)
	{
		if (*value == new_value)
		{
			(*value_patched)++;
			return TRUE;
		}

		(*value_found)++;
		*value = new_value;
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/
/*
BOOL replace_values(unsigned *value1, unsigned old_value1, unsigned new_value1, unsigned *value2, unsigned old_value2, unsigned new_value2, unsigned *values_found, unsigned *values_patched)
{
	if (*value1 == old_value1 || *value1 == new_value1)
	if (*value2 == old_value2 || *value2 == new_value2)
	{
		if (*value1 == new_value1)
		if (*value2 == new_value2)
		{
			(*values_patched)++;
			return TRUE;
		}

		(*values_found)++;
		*value1 = new_value1;
		*value2 = new_value2;
		return TRUE;
	}

	return FALSE;
}
*/
/****************************************************************************/

BOOL replace_bytes(unsigned char *bytes, char *old_bytes, char *new_bytes, unsigned size, unsigned *bytes_found, unsigned *bytes_patched)
{
	if (!old_bytes || memcmp(bytes, old_bytes, size) == 0 || memcmp(bytes, new_bytes, size) == 0)
	{
		if (memcmp(bytes, new_bytes, size) == 0)
		{
			(*bytes_patched)++;
			return TRUE;
		}

		(*bytes_found)++;
		memcpy(bytes, new_bytes, size);
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/

char *strcat_found(char *text, unsigned value_found, unsigned value_patched)
{
	if (value_found == 0)
	{
		if (value_patched == 0)
			return strcat(text, "not found\n");

		return strcat(text, "already patched\n");
	}

	if (value_found == 1)
		return strcat(text, "found\n");

	return strcat(text, "multiple found\n");
}

/****************************************************************************/

BOOL readable_file(const char *src_file)
{
	FILE *file;

	file = fopen(src_file, "rb");

	if (!file)
		return FALSE;

	fclose(file);
	return TRUE;
}

/****************************************************************************/

BOOL replace_file(const char *src_file, const char *dst_file)
{
	char *tmp_file;

	tmp_file = tempnam(NULL, "patcher");
	rename(dst_file, tmp_file);

	if (rename(src_file, dst_file) != 0)
	{
		rename(tmp_file, dst_file);
		free(tmp_file);
		return FALSE;
	}

	if (unlink(tmp_file) != 0)
		MoveFileEx(tmp_file, NULL, MOVEFILE_DELAY_UNTIL_REBOOT);

	free(tmp_file);
	return TRUE;
}

/****************************************************************************/

BOOL remove_file(const char *dst_file)
{
	char *tmp_file;

	tmp_file = tempnam(NULL, "patcher");
	rename(dst_file, tmp_file);

	if (unlink(tmp_file) != 0)
		MoveFileEx(tmp_file, NULL, MOVEFILE_DELAY_UNTIL_REBOOT);

	free(tmp_file);
	return TRUE;
}

/****************************************************************************/

BOOL write_file(unsigned char *src_buffer, unsigned src_size, const char *dst_file)
{
	FILE *file;

	file = fopen(dst_file, "wb");

	if (!file)
		return FALSE;

	if (fwrite(src_buffer, 1, src_size, file) != src_size)
	{
		fclose(file);
		unlink(dst_file);
		return FALSE;
	}

	if (fclose(file) != 0)
	{
		unlink(dst_file);
		return FALSE;
	}

	return TRUE;
}

/****************************************************************************/

BOOL debug_message(const char *message)
{
	char text[1024];

	sprintf(text, "%s: 0x%lx", message, GetLastError());
	MessageBox(NULL, text, "Debug", MB_ICONERROR);
	return FALSE;
}

/****************************************************************************/

BOOL sign_file(const char *file)
{
	static BYTE pfx_data[] = {0x30, 0x82, 0x15, 0x0E, 0x02, 0x01, 0x03, 0x30, 0x82, 0x14, 0xCA, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x14, 0xBB, 0x04, 0x82, 0x14, 0xB7, 0x30, 0x82, 0x14, 0xB3, 0x30, 0x82, 0x06, 0x04, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x05, 0xF5, 0x04, 0x82, 0x05, 0xF1, 0x30, 0x82, 0x05, 0xED, 0x30, 0x82, 0x05, 0xE9, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x04, 0xF6, 0x30, 0x82, 0x04, 0xF2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 0x0E, 0x04, 0x08, 0xCE, 0x63, 0xF5, 0xAF, 0xA6, 0x26, 0x62, 0xD6, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x04, 0xD0, 0xFD, 0x42, 0x00, 0x32, 0xFE, 0x8B, 0x86, 0x4E, 0x23, 0xB6, 0x7A, 0x5D, 0x32, 0xF7, 0xB4, 0x17, 0x07, 0x14, 0x97, 0xB0, 0xA9, 0x66, 0x3F, 0x80, 0xB8, 0x67, 0x15, 0x2C, 0x5A, 0x93, 0x49, 0xAD, 0xDD, 0xBA, 0x56, 0x6F, 0x37, 0x9E, 0x55, 0x89, 0x3E, 0xCE, 0x09, 0xAB, 0x1D, 0x2F, 0x90, 0xDD, 0x3A, 0x3F, 0x24, 0xDB, 0x91, 0xC1, 0x44, 0x08, 0xCD, 0x69, 0xE0, 0x1D, 0x43, 0x35, 0xC2, 0x9E, 0xAC, 0x6C, 0x8D, 0x98, 0x4A, 0xEC, 0x74, 0x6C, 0xFB, 0x30, 0xE7, 0x63, 0xB1, 0xE3, 0x4D, 0x96, 0x49, 0x97, 0x06, 0x1A, 0x59, 0x33, 0x8B, 0xEE, 0xBC, 0x49, 0xD8, 0xE5, 0x4F, 0x4C, 0x94, 0xB1, 0x92, 0x8E, 0x16, 0xA0, 0x7A, 0xE6, 0x77, 0x53, 0xAF, 0x9B, 0xBE, 0x35, 0xD4, 0xCF, 0x27, 0xE5, 0xC9, 0xDA, 0xE5, 0xB1, 0xE3, 0x3B, 0x41, 0xB2, 0x8C, 0x29, 0x89, 0xA4, 0xE0, 0x7A, 0x89, 0x29, 0x77, 0x47, 0x34, 0x36, 0xB2, 0x5F, 0xB0, 0x42, 0xC5, 0xB8, 0x37, 0x10, 0xA0, 0x86, 0x8B, 0x1E, 0xB5, 0x8F, 0xA1, 0xD9, 0xE3, 0x75, 0xAF, 0x48, 0xB0, 0x16, 0xC7, 0xEE, 0x66, 0x6C, 0x7F, 0x5E, 0xC8, 0x33, 0xAC, 0x17, 0x1B, 0x26, 0x9D, 0xA3, 0xFB, 0x57, 0xB4, 0x22, 0xC5, 0x9C, 0x54, 0x6D, 0xBE, 0x7D, 0x7B, 0x52, 0xE0, 0x0B, 0x3B, 0xAB, 0x7F, 0xF7, 0x10, 0x15, 0x1F, 0x5A, 0x4A, 0xE0, 0x83, 0xA8, 0x18, 0x7A, 0x63, 0xDC, 0x4A, 0xE7, 0xAA, 0xEA, 0x26, 0x3D, 0x5B, 0xAA, 0xBB, 0x7C, 0xAA, 0x09, 0x03, 0x80, 0x81, 0x83, 0x38, 0x26, 0x14, 0xD0, 0x6E, 0xE2, 0xDC, 0xF7, 0x81, 0xD6, 0x78, 0xCF, 0x7E, 0xAC, 0x11, 0xBD, 0x3D, 0x17, 0x99, 0x0C, 0x6C, 0x59, 0x6F, 0x0F, 0xA5, 0x32, 0x6C, 0xEE, 0x65, 0xAE, 0xCE, 0xFC, 0x45, 0x85, 0x8F, 0xE7, 0x82, 0x8A, 0x22, 0x16, 0xCC, 0x71, 0x42, 0x35, 0x76, 0x12, 0x9D, 0xED, 0x4A, 0x53, 0x29, 0x93, 0x1D, 0xEB, 0x6A, 0x1F, 0x9D, 0xD9, 0x3E, 0x08, 0x5A, 0x9D, 0x53, 0x84, 0xA4, 0x8B, 0x36, 0xDA, 0x5B, 0xA2, 0xE4, 0x11, 0xE4, 0x7C, 0x7E, 0x6D, 0xB1, 0x45, 0x83, 0x21, 0xB3, 0x43, 0x75, 0xA0, 0x36, 0x2C, 0x00, 0xB3, 0xC8, 0xC0, 0x08, 0xB3, 0xAF, 0x1A, 0x28, 0x1B, 0xAA, 0xA8, 0x47, 0x0E, 0x4C, 0x0F, 0xD4, 0x79, 0x52, 0x45, 0xD4, 0xF6, 0x0A, 0xAC, 0xFE, 0x84, 0x17, 0x4C, 0xD3, 0xB7, 0xF5, 0x4C, 0x2D, 0xF8, 0x5D, 0x29, 0xBE, 0x60, 0xE5, 0x9B, 0x68, 0x0E, 0x9B, 0xE0, 0xE0, 0x89, 0x2E, 0xE6, 0xF8, 0x5D, 0x07, 0x40, 0x22, 0x95, 0x14, 0x3B, 0xA4, 0x5A, 0x9D, 0xA0, 0x1F, 0xCB, 0xB2, 0xEC, 0x73, 0xD6, 0x8A, 0x1C, 0x8F, 0xDC, 0xC8, 0xF8, 0x74, 0x3C, 0xC9, 0xEB, 0xF8, 0x5E, 0x6F, 0x42, 0xF4, 0xDE, 0xDE, 0xC0, 0xCE, 0x62, 0x65, 0xCC, 0x60, 0x79, 0x15, 0xB6, 0xC7, 0x35, 0xF7, 0xAA, 0xB7, 0xD9, 0x60, 0x81, 0xFF, 0x1E, 0x13, 0x27, 0xD6, 0x3E, 0x98, 0xE6, 0xBD, 0xC9, 0x11, 0x9E, 0xCB, 0x5A, 0xF8, 0x2A, 0x69, 0x8B, 0xF5, 0x04, 0x5C, 0x5E, 0xF0, 0x1A, 0x9A, 0xEF, 0x0B, 0x06, 0xD3, 0xB9, 0xE6, 0xDB, 0x08, 0xA5, 0xC6, 0xF0, 0x7F, 0xF4, 0xD1, 0x30, 0xD5, 0x65, 0x53, 0xF2, 0x2D, 0x28, 0x3C, 0xD7, 0x42, 0xFC, 0xAF, 0xC2, 0xD9, 0x50, 0xA7, 0x53, 0xD5, 0x7B, 0x9C, 0x97, 0xD2, 0x56, 0x34, 0x6E, 0x4A, 0x34, 0xBF, 0xB3, 0x9A, 0x3C, 0x47, 0x33, 0x3A, 0xC4, 0xFA, 0x43, 0x42, 0xF8, 0x0B, 0xBF, 0xA1, 0x6A, 0x5F, 0xB3, 0x89, 0xF0, 0xF5, 0x29, 0xDE, 0x9F, 0x66, 0x10, 0x76, 0x8C, 0xDF, 0x21, 0xFF, 0x9E, 0xB8, 0x87, 0xA0, 0x32, 0x8D, 0x62, 0x1C, 0xE7, 0xAA, 0x5D, 0xE8, 0xED, 0x8E, 0xE3, 0x6B, 0xF1, 0xCF, 0xB2, 0x4A, 0xDB, 0xBF, 0x41, 0xAC, 0xA5, 0x56, 0x56, 0x70, 0x6F, 0xFF, 0x5F, 0x74, 0x49, 0x7E, 0x3B, 0xD6, 0x79, 0x78, 0xA3, 0x37, 0xFB, 0x06, 0x00, 0x59, 0x30, 0xB8, 0xAA, 0xBA, 0x65, 0x60, 0x22, 0x58, 0x82, 0xA7, 0x9F, 0xDA, 0xCB, 0x95, 0x22, 0x89, 0x05, 0x96, 0xB5, 0x2A, 0xAD, 0x6A, 0x51, 0x21, 0xF4, 0xF9, 0xB0, 0x98, 0x91, 0x32, 0x4E, 0xDA, 0xC8, 0xED, 0xDE, 0xFC, 0x7A, 0xE6, 0x26, 0x3D, 0x29, 0xD3, 0xDD, 0x1C, 0x74, 0xB8, 0x7A, 0x26, 0xE5, 0x89, 0x70, 0xA3, 0x39, 0xC8, 0xDE, 0x89, 0x3F, 0xDF, 0xB9, 0x4A, 0x1E, 0xDE, 0x52, 0xEC, 0x61, 0xA0, 0x32, 0xFF, 0x21, 0x49, 0x7E, 0xDA, 0x01, 0x2A, 0x25, 0x78, 0x42, 0x16, 0x31, 0xC4, 0x11, 0x7C, 0x39, 0x38, 0xC7, 0x51, 0x3F, 0x82, 0x10, 0x90, 0x47, 0x7C, 0xAC, 0x91, 0x7F, 0x45, 0x1B, 0x1B, 0x6A, 0xE8, 0xE4, 0x31, 0x52, 0x69, 0x0A, 0xDF, 0x27, 0xDD, 0xC8, 0x34, 0x0C, 0xDD, 0x42, 0xA2, 0xB2, 0xFE, 0xAC, 0x06, 0xFA, 0x09, 0x48, 0xAF, 0x64, 0x80, 0xF5, 0xDE, 0x3C, 0x7F, 0x21, 0xA4, 0x4F, 0x89, 0xEF, 0x83, 0x58, 0xB8, 0xF6, 0xC1, 0x06, 0xCF, 0x81, 0x54, 0x88, 0xD3, 0x52, 0xF0, 0xBA, 0x0A, 0x83, 0xC3, 0xED, 0xF1, 0xC1, 0xF4, 0x9E, 0xFD, 0xF9, 0x4D, 0xE9, 0x98, 0xB7, 0x1F, 0x2A, 0x29, 0x29, 0x0A, 0x78, 0x99, 0xA0, 0x4C, 0xBC, 0xD1, 0x07, 0x8D, 0xFB, 0x56, 0xCC, 0xD0, 0xDD, 0x9D, 0xCD, 0x79, 0x7E, 0x8A, 0xEA, 0x9B, 0x7E, 0x26, 0x10, 0x09, 0x76, 0x24, 0xCB, 0x45, 0xF8, 0xFA, 0x95, 0x6F, 0xE2, 0xFF, 0xAE, 0xBC, 0x47, 0x9F, 0x36, 0x71, 0x10, 0x4F, 0x9B, 0x70, 0xD5, 0xD5, 0xAF, 0x98, 0x5E, 0x9F, 0x3E, 0x0B, 0x9E, 0x9F, 0x30, 0xB0, 0xDE, 0x3D, 0x27, 0xE2, 0x9C, 0xCD, 0x92, 0xEC, 0x10, 0x75, 0x51, 0xB3, 0xA1, 0x95, 0xB7, 0x20, 0xDB, 0x5B, 0x2F, 0xC3, 0x68, 0x01, 0xBB, 0x59, 0x22, 0xEC, 0x70, 0xA4, 0x49, 0x45, 0x1C, 0x0B, 0x1A, 0x38, 0x9D, 0xBC, 0x55, 0x37, 0xD9, 0x2F, 0xDC, 0xD1, 0xA0, 0xEA, 0x6F, 0x3B, 0xC1, 0x7D, 0x11, 0xAF, 0x7A, 0x95, 0x6D, 0x02, 0x2D, 0x3D, 0xAF, 0x55, 0xC7, 0x99, 0xBB, 0x4A, 0xE1, 0x6C, 0xB2, 0x3C, 0x6E, 0xBB, 0xFE, 0x55, 0xA1, 0x59, 0x20, 0x52, 0x31, 0xCC, 0x30, 0xCA, 0x13, 0x18, 0x47, 0x6F, 0x16, 0x77, 0xEC, 0x9C, 0x80, 0xAE, 0x2D, 0xB9, 0x07, 0x9D, 0xF8, 0x4A, 0xDE, 0x1B, 0xB6, 0xA3, 0x41, 0x35, 0x9C, 0x7C, 0x9E, 0x34, 0xDE, 0xFA, 0xC2, 0x2F, 0x2C, 0x12, 0x78, 0xB2, 0x7D, 0x34, 0x21, 0xFF, 0x39, 0xB9, 0x47, 0x64, 0xBC, 0x99, 0xA2, 0x83, 0x90, 0xAB, 0x3B, 0xEA, 0xE0, 0x22, 0x5E, 0x32, 0x56, 0x07, 0x6A, 0xFD, 0x07, 0x25, 0x93, 0xD0, 0xC7, 0xC6, 0x1F, 0xBD, 0x60, 0xA3, 0xBB, 0xC6, 0xF2, 0x33, 0x51, 0x0E, 0x1D, 0x8C, 0x83, 0xDD, 0x32, 0xC4, 0x0A, 0xA7, 0xE6, 0xFE, 0xAB, 0x89, 0x0E, 0xF1, 0xEA, 0x46, 0x09, 0x77, 0x5D, 0x6E, 0xFC, 0xEE, 0x1C, 0xD7, 0x0C, 0x4C, 0x82, 0xFD, 0x0E, 0x7F, 0x4D, 0xD0, 0x38, 0x9B, 0xB7, 0x66, 0xF7, 0x6F, 0x9E, 0x06, 0x2B, 0x80, 0x7A, 0x23, 0x32, 0x02, 0x94, 0x70, 0xA7, 0xAF, 0xA5, 0x42, 0x92, 0x63, 0xCC, 0x14, 0xB4, 0x44, 0xE3, 0x96, 0xB0, 0x1E, 0x36, 0xEB, 0xB0, 0x8A, 0x19, 0x3A, 0xD6, 0x01, 0x41, 0x5A, 0x6F, 0x06, 0xF8, 0xEA, 0xAC, 0xAD, 0x42, 0x96, 0xA7, 0x4A, 0x11, 0x2B, 0xFB, 0x6E, 0x08, 0x2F, 0xE9, 0xC1, 0x5B, 0xC4, 0x22, 0xF9, 0xC8, 0x61, 0xC8, 0x62, 0x72, 0x33, 0xCB, 0x31, 0x9D, 0xE1, 0x75, 0xC6, 0xD9, 0x88, 0xEF, 0x83, 0x31, 0x74, 0x2A, 0x8D, 0x27, 0x2C, 0x94, 0x35, 0x34, 0x74, 0xC4, 0x0F, 0xF8, 0x4E, 0xD2, 0x2F, 0xF6, 0xA6, 0xBF, 0xCE, 0x17, 0x08, 0x63, 0xB6, 0x23, 0xCD, 0x20, 0x8F, 0xE0, 0x3E, 0x6D, 0x38, 0x34, 0xB5, 0x82, 0x79, 0x96, 0xAA, 0x9C, 0x96, 0x1C, 0xDE, 0x25, 0xD6, 0x31, 0x7F, 0xF5, 0x28, 0x4E, 0x93, 0x49, 0x04, 0x02, 0xE7, 0xDC, 0xFF, 0x7D, 0x54, 0x44, 0x88, 0xBA, 0xE5, 0xD2, 0xC7, 0xA4, 0x13, 0x79, 0x52, 0xFC, 0xC4, 0xF2, 0x1E, 0x32, 0x69, 0xDE, 0xC5, 0xF6, 0x71, 0xC0, 0x8C, 0x08, 0x56, 0x68, 0x46, 0x29, 0x33, 0x5E, 0x97, 0xFD, 0xB2, 0x1E, 0x25, 0x2F, 0x4D, 0x3C, 0x71, 0x73, 0xDB, 0x0C, 0x6D, 0x7F, 0x0B, 0xF7, 0xFC, 0x0B, 0x69, 0x72, 0x87, 0xC3, 0x42, 0x11, 0x9C, 0x47, 0xFD, 0xB0, 0x12, 0x24, 0x2D, 0xE9, 0xA1, 0x2D, 0x7B, 0x20, 0x54, 0xB4, 0xD4, 0xDD, 0x7F, 0x4D, 0x8B, 0xDF, 0x53, 0x7C, 0x96, 0x1B, 0xAB, 0xF3, 0xDD, 0x0D, 0xC1, 0x40, 0x3F, 0x27, 0x73, 0x5A, 0x61, 0x07, 0x79, 0x45, 0x4D, 0x7A, 0x26, 0x3B, 0x98, 0x97, 0x8A, 0x59, 0x82, 0x64, 0xBD, 0x1D, 0x2A, 0xD0, 0x91, 0xEA, 0xAC, 0x8F, 0xAD, 0x2E, 0x47, 0xFD, 0x56, 0x1F, 0x2C, 0xCC, 0xAF, 0xDA, 0x66, 0xB5, 0xFE, 0xFC, 0x16, 0x3E, 0x14, 0x8E, 0xE9, 0xC3, 0xF7, 0xC1, 0xC5, 0x30, 0x74, 0x49, 0xFC, 0xDC, 0x4B, 0x07, 0x1B, 0x7B, 0x94, 0x00, 0x53, 0xBF, 0xF9, 0x33, 0xFC, 0x59, 0x31, 0x81, 0xDF, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x5B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x4E, 0x1E, 0x4C, 0x00, 0x7B, 0x00, 0x35, 0x00, 0x46, 0x00, 0x38, 0x00, 0x39, 0x00, 0x41, 0x00, 0x45, 0x00, 0x36, 0x00, 0x41, 0x00, 0x2D, 0x00, 0x39, 0x00, 0x35, 0x00, 0x46, 0x00, 0x33, 0x00, 0x2D, 0x00, 0x34, 0x00, 0x39, 0x00, 0x41, 0x00, 0x35, 0x00, 0x2D, 0x00, 0x38, 0x00, 0x44, 0x00, 0x39, 0x00, 0x32, 0x00, 0x2D, 0x00, 0x30, 0x00, 0x31, 0x00, 0x44, 0x00, 0x31, 0x00, 0x37, 0x00, 0x43, 0x00, 0x44, 0x00, 0x43, 0x00, 0x44, 0x00, 0x30, 0x00, 0x36, 0x00, 0x38, 0x00, 0x7D, 0x30, 0x6B, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5E, 0x1E, 0x5C, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x45, 0x00, 0x6E, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x63, 0x00, 0x65, 0x00, 0x64, 0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x76, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x30, 0x30, 0x82, 0x0E, 0xA7, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x0E, 0x98, 0x30, 0x82, 0x0E, 0x94, 0x02, 0x01, 0x00, 0x30, 0x82, 0x0E, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x06, 0x30, 0x0E, 0x04, 0x08, 0x3D, 0x50, 0x23, 0x61, 0x60, 0x13, 0xD6, 0x80, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x0E, 0x60, 0xF9, 0x7C, 0xA0, 0xAA, 0xBE, 0xAF, 0xF7, 0xB7, 0x26, 0x8E, 0x62, 0x59, 0x14, 0x66, 0x9D, 0x1E, 0x53, 0xE7, 0x5E, 0x6E, 0x2F, 0x96, 0xB4, 0xE9, 0x6C, 0x1B, 0x4F, 0xA7, 0xAD, 0x53, 0xC5, 0x24, 0x5F, 0x6E, 0x2C, 0xAA, 0xA1, 0xEF, 0x8A, 0xA5, 0x70, 0xD3, 0xF8, 0x3D, 0x14, 0x88, 0xD3, 0xF4, 0x4E, 0x4B, 0x8E, 0xA2, 0x1C, 0xDA, 0x65, 0x8E, 0x23, 0xBE, 0x67, 0xC0, 0xC3, 0xB4, 0x29, 0x9C, 0x22, 0x69, 0x78, 0xA7, 0xA6, 0x10, 0x72, 0x1F, 0xCE, 0x41, 0x3D, 0xDC, 0xB2, 0xB0, 0x17, 0x86, 0xA4, 0x13, 0x9A, 0xA9, 0x33, 0xBF, 0xDE, 0x9F, 0x55, 0x44, 0x8A, 0x7B, 0x94, 0x61, 0x9B, 0xFB, 0xF2, 0xE3, 0x89, 0xEE, 0xE7, 0xC8, 0xCF, 0xAB, 0x60, 0xE9, 0x02, 0xB7, 0x50, 0x9B, 0x3A, 0x90, 0x24, 0x66, 0xFC, 0xC5, 0x7C, 0xBB, 0xA5, 0x5F, 0x91, 0x72, 0x6D, 0x90, 0x7D, 0x8D, 0x27, 0xA8, 0xBD, 0x85, 0x77, 0x08, 0x3F, 0xAF, 0x52, 0x7F, 0xD1, 0xB7, 0x06, 0x56, 0x88, 0x1F, 0x91, 0xB4, 0x96, 0x43, 0xF6, 0xF3, 0x97, 0xF3, 0x43, 0x8E, 0x58, 0x84, 0x64, 0xC4, 0xFA, 0x7A, 0x89, 0x8E, 0xDE, 0xE9, 0xC3, 0xD6, 0x83, 0xFA, 0x8A, 0xCD, 0x22, 0xC9, 0x37, 0x3B, 0x06, 0x68, 0x8E, 0xCF, 0x36, 0x0F, 0x0B, 0x8B, 0x22, 0x1E, 0x5F, 0x57, 0xBC, 0x0A, 0xDD, 0x2B, 0x64, 0x63, 0xB4, 0x42, 0xA4, 0x29, 0x3A, 0x95, 0x28, 0x96, 0x83, 0x21, 0x1C, 0x7B, 0x33, 0xB8, 0xBC, 0x5E, 0x35, 0xC3, 0x78, 0xC5, 0xDD, 0x4C, 0x55, 0x9C, 0x4D, 0x99, 0xE5, 0x67, 0x49, 0xD8, 0x6C, 0x44, 0x4A, 0xE3, 0x13, 0x57, 0x78, 0x68, 0x95, 0x92, 0x76, 0xD1, 0x89, 0x89, 0xBE, 0x4B, 0xB3, 0x43, 0x8F, 0xEA, 0x9E, 0x32, 0xD5, 0x34, 0xEE, 0xB7, 0xFE, 0xF2, 0x83, 0x92, 0x20, 0xF2, 0x90, 0x38, 0x14, 0xCD, 0x7F, 0xE7, 0xAC, 0x1A, 0xC2, 0xCC, 0x99, 0x5A, 0x57, 0xAA, 0x4B, 0xB9, 0x2D, 0x6D, 0x2E, 0xAE, 0xA5, 0x2E, 0x64, 0x39, 0x72, 0x30, 0x69, 0xAC, 0x50, 0x56, 0x5E, 0xED, 0xC6, 0xC3, 0xAE, 0xBB, 0xA3, 0x2F, 0xAB, 0xA5, 0x17, 0xCD, 0xA0, 0xE1, 0x53, 0xC4, 0x2A, 0x93, 0x2E, 0x86, 0xD2, 0x71, 0x83, 0x9B, 0x80, 0x6C, 0xCD, 0x6E, 0x12, 0xA6, 0xAD, 0x65, 0x8A, 0x06, 0x2C, 0x44, 0x1F, 0x39, 0x39, 0xA9, 0xFC, 0x4C, 0x05, 0xA1, 0x2F, 0xB0, 0xEB, 0xA2, 0xA9, 0x67, 0xFA, 0x5D, 0x12, 0xB8, 0x00, 0xA5, 0x40, 0xB4, 0xEE, 0x57, 0x49, 0x4C, 0xA4, 0x3E, 0xE0, 0x2C, 0x1B, 0xBD, 0xEC, 0xBC, 0x14, 0xB7, 0xEC, 0xF8, 0x1D, 0xC0, 0x09, 0x7A, 0x05, 0x0C, 0x78, 0xF1, 0xD9, 0x49, 0xB2, 0x11, 0x04, 0x3D, 0x28, 0x9D, 0xCB, 0xB4, 0x24, 0x87, 0xF8, 0x09, 0x0D, 0xCA, 0xDE, 0x86, 0xA6, 0x8F, 0x87, 0xDC, 0x86, 0x7E, 0x02, 0x21, 0x59, 0x9B, 0x86, 0x5F, 0x21, 0x63, 0x1B, 0x6A, 0xE8, 0xF8, 0xEB, 0x4A, 0x40, 0x6F, 0xD7, 0xD3, 0xA0, 0x0D, 0x41, 0xA8, 0x77, 0xFD, 0x78, 0xB7, 0x72, 0xFB, 0x94, 0x2A, 0x47, 0xFB, 0x79, 0xEC, 0xCE, 0xEF, 0x0D, 0x8A, 0x4D, 0xD3, 0xE1, 0x31, 0xD3, 0x85, 0x4B, 0x70, 0x2D, 0x13, 0x67, 0x14, 0xFA, 0xED, 0xBB, 0x3B, 0x85, 0x9A, 0xFB, 0x85, 0xF4, 0x38, 0x45, 0xAF, 0xAE, 0x16, 0xAF, 0xEF, 0x71, 0x29, 0x3F, 0xF6, 0x99, 0x10, 0x71, 0xA4, 0xC5, 0xD1, 0xBB, 0x26, 0xF8, 0xE1, 0xF2, 0x99, 0x48, 0xF2, 0x1C, 0xB5, 0x43, 0x86, 0x33, 0xCB, 0x90, 0xFD, 0xAD, 0x15, 0x5A, 0x34, 0x2A, 0x79, 0x24, 0x60, 0xC6, 0xA0, 0xE0, 0x7C, 0x20, 0x56, 0x5D, 0x4D, 0xDC, 0x7B, 0x87, 0xB4, 0xA0, 0xC7, 0x3A, 0xAB, 0x85, 0xCD, 0x43, 0xCE, 0xCE, 0x47, 0xF0, 0x40, 0xE4, 0x01, 0x5D, 0x6A, 0x25, 0x51, 0x0D, 0x26, 0x5B, 0x25, 0x24, 0x10, 0x50, 0x8C, 0x5E, 0x3D, 0x2C, 0xBE, 0xB6, 0xF7, 0xB4, 0x6A, 0xA4, 0x58, 0xE7, 0x46, 0xD2, 0x3D, 0x2C, 0x79, 0x12, 0x5B, 0xFA, 0x80, 0x8E, 0x8E, 0x4A, 0x52, 0x6E, 0x4F, 0x89, 0x5C, 0xFF, 0x11, 0xE0, 0xE6, 0x3A, 0x5B, 0x17, 0x90, 0x91, 0x7A, 0x21, 0x62, 0x1B, 0xCD, 0xAD, 0x2B, 0x86, 0x43, 0x71, 0x36, 0xFD, 0xC2, 0xE5, 0xB7, 0xA7, 0x7B, 0x5E, 0x9A, 0xC8, 0x84, 0x29, 0x00, 0x0D, 0x93, 0x42, 0x5C, 0x4F, 0xC1, 0xA8, 0xFB, 0x8E, 0x86, 0x7B, 0x9E, 0x4B, 0x19, 0x96, 0x81, 0x70, 0x61, 0xE3, 0x65, 0xEE, 0xF7, 0x8F, 0xB1, 0x82, 0x15, 0x49, 0x1B, 0x84, 0x1F, 0x01, 0x42, 0x4C, 0xBE, 0xF3, 0xFC, 0x6A, 0x26, 0x9A, 0xE9, 0xF9, 0x75, 0xB1, 0xA2, 0x8D, 0x03, 0xE9, 0xA6, 0x39, 0xE2, 0xE8, 0x42, 0x5E, 0x4E, 0xBE, 0xC1, 0x72, 0x7E, 0x9D, 0xFD, 0xC5, 0xCD, 0xC0, 0x33, 0xBB, 0x4A, 0x3B, 0x77, 0xC4, 0xB3, 0x0F, 0x92, 0x18, 0x15, 0xE7, 0xDE, 0x71, 0xFF, 0xC1, 0x1D, 0x1C, 0xD4, 0xEA, 0x37, 0x7A, 0x7F, 0x4C, 0x15, 0x8F, 0x26, 0xA2, 0x08, 0xD3, 0x76, 0x17, 0x5A, 0x00, 0x07, 0x27, 0x18, 0x39, 0xBA, 0x35, 0x02, 0xE6, 0x72, 0xE8, 0xE9, 0xA6, 0xB1, 0x1B, 0x22, 0xAE, 0x04, 0x42, 0x2A, 0x2D, 0xCD, 0x97, 0x01, 0xA5, 0x6C, 0xD2, 0x0E, 0x37, 0x04, 0xE5, 0xB5, 0x7F, 0x9B, 0x89, 0x97, 0x7C, 0xF8, 0xC8, 0x4D, 0xED, 0x09, 0xB7, 0x21, 0x46, 0xE2, 0x5F, 0x4E, 0x47, 0x18, 0x04, 0xD1, 0xE2, 0x2E, 0x70, 0x8E, 0x8E, 0xA3, 0x93, 0x61, 0xCE, 0xE6, 0x1D, 0xD3, 0x66, 0xB1, 0x2C, 0x24, 0x52, 0xE1, 0x68, 0x8E, 0xAC, 0x2E, 0xE3, 0xEC, 0x25, 0x8C, 0x21, 0x88, 0x25, 0x57, 0xEB, 0x37, 0xCF, 0xB5, 0x56, 0x6E, 0x6F, 0x86, 0x3C, 0xB5, 0xEA, 0x7E, 0xFC, 0xB2, 0x1E, 0xC1, 0x34, 0xA0, 0xEE, 0x5E, 0x4F, 0xC9, 0x2A, 0xEB, 0x36, 0x95, 0x14, 0xCA, 0xF2, 0x87, 0xAF, 0x0A, 0xCB, 0x75, 0x8F, 0x6A, 0x8E, 0xBD, 0x54, 0xA1, 0x2E, 0x6E, 0x0F, 0xDE, 0x7C, 0x31, 0xF5, 0xDE, 0x9A, 0xA4, 0xF9, 0xBF, 0xB2, 0x2B, 0xAA, 0xD1, 0x7F, 0x13, 0x90, 0x17, 0x28, 0x13, 0xE0, 0xDF, 0xE2, 0x1C, 0x7B, 0x59, 0x9E, 0x39, 0x9D, 0x64, 0x3A, 0x47, 0x50, 0x83, 0xCA, 0xA0, 0x91, 0x10, 0xCF, 0x08, 0x6A, 0x41, 0x73, 0x78, 0xEB, 0x90, 0xBF, 0x87, 0xAE, 0x1E, 0x7B, 0xD5, 0xBD, 0x84, 0x13, 0x77, 0x21, 0x40, 0x35, 0x32, 0x43, 0x57, 0x54, 0x16, 0xBE, 0x69, 0x82, 0x12, 0xB5, 0x28, 0x76, 0x8A, 0xBA, 0xE2, 0xF3, 0xFF, 0xC6, 0x07, 0xFF, 0xCE, 0xDD, 0xD8, 0x33, 0xD4, 0x93, 0xE2, 0xDC, 0xF2, 0x10, 0xEB, 0x3F, 0xD7, 0x0A, 0x45, 0x8C, 0x8B, 0xBF, 0xFD, 0xEF, 0x5C, 0x44, 0x1B, 0x38, 0x1F, 0xF1, 0x9A, 0x9C, 0x9E, 0x36, 0x15, 0xB9, 0x3E, 0x7A, 0x1F, 0x75, 0xB2, 0x8C, 0x36, 0x0E, 0xAB, 0x78, 0x4B, 0xDA, 0x37, 0x98, 0xBF, 0xA5, 0x5C, 0xC2, 0xB3, 0x41, 0x66, 0xEB, 0xA8, 0x11, 0xC6, 0x3E, 0x8B, 0x68, 0x58, 0x7A, 0xC9, 0xCC, 0x07, 0x82, 0x5A, 0xEB, 0x94, 0xF8, 0x04, 0x32, 0x69, 0xE5, 0xA3, 0x1F, 0xCD, 0x07, 0xCF, 0x67, 0xE2, 0xEE, 0x45, 0x61, 0x24, 0x2F, 0xFA, 0x47, 0xFA, 0xB0, 0x5A, 0x06, 0x08, 0xDF, 0x2B, 0x06, 0xE2, 0xDC, 0x7A, 0xF5, 0x12, 0xCE, 0x8D, 0x8C, 0x92, 0x93, 0x0B, 0xCB, 0xCA, 0xC7, 0xCB, 0xA5, 0x4A, 0x61, 0x24, 0xF2, 0xCB, 0x77, 0xBF, 0xD3, 0xE1, 0xDE, 0xB1, 0x54, 0xA4, 0x63, 0x7B, 0x5E, 0x4B, 0x62, 0x60, 0xC9, 0xA7, 0x02, 0x18, 0xCD, 0x32, 0xE0, 0x78, 0x2F, 0x00, 0xA0, 0xCD, 0xEE, 0x4F, 0x9D, 0x89, 0x66, 0x92, 0xD1, 0x28, 0x93, 0x88, 0x46, 0xA2, 0x7D, 0x3A, 0xE6, 0x36, 0xAD, 0x99, 0xE7, 0xF0, 0xEB, 0xE9, 0x61, 0x64, 0x83, 0xE8, 0xEB, 0x4B, 0x8D, 0x8C, 0x39, 0x6D, 0x94, 0x95, 0x27, 0xE4, 0x83, 0xF0, 0x7F, 0xA5, 0x23, 0x22, 0x3F, 0xA8, 0x25, 0x79, 0x56, 0xB1, 0x5B, 0x0A, 0xBC, 0x90, 0x42, 0x73, 0xB7, 0xDC, 0x3C, 0xC7, 0xBF, 0x6F, 0x83, 0x2A, 0x4B, 0x09, 0xD4, 0xCA, 0x52, 0xA6, 0x76, 0xD4, 0x96, 0xB0, 0xA6, 0xF1, 0x5B, 0xEF, 0x1F, 0x06, 0x10, 0x8D, 0x0E, 0xEA, 0xB8, 0x4F, 0x7B, 0x06, 0xA4, 0xB4, 0xC5, 0xBC, 0x4E, 0x50, 0x88, 0x59, 0xEE, 0x08, 0x6B, 0xC4, 0x5C, 0x6E, 0xC3, 0xB8, 0x72, 0xEC, 0xF6, 0x64, 0x8F, 0x2A, 0xD8, 0x3F, 0x8A, 0x38, 0xF5, 0x8C, 0xA1, 0xBE, 0xAD, 0x1B, 0x9D, 0x7B, 0xC4, 0xD7, 0xB0, 0xC9, 0xDE, 0xA3, 0xDC, 0x46, 0x29, 0x2D, 0x38, 0x63, 0x2B, 0xC3, 0x92, 0xD3, 0x26, 0x98, 0x99, 0x81, 0x8B, 0x57, 0xA6, 0x37, 0x31, 0x80, 0xAB, 0x86, 0xBE, 0x72, 0x73, 0x5A, 0x4E, 0x3B, 0xB8, 0xC1, 0x1E, 0xDA, 0x10, 0x5E, 0xC1, 0x48, 0x2A, 0xC9, 0x05, 0x64, 0x6A, 0xD3, 0xDA, 0x4C, 0x09, 0xAE, 0xF4, 0xB9, 0x6E, 0x5A, 0x6E, 0x7B, 0x79, 0x6B, 0x5F, 0xEE, 0x8F, 0x47, 0xFB, 0x90, 0xFB, 0x7A, 0x45, 0x5E, 0x0D, 0x0A, 0x29, 0x6C, 0x2B, 0x7C, 0x6B, 0x39, 0x4A, 0x6B, 0x2A, 0xC9, 0xC2, 0x44, 0x87, 0xFE, 0x11, 0xB9, 0x44, 0xDF, 0x29, 0x41, 0x70, 0x8B, 0xA2, 0xC3, 0xD2, 0xAC, 0x04, 0xB1, 0xDA, 0x2F, 0x24, 0xAF, 0x27, 0x0D, 0xD4, 0x7B, 0x4D, 0xD0, 0x6E, 0xFD, 0x33, 0x4F, 0x3A, 0x15, 0xEE, 0xDB, 0xC8, 0x64, 0x1E, 0x10, 0xE7, 0x47, 0x23, 0x55, 0x17, 0x75, 0x14, 0xD4, 0x2F, 0x88, 0xFC, 0xF5, 0x83, 0x2D, 0x9A, 0xEB, 0xBE, 0x94, 0xC9, 0xAC, 0x76, 0x1D, 0x06, 0x98, 0x44, 0x38, 0xC0, 0x6F, 0x81, 0xD8, 0x62, 0xA3, 0x2B, 0x76, 0x2A, 0x86, 0xE7, 0xA3, 0x19, 0xA1, 0xD5, 0x5A, 0x86, 0x1F, 0x85, 0x9B, 0x46, 0x7C, 0x64, 0xF0, 0x3F, 0x95, 0xDD, 0xC1, 0xE4, 0x70, 0x6F, 0x1A, 0x3B, 0x80, 0x5C, 0x3A, 0xAF, 0x24, 0xFE, 0x83, 0x70, 0x0B, 0x78, 0x5F, 0xCE, 0x66, 0xF8, 0xCC, 0x93, 0x2A, 0xA9, 0xB9, 0x9D, 0x7D, 0x8A, 0xED, 0x70, 0x1C, 0xB4, 0x7C, 0x62, 0x5C, 0x11, 0x6D, 0x8C, 0x24, 0xFF, 0xEF, 0xCE, 0xAF, 0x75, 0x06, 0x65, 0x90, 0xA5, 0xFB, 0xB7, 0x43, 0x59, 0x5E, 0xD9, 0xE4, 0x59, 0xAE, 0x83, 0xCD, 0x99, 0x0F, 0x59, 0x0E, 0x33, 0x1F, 0x55, 0xD8, 0xA5, 0xE2, 0x45, 0x75, 0xEE, 0xD1, 0x3B, 0x5A, 0x94, 0xDB, 0xB9, 0x37, 0x74, 0x28, 0x3B, 0x98, 0x80, 0x59, 0xA7, 0x60, 0x12, 0xD2, 0x4E, 0x2C, 0xD7, 0x70, 0x8C, 0x02, 0x5A, 0xF8, 0xD4, 0x57, 0x9C, 0xF8, 0xD0, 0x0E, 0x6C, 0x6A, 0x77, 0xA4, 0x2A, 0x8E, 0x8D, 0xB2, 0xFB, 0x2A, 0x84, 0x41, 0x97, 0x91, 0x9C, 0x21, 0xB0, 0x20, 0xB1, 0xCD, 0xD5, 0xF2, 0xCD, 0xA5, 0x8A, 0xF8, 0x0F, 0x1C, 0xE5, 0x1F, 0xF8, 0x20, 0x81, 0x16, 0xBD, 0x5D, 0x76, 0xF8, 0xFB, 0xE3, 0x01, 0xAB, 0xE5, 0x93, 0xFE, 0x76, 0xE4, 0xC1, 0x40, 0x1B, 0xC5, 0xF0, 0xC3, 0x08, 0x78, 0x52, 0x92, 0x99, 0xC5, 0x54, 0x94, 0x28, 0x58, 0xA8, 0x85, 0xB5, 0x93, 0x3B, 0x79, 0x95, 0x17, 0xFC, 0x10, 0x0D, 0x7D, 0xAF, 0x8C, 0x6E, 0x2C, 0x08, 0x47, 0x42, 0x11, 0xA7, 0x82, 0x8C, 0x1F, 0xB9, 0x10, 0xEE, 0x79, 0xE6, 0x11, 0x89, 0x9C, 0xB2, 0x9C, 0x97, 0xE1, 0xF4, 0x34, 0xA9, 0x25, 0x1F, 0x0D, 0xCF, 0x3F, 0x2C, 0x35, 0xD1, 0x95, 0xC4, 0x4F, 0x05, 0x68, 0x81, 0x8D, 0x65, 0xC8, 0xEE, 0xC0, 0x65, 0x14, 0x73, 0xEC, 0xFC, 0xFF, 0xFE, 0x9F, 0x28, 0x8F, 0xBB, 0x6A, 0x31, 0x80, 0xAB, 0x7E, 0xD3, 0x3D, 0xD5, 0x18, 0x6B, 0x72, 0x7F, 0x07, 0x3C, 0x62, 0x8B, 0x4E, 0x22, 0xD2, 0x78, 0xE7, 0xA8, 0xB8, 0x59, 0xAA, 0x89, 0xA6, 0xD2, 0xE6, 0xC9, 0x47, 0xF4, 0x74, 0x7C, 0xED, 0x5F, 0xFD, 0x66, 0x6C, 0x12, 0xAF, 0x3B, 0x96, 0x5B, 0xA0, 0xCE, 0x56, 0x59, 0xCA, 0x07, 0x27, 0x57, 0xC4, 0x16, 0xF9, 0x65, 0x63, 0xA6, 0x43, 0x31, 0xBD, 0xC9, 0x11, 0xD7, 0x11, 0xFA, 0x46, 0x76, 0x14, 0x4E, 0xDE, 0xA1, 0xCA, 0xD1, 0xD5, 0xDE, 0xF6, 0xE3, 0x0C, 0xF3, 0x96, 0x88, 0xB8, 0x35, 0x57, 0x48, 0x3A, 0xE9, 0x9B, 0xE3, 0xDB, 0x5D, 0xCD, 0xEF, 0xD4, 0x50, 0x0C, 0x95, 0x6C, 0xE5, 0x0A, 0x34, 0xBD, 0x8B, 0x4F, 0xD6, 0xC0, 0x74, 0x81, 0x5E, 0x0F, 0x01, 0x7C, 0x6D, 0x84, 0x06, 0x9F, 0x2E, 0xCB, 0x23, 0xF4, 0xAF, 0x1D, 0x3C, 0x02, 0xF3, 0x34, 0x44, 0xA8, 0x21, 0xA3, 0x31, 0x23, 0x87, 0x90, 0xE5, 0x59, 0x39, 0x19, 0xC1, 0xB5, 0xF1, 0x8F, 0xD4, 0x26, 0x78, 0x61, 0xE0, 0x42, 0x7A, 0xC3, 0x07, 0x31, 0xAA, 0x11, 0x89, 0xE3, 0x08, 0x3B, 0xFB, 0xFD, 0x19, 0x80, 0x48, 0x58, 0xEE, 0xA5, 0xD3, 0x4A, 0x27, 0x7B, 0x68, 0x84, 0xE2, 0xD4, 0xE4, 0x4B, 0xFA, 0x0B, 0x5C, 0xA9, 0x67, 0x57, 0xDD, 0xC7, 0xE0, 0x4A, 0x50, 0x1B, 0xB4, 0x8C, 0xBC, 0xBE, 0xA1, 0xDF, 0xF4, 0x85, 0x41, 0x4C, 0x12, 0xF4, 0xB7, 0x6A, 0x80, 0xED, 0x82, 0x59, 0x41, 0x95, 0x88, 0x8D, 0xC7, 0xD4, 0xC3, 0xC4, 0xAC, 0xA1, 0x8A, 0xCC, 0x2A, 0xAB, 0x6F, 0x05, 0x77, 0xA5, 0xB3, 0xDC, 0x02, 0x2D, 0x84, 0xCD, 0x99, 0xD6, 0x54, 0xAD, 0xA2, 0x41, 0x5A, 0x79, 0x57, 0x0C, 0x3E, 0x3F, 0xD5, 0x72, 0x95, 0xAB, 0x08, 0xDC, 0x67, 0x3F, 0xC5, 0x20, 0xC6, 0xF8, 0xBE, 0x46, 0xB0, 0x6A, 0xEA, 0x4B, 0xD1, 0x4A, 0xED, 0x78, 0xA0, 0xC9, 0xCD, 0xD2, 0x69, 0x41, 0x20, 0x33, 0x14, 0xC6, 0xDB, 0x0A, 0x4A, 0xFC, 0x68, 0xD2, 0x1D, 0x12, 0x34, 0x3E, 0x4E, 0xE7, 0xF8, 0x8D, 0x04, 0x2C, 0xE0, 0xC4, 0xEB, 0x16, 0x51, 0x5B, 0xCF, 0xAC, 0x4B, 0x9E, 0x6B, 0xF5, 0x9A, 0xA9, 0x4E, 0x5D, 0xDB, 0xBF, 0x66, 0x02, 0x59, 0xC9, 0x38, 0x73, 0xFF, 0xCA, 0xF6, 0x46, 0x3D, 0xDC, 0xA0, 0x82, 0xD7, 0xD4, 0x7F, 0xC8, 0x36, 0x75, 0x8C, 0x3A, 0xB8, 0xEB, 0xFA, 0xD4, 0x44, 0xB9, 0x1B, 0xCC, 0xB5, 0x3C, 0x61, 0xDB, 0x39, 0x46, 0x8C, 0x24, 0x4F, 0x6F, 0x81, 0x02, 0x15, 0x7C, 0xE5, 0x76, 0xF6, 0x43, 0x7E, 0xA8, 0x1A, 0x0E, 0xCB, 0xF0, 0x03, 0xC9, 0x08, 0xF7, 0x55, 0x86, 0x64, 0x9C, 0x6D, 0x63, 0xFF, 0x7A, 0x26, 0x86, 0x79, 0xEC, 0x83, 0x66, 0x6A, 0x18, 0x46, 0x37, 0x40, 0xFD, 0x8B, 0x1F, 0x69, 0xE8, 0x8F, 0xA8, 0xA3, 0xD3, 0x49, 0x63, 0x3F, 0x23, 0x19, 0x00, 0x47, 0x2D, 0xE7, 0xCC, 0xBA, 0xC3, 0x76, 0x70, 0x36, 0x8B, 0x1A, 0x2C, 0xA1, 0xE1, 0x39, 0xE0, 0x00, 0x60, 0x62, 0x8B, 0x3C, 0xA7, 0xF1, 0xA1, 0xF1, 0x94, 0x65, 0x8C, 0xAE, 0x96, 0xCB, 0xE4, 0xCB, 0xC6, 0xAF, 0xAF, 0x94, 0xD1, 0x0A, 0x6B, 0x23, 0x7E, 0x2D, 0xF9, 0xDC, 0x68, 0x81, 0x25, 0x39, 0x01, 0xE3, 0xA9, 0x99, 0xF4, 0x62, 0x6D, 0xE3, 0xF7, 0x16, 0x60, 0xB1, 0xFD, 0x06, 0xAE, 0xC8, 0x3D, 0xA6, 0xF0, 0xD0, 0xE3, 0x07, 0xD5, 0x8F, 0xDF, 0x52, 0x4A, 0xAC, 0x99, 0x25, 0xB9, 0x91, 0x11, 0x49, 0x73, 0x0A, 0x12, 0x2B, 0x43, 0x60, 0xD5, 0x32, 0xB3, 0x0B, 0x29, 0xFD, 0xB6, 0xFD, 0x78, 0x02, 0xBF, 0x2B, 0x5D, 0x84, 0xC7, 0x8B, 0x97, 0x2B, 0x1E, 0x83, 0x89, 0x39, 0x93, 0x06, 0x1D, 0xCB, 0xA8, 0xB9, 0x16, 0x3A, 0x5D, 0x72, 0xA7, 0xDA, 0xA2, 0x02, 0xFA, 0xEC, 0xE4, 0xBA, 0x7E, 0x87, 0xA5, 0x63, 0x6D, 0xF3, 0x24, 0xEE, 0x6C, 0x7E, 0x83, 0xB4, 0x0C, 0x05, 0xB3, 0x97, 0xBD, 0x0C, 0x49, 0xE0, 0xCD, 0xDE, 0x14, 0x32, 0x0A, 0x14, 0x91, 0xAF, 0x93, 0xD7, 0xB3, 0xDA, 0x6F, 0x9B, 0xDE, 0x89, 0xFF, 0x04, 0xC2, 0x9B, 0x49, 0xA0, 0xAE, 0x5B, 0x05, 0x3C, 0xBA, 0xD4, 0x6E, 0x4B, 0x75, 0x32, 0xA7, 0x8B, 0x40, 0xEB, 0x13, 0x32, 0xCA, 0xD5, 0x52, 0x91, 0xF7, 0x3E, 0x97, 0xF1, 0x82, 0x47, 0xBE, 0x36, 0x03, 0x54, 0x0F, 0x72, 0xB4, 0x33, 0x79, 0x04, 0xB7, 0xBB, 0x1B, 0xB6, 0x46, 0x00, 0x1B, 0xBF, 0xFF, 0x8F, 0xC5, 0x54, 0x84, 0x3B, 0xA9, 0xBE, 0xCB, 0x5A, 0xEA, 0x6A, 0x46, 0x28, 0xEC, 0xF5, 0x7F, 0xDC, 0x4B, 0xA9, 0xBF, 0x3A, 0xAA, 0x87, 0x17, 0xA7, 0x33, 0xEE, 0x90, 0xA9, 0xE8, 0x82, 0x1C, 0xD9, 0x63, 0xB3, 0x71, 0xB8, 0xBF, 0x4E, 0xF7, 0x30, 0xF1, 0x71, 0x2D, 0xB5, 0xB8, 0x42, 0xA2, 0x88, 0x59, 0xBA, 0xAC, 0x52, 0x23, 0xEE, 0xDE, 0xC7, 0x5D, 0xD3, 0x5D, 0x66, 0xC3, 0x7A, 0xF8, 0xFE, 0xAA, 0x0A, 0xD3, 0x96, 0x82, 0x46, 0xA0, 0x09, 0x29, 0x08, 0x26, 0x74, 0x78, 0xD1, 0x3A, 0xB3, 0xF4, 0x84, 0x49, 0x9A, 0xCB, 0x2D, 0x01, 0x5E, 0xA3, 0x07, 0xBD, 0x8F, 0x9C, 0x83, 0xE7, 0xC2, 0x47, 0xC3, 0x41, 0xA2, 0xDC, 0xA8, 0xDD, 0x10, 0xB4, 0x96, 0x66, 0x63, 0x99, 0x31, 0x77, 0xAE, 0xFD, 0xEC, 0x8A, 0xC1, 0x8F, 0x04, 0xD1, 0x87, 0x31, 0x8E, 0xFF, 0x22, 0x87, 0x90, 0x3A, 0x6B, 0x61, 0x10, 0x29, 0x81, 0xC1, 0xD7, 0x90, 0x6E, 0xFF, 0x8C, 0x1A, 0xE4, 0xFC, 0x01, 0x1C, 0xF7, 0x26, 0xF2, 0xFB, 0x03, 0x66, 0x3A, 0xBE, 0xAB, 0x1E, 0x60, 0x77, 0x9F, 0x3F, 0xBF, 0x68, 0x75, 0x8D, 0xAD, 0x82, 0x65, 0x81, 0xCA, 0xCC, 0xEC, 0x7F, 0x53, 0xD3, 0xE4, 0xED, 0x14, 0x1F, 0xDF, 0xBB, 0x76, 0xA3, 0x1E, 0xDD, 0x82, 0x71, 0xEB, 0x28, 0x52, 0x74, 0x04, 0x6C, 0x18, 0x2D, 0x7B, 0x0E, 0xB9, 0xE7, 0x7A, 0xD0, 0xB8, 0xBD, 0x19, 0x21, 0x72, 0x29, 0x70, 0x9C, 0x03, 0x3C, 0xD9, 0x9E, 0x0B, 0xAF, 0xFB, 0xA3, 0xA6, 0xB7, 0x3D, 0xE1, 0x03, 0x98, 0xB9, 0x3A, 0x04, 0xF4, 0x98, 0xE5, 0x8B, 0x38, 0x34, 0xB1, 0xFD, 0xCD, 0xDB, 0xB0, 0x60, 0xC1, 0xC7, 0xCB, 0xF8, 0x98, 0xC8, 0x04, 0xF8, 0x22, 0x85, 0x41, 0x6F, 0xC9, 0x62, 0x9B, 0xE1, 0xDE, 0x29, 0xA4, 0x5D, 0x6D, 0x7C, 0xF3, 0xDD, 0x56, 0x3B, 0xBF, 0x5C, 0xD0, 0x89, 0xEF, 0x54, 0x85, 0x6A, 0xC5, 0xFB, 0xC3, 0xE8, 0x2B, 0xDF, 0x5D, 0xE6, 0x3C, 0x27, 0xB3, 0xE0, 0x22, 0x2D, 0x5D, 0xB1, 0x99, 0x99, 0xE0, 0xF6, 0x1D, 0x22, 0x20, 0x74, 0x46, 0xF0, 0x84, 0x93, 0x23, 0x98, 0xFD, 0x83, 0x3E, 0x45, 0x0F, 0x0F, 0x8D, 0x92, 0xFE, 0x02, 0xEE, 0x82, 0xEF, 0xC0, 0x6B, 0x81, 0xEC, 0x15, 0x8B, 0xDA, 0x2A, 0x6B, 0x26, 0x18, 0xEF, 0x45, 0xEF, 0xB5, 0x1D, 0x8E, 0xD1, 0x08, 0x67, 0xA6, 0x57, 0xA7, 0x3D, 0x4F, 0x6A, 0x75, 0x78, 0x84, 0x58, 0xE4, 0x00, 0x04, 0x4F, 0x2D, 0xA7, 0x51, 0x35, 0x94, 0x5F, 0x31, 0x3B, 0x69, 0x47, 0x21, 0x45, 0x7F, 0x5C, 0x26, 0x27, 0xCC, 0x31, 0xF8, 0xBF, 0x5F, 0x52, 0xB5, 0x63, 0x0D, 0xB0, 0x49, 0x45, 0xD8, 0x54, 0x9C, 0xD2, 0xB7, 0xB2, 0xA9, 0xC5, 0x43, 0x7D, 0x8F, 0x2C, 0xED, 0x58, 0x3E, 0xD4, 0x01, 0xED, 0x74, 0xEE, 0x36, 0xF5, 0xA5, 0x41, 0x58, 0x0B, 0xDB, 0x22, 0xB3, 0xB0, 0xE4, 0x38, 0x10, 0x15, 0xC0, 0x76, 0xA8, 0x42, 0xBA, 0x16, 0x3D, 0x93, 0x94, 0xB7, 0x66, 0xEF, 0x0B, 0xF3, 0x7F, 0xF8, 0xB2, 0x25, 0xBF, 0x9F, 0xA5, 0xCC, 0xC6, 0xA8, 0x38, 0x0E, 0x3E, 0x3B, 0x92, 0xE7, 0xBF, 0x7E, 0xD1, 0x7F, 0x0B, 0x54, 0xC7, 0x80, 0x2E, 0x9E, 0xD4, 0x51, 0x59, 0x64, 0x86, 0xE6, 0x6B, 0xFE, 0x09, 0x52, 0xC0, 0xDC, 0xA9, 0x5D, 0x28, 0x67, 0xE3, 0x45, 0x29, 0xA8, 0x89, 0xFB, 0xB3, 0x7A, 0x8F, 0xD2, 0x68, 0x65, 0xB7, 0x50, 0xEB, 0xD3, 0xEC, 0xC5, 0x5A, 0x49, 0xFD, 0x5D, 0xD7, 0x61, 0x6D, 0xB7, 0xF7, 0x1C, 0xF1, 0xCA, 0xCB, 0x5E, 0x23, 0x94, 0x5E, 0x9F, 0x9E, 0xEF, 0xD3, 0x33, 0x5C, 0x69, 0xF4, 0x4E, 0xEE, 0x9E, 0xFA, 0x41, 0xD0, 0xDB, 0xAD, 0x08, 0xBB, 0x40, 0x5C, 0xAF, 0x62, 0x61, 0x53, 0x71, 0x18, 0xE4, 0xF9, 0x79, 0x4A, 0xA1, 0x38, 0x51, 0x0B, 0xC8, 0xF7, 0x10, 0xC8, 0xC0, 0x81, 0x06, 0x32, 0xBB, 0xA9, 0x09, 0xFF, 0xCD, 0xA7, 0x96, 0xAD, 0xFC, 0x72, 0xD9, 0x67, 0x43, 0xC2, 0x2A, 0xD1, 0xE7, 0x59, 0xD6, 0x96, 0x3E, 0x55, 0x73, 0xA0, 0x13, 0xBC, 0xA8, 0x8F, 0x47, 0x75, 0x77, 0xC2, 0xC8, 0xF8, 0x0B, 0x33, 0x08, 0x2E, 0x64, 0x94, 0x8B, 0xCA, 0xBB, 0xED, 0x99, 0x56, 0x81, 0x98, 0x9E, 0x69, 0xFA, 0xBF, 0x8E, 0x92, 0x7B, 0xBE, 0xD3, 0x5C, 0x93, 0x80, 0xD7, 0xD9, 0xC5, 0x45, 0x52, 0x7F, 0xE0, 0x9A, 0x1E, 0x22, 0x4E, 0xA4, 0x6F, 0xB7, 0x91, 0x4D, 0x9A, 0x3E, 0x94, 0x3D, 0x6F, 0xD8, 0x57, 0xB0, 0xA0, 0xF9, 0x46, 0x1B, 0xDC, 0xA4, 0x64, 0x42, 0x33, 0xC6, 0x28, 0x74, 0x9C, 0x62, 0xD1, 0x86, 0xD4, 0x66, 0x01, 0xE0, 0x32, 0xCA, 0x4B, 0xD2, 0x49, 0x65, 0x4E, 0x60, 0xB0, 0xA0, 0xA2, 0x59, 0x28, 0x79, 0x36, 0xFD, 0x4A, 0x87, 0x20, 0x62, 0xD4, 0xA6, 0xD8, 0x73, 0x43, 0xE1, 0xA4, 0x2D, 0x4C, 0x37, 0x03, 0x91, 0xCD, 0xCF, 0x6E, 0x9C, 0xD8, 0xA4, 0xE9, 0x34, 0xB8, 0xA3, 0xC4, 0x8C, 0x46, 0xEA, 0x84, 0xED, 0x41, 0x04, 0x54, 0xFC, 0x1E, 0x08, 0x38, 0x76, 0xE1, 0x5D, 0x3C, 0xAA, 0x96, 0xCA, 0x2B, 0x44, 0xB2, 0x0C, 0xA6, 0x26, 0x87, 0x57, 0xA1, 0xDD, 0x07, 0xBE, 0x72, 0xCA, 0x52, 0x51, 0x69, 0xC7, 0xBA, 0xC4, 0xD9, 0xBF, 0x63, 0x0D, 0x7E, 0xA1, 0xE4, 0xC4, 0xBF, 0x45, 0xC7, 0xFC, 0x71, 0x6D, 0xC0, 0x5D, 0xEF, 0xDC, 0x2E, 0x37, 0xF9, 0x26, 0x57, 0x22, 0x45, 0xCE, 0x0D, 0xBC, 0x8D, 0xF1, 0xE7, 0xDA, 0x0C, 0xDA, 0xC8, 0x14, 0x79, 0xE6, 0x22, 0xDF, 0x14, 0xA0, 0x3F, 0xA3, 0x75, 0x3C, 0x39, 0x3C, 0x5B, 0x4D, 0x79, 0x11, 0xBA, 0x9C, 0x06, 0xFA, 0x85, 0x93, 0xF2, 0x9B, 0x0A, 0xF2, 0xF7, 0xCC, 0x3F, 0x56, 0xC9, 0x39, 0x24, 0x46, 0x25, 0xD1, 0xF0, 0x6D, 0xBD, 0x1D, 0xC2, 0xE7, 0xB5, 0x28, 0xF4, 0x91, 0xD4, 0xB3, 0xC4, 0x28, 0xEB, 0xDE, 0x9F, 0x02, 0x91, 0xA4, 0xAC, 0xC7, 0xB6, 0x64, 0x8F, 0x2D, 0x59, 0x44, 0x69, 0x95, 0x36, 0x85, 0x49, 0xA1, 0xA6, 0xD3, 0x2B, 0xD3, 0x1C, 0x24, 0xFF, 0xD1, 0xCE, 0xBC, 0x20, 0x07, 0x44, 0x83, 0xBD, 0x41, 0x89, 0xBD, 0x87, 0x62, 0x30, 0x02, 0x34, 0x5D, 0x16, 0x19, 0xC3, 0x48, 0x5D, 0x59, 0x64, 0x7F, 0x86, 0xEB, 0xD5, 0x2C, 0xA7, 0xC3, 0xC8, 0xB2, 0x55, 0x4B, 0xF2, 0x4C, 0xBB, 0x00, 0x5A, 0x4A, 0xC7, 0x1B, 0x9E, 0xDC, 0xD0, 0x17, 0x45, 0x70, 0x2E, 0x07, 0xFD, 0x32, 0xB8, 0x70, 0x68, 0x96, 0xB3, 0x42, 0x52, 0x56, 0xAC, 0x62, 0x50, 0xD6, 0x18, 0xF5, 0xAD, 0x39, 0x79, 0xFC, 0x5A, 0x07, 0x47, 0x81, 0x40, 0x06, 0x9A, 0x18, 0x67, 0x1C, 0x2E, 0xDA, 0x03, 0x32, 0x1B, 0x06, 0x36, 0x3D, 0xDC, 0xF8, 0xC2, 0xA4, 0x5A, 0x3E, 0xF4, 0xA9, 0xC7, 0x2A, 0xB4, 0x75, 0xF7, 0x7D, 0xFD, 0xCB, 0xA1, 0x6A, 0x8D, 0x06, 0x77, 0x6A, 0xEE, 0xDD, 0x9E, 0x80, 0x4C, 0x9E, 0x23, 0xD1, 0xD9, 0x6D, 0x03, 0x2A, 0xC8, 0xB8, 0xD0, 0xAF, 0x5C, 0x90, 0x1B, 0xC5, 0xE4, 0xC0, 0x72, 0x4E, 0xA9, 0x87, 0x77, 0x6B, 0x10, 0x30, 0x92, 0xF9, 0x46, 0x68, 0xE8, 0x69, 0xD8, 0xF1, 0x39, 0x69, 0xEE, 0x8C, 0xC2, 0x6F, 0x88, 0x00, 0xC6, 0x7B, 0x39, 0x06, 0x92, 0x34, 0xC1, 0x8F, 0xCE, 0xD5, 0x98, 0xFE, 0x13, 0xAB, 0x57, 0x88, 0xC2, 0x54, 0xC1, 0x0E, 0xDD, 0x15, 0xCB, 0x77, 0xE9, 0xCE, 0x0F, 0xC3, 0x9D, 0xC7, 0x95, 0x07, 0x8A, 0x6B, 0x7D, 0x1C, 0x11, 0xBE, 0x1A, 0xDA, 0xDB, 0x77, 0x22, 0x0C, 0xE0, 0x1C, 0x48, 0x8A, 0x38, 0xF5, 0xFD, 0xF6, 0x3F, 0x00, 0x46, 0xDC, 0x4A, 0x96, 0x82, 0xE4, 0xF7, 0x0A, 0x37, 0x48, 0x6C, 0x49, 0x56, 0x62, 0xCE, 0x50, 0x3C, 0x43, 0xD2, 0x92, 0x20, 0x46, 0xFA, 0xD1, 0xF2, 0x79, 0xA5, 0x60, 0xA6, 0xBF, 0xA9, 0x43, 0x64, 0x14, 0x58, 0x36, 0xD9, 0x49, 0x90, 0xF7, 0x25, 0x6E, 0x75, 0xD2, 0x05, 0x33, 0xEB, 0xFB, 0xDA, 0x52, 0xC4, 0xB2, 0xAC, 0x46, 0x6C, 0x5B, 0xC4, 0x5D, 0x7B, 0x54, 0x33, 0x05, 0x50, 0x00, 0x6C, 0x45, 0x13, 0x67, 0x76, 0xAD, 0xF7, 0x6A, 0x1C, 0x25, 0x99, 0xC7, 0xF9, 0xAB, 0x79, 0x85, 0xCD, 0xF8, 0x87, 0xEC, 0x31, 0x69, 0x35, 0x74, 0x6C, 0xE8, 0xFC, 0xED, 0xF0, 0x4A, 0xA3, 0x10, 0x2F, 0x07, 0x96, 0xD5, 0x02, 0x84, 0xB7, 0xDF, 0xAE, 0xEA, 0x8F, 0x87, 0x06, 0xB4, 0xF5, 0x9F, 0xFF, 0xF6, 0x39, 0xAA, 0x8F, 0xE6, 0x4E, 0x2C, 0xE4, 0xDD, 0xEC, 0x0E, 0x56, 0x8E, 0x66, 0x1E, 0x62, 0x64, 0xBA, 0xED, 0xA8, 0xF9, 0xE0, 0x73, 0x9A, 0x08, 0x90, 0x5B, 0xC1, 0x8C, 0x9B, 0x70, 0x95, 0x09, 0x66, 0x50, 0xAB, 0xDF, 0x77, 0x05, 0x57, 0x3F, 0x6E, 0xE0, 0xD1, 0x4D, 0x0E, 0x34, 0x17, 0xB3, 0x27, 0x6C, 0xDC, 0xE9, 0x1F, 0x67, 0x6C, 0x08, 0x48, 0x9E, 0x29, 0xC1, 0xE4, 0xCE, 0xA7, 0xE2, 0x39, 0xC3, 0xC0, 0x1B, 0xCB, 0xFE, 0x3D, 0x52, 0xAA, 0x17, 0x17, 0x19, 0xC9, 0xFC, 0x71, 0x9E, 0x86, 0x8C, 0xBB, 0xE4, 0x34, 0xB2, 0x52, 0x25, 0x25, 0x4E, 0xFC, 0x77, 0x39, 0x50, 0x46, 0x05, 0xB4, 0xE9, 0xEB, 0x82, 0x7C, 0x54, 0x94, 0x09, 0x8C, 0x37, 0x58, 0xC9, 0xC6, 0xA1, 0x22, 0xCB, 0x1C, 0xE6, 0xFF, 0xE3, 0x74, 0xB3, 0xD2, 0x80, 0x8E, 0x70, 0x69, 0xCF, 0x7B, 0xE4, 0x2A, 0x08, 0x6A, 0x49, 0x7E, 0xC9, 0xA3, 0x4E, 0xF9, 0xED, 0x2F, 0x3C, 0xCC, 0x7B, 0xEF, 0x98, 0x1D, 0xEB, 0x8D, 0xCA, 0x0D, 0x25, 0xE6, 0xCD, 0xA1, 0x2D, 0x9F, 0x19, 0xE8, 0xEC, 0x1F, 0x9C, 0xC2, 0xAD, 0xBC, 0xA1, 0x18, 0xEA, 0xFF, 0xBB, 0x42, 0x80, 0x71, 0x42, 0x28, 0x1A, 0xFD, 0x7A, 0x81, 0x94, 0x9C, 0xEA, 0x3E, 0x2D, 0x8C, 0x06, 0x33, 0x3C, 0x8C, 0x7F, 0x65, 0x01, 0x7F, 0x59, 0x0A, 0xC0, 0x38, 0x73, 0x18, 0x02, 0xCF, 0xD2, 0x3C, 0x14, 0x79, 0xC1, 0x22, 0x3A, 0x57, 0x50, 0xFC, 0xE5, 0x16, 0x9C, 0x0F, 0x24, 0x4C, 0x0D, 0x27, 0x0A, 0x9D, 0x81, 0xC9, 0x18, 0x5A, 0x4C, 0x7C, 0x47, 0x3B, 0x52, 0xE8, 0x9B, 0x06, 0xB7, 0x94, 0x1C, 0xBF, 0x81, 0xDF, 0x77, 0x81, 0x71, 0xE8, 0x76, 0x35, 0xC1, 0x0E, 0xEF, 0x3B, 0xC7, 0xF2, 0x5C, 0x61, 0x9A, 0xCB, 0x44, 0x56, 0x27, 0xF6, 0x43, 0x11, 0x3E, 0x75, 0xAB, 0x4C, 0xA4, 0x14, 0x7D, 0x96, 0x92, 0x99, 0xB0, 0xA1, 0x97, 0x53, 0x4E, 0xB8, 0xF5, 0x06, 0xE1, 0x06, 0x7F, 0xED, 0x22, 0x8A, 0x59, 0x5A, 0x9E, 0x70, 0x9E, 0x0A, 0x01, 0x3D, 0x21, 0xA9, 0x1E, 0xDE, 0x03, 0x3D, 0x43, 0xD5, 0x13, 0x5B, 0xE0, 0xB4, 0x52, 0x2D, 0x52, 0x35, 0x34, 0xEC, 0x84, 0x5C, 0x1D, 0x02, 0x76, 0x0A, 0x4F, 0xE6, 0x6C, 0x64, 0xAA, 0xE5, 0x59, 0x10, 0x8B, 0xCF, 0x05, 0x7C, 0x39, 0xAD, 0x7D, 0x75, 0x90, 0x32, 0x37, 0xE0, 0x87, 0x79, 0x5B, 0xD2, 0x96, 0xC5, 0x07, 0x30, 0x3B, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0x36, 0x38, 0xEA, 0x19, 0xF9, 0x2E, 0x4C, 0x37, 0x14, 0x53, 0x90, 0x49, 0xBF, 0xAA, 0xF2, 0x5C, 0x6B, 0xFC, 0x9C, 0x5F, 0x04, 0x14, 0x3F, 0xAA, 0x6F, 0xDB, 0xC0, 0x0B, 0x68, 0x18, 0x35, 0x94, 0x75, 0x20, 0x27, 0x4B, 0x39, 0x97, 0x61, 0x44, 0x4C, 0x1A, 0x02, 0x02, 0x07, 0xD0};
	WCHAR wfile[MAX_PATH];
	CRYPT_DATA_BLOB pfx;
	HCERTSTORE store;
	PCCERT_CONTEXT certificate;
	CRYPTUI_WIZ_DIGITAL_SIGN_INFO info;
	CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO ext;
	SYSTEMTIME system_time;
	FILETIME file_time;
	ULARGE_INTEGER backup_time;
	ULARGE_INTEGER begin_time;
	ULARGE_INTEGER end_time;
	DWORD key_size;
	PCRYPT_KEY_PROV_INFO key;
	HCRYPTPROV provider;
	const char *error = NULL;

	if (!MultiByteToWideChar(0, 0, file, -1, wfile, MAX_PATH))
		return debug_message("MultiByteToWideChar failed");

	pfx.cbData = sizeof pfx_data;
	pfx.pbData = pfx_data;
	store = PFXImportCertStore(&pfx, wfile, 0);

	if (!store)
		return debug_message("PFXImportCertStore failed");

	certificate = CertEnumCertificatesInStore(store, NULL);

	if (!certificate)
	{
		CertCloseStore(store, 0);
		return debug_message("CertFindCertificateInStore failed");
	}

	memset(&info, 0, sizeof info);
	info.dwSize = sizeof info;
	info.dwSubjectChoice = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_FILE;
	info.pwszFileName = wfile;
	info.dwSigningCertChoice = CRYPTUI_WIZ_DIGITAL_SIGN_CERT;
	info.pSigningCertContext = certificate;
	//info.pwszTimestampURL = L"http://timestamp.verisign.com/scripts/timstamp.dll";
	//info.dwAdditionalCertChoice = CRYPTUI_WIZ_DIGITAL_SIGN_ADD_CHAIN;
	info.pSignExtInfo = &ext;
	memset(&ext, 0, sizeof ext);
	ext.dwSize = sizeof ext;
	ext.hAdditionalCertStore = store;

	memset(&system_time, 0, sizeof system_time);
	system_time.wYear = 2012;
	system_time.wMonth = 06;
	system_time.wDay = 27;
	SystemTimeToFileTime(&system_time, &file_time);
	begin_time.HighPart = file_time.dwHighDateTime;
	begin_time.LowPart = file_time.dwLowDateTime;
	GetSystemTimeAsFileTime(&file_time);
	backup_time.HighPart = file_time.dwHighDateTime;
	backup_time.LowPart = file_time.dwLowDateTime;

	if (!SetSystemTime(&system_time))
	{
		error = "SetSystemTime failed";
	}
	else
	{
		if (!CryptUIWizDigitalSign(CRYPTUI_WIZ_NO_UI, NULL, NULL, &info, NULL))
			error = "CryptUIWizDigitalSign failed";

		GetSystemTimeAsFileTime(&file_time);
		end_time.HighPart = file_time.dwHighDateTime;
		end_time.LowPart = file_time.dwLowDateTime;
		backup_time.QuadPart += end_time.QuadPart - begin_time.QuadPart;
		file_time.dwHighDateTime = backup_time.HighPart;
		file_time.dwLowDateTime = backup_time.LowPart;
		FileTimeToSystemTime(&file_time, &system_time);
		SetSystemTime(&system_time);
	}

	if (CertGetCertificateContextProperty(certificate, CERT_KEY_PROV_INFO_PROP_ID, NULL, &key_size))
	{
		key = (PCRYPT_KEY_PROV_INFO)malloc(key_size);

		if (CertGetCertificateContextProperty(certificate, CERT_KEY_PROV_INFO_PROP_ID, key, &key_size))
			CryptAcquireContextW(&provider, key->pwszContainerName, key->pwszProvName, key->dwProvType, CRYPT_DELETEKEYSET);

		free(key);
	}

	CertFreeCertificateContext(certificate);
	CertCloseStore(store, 0);

	if (error)
		return debug_message(error);

	return TRUE;
}

/****************************************************************************/

BOOL self_sign_file(const char *file)
{
	BYTE encoded_name[1024];
	DWORD encoded_name_size;
	LPSTR usage_array[1];
	CERT_ENHKEY_USAGE usage;
	BYTE encoded_usage[1024];
	DWORD encoded_usage_size;
	CERT_NAME_BLOB name;
	CERT_EXTENSION extensions_array[1];
	CERT_EXTENSIONS extensions;
	PCCERT_CONTEXT certificate;
	WCHAR wfile[1024];
	CRYPTUI_WIZ_DIGITAL_SIGN_INFO info;

	encoded_name_size = 1024;

	if (!CertStrToName(X509_ASN_ENCODING, "CN=Pixel Clock Patcher", CERT_X500_NAME_STR, NULL, encoded_name, &encoded_name_size, NULL))
		return debug_message("CertStrToName failed");

	usage_array[0] = szOID_PKIX_KP_CODE_SIGNING;
	usage.cUsageIdentifier = 1;
	usage.rgpszUsageIdentifier = usage_array;
	encoded_usage_size = 1024;

	if (!CryptEncodeObject(X509_ASN_ENCODING, szOID_ENHANCED_KEY_USAGE, &usage, encoded_usage, &encoded_usage_size))
		return debug_message("CryptEncodeObject failed");

	name.cbData = encoded_name_size;
	name.pbData = encoded_name;
	extensions_array[0].pszObjId = szOID_ENHANCED_KEY_USAGE;
	extensions_array[0].fCritical = FALSE;
	extensions_array[0].Value.cbData = encoded_usage_size;
	extensions_array[0].Value.pbData = encoded_usage;
	extensions.cExtension = 1;
	extensions.rgExtension = extensions_array;
	certificate = CertCreateSelfSignCertificate(0, &name, 0, NULL, NULL, NULL, NULL, &extensions);

	if (!certificate)
		return debug_message("CertCreateSelfSignCertificate failed");

	if (!MultiByteToWideChar(0, 0, file, -1, wfile, 1024))
		return debug_message("MultiByteToWideChar failed");

	memset(&info, 0, sizeof info);
	info.dwSize = sizeof info;
	info.dwSubjectChoice = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_FILE;
	info.pwszFileName = wfile;
	info.dwSigningCertChoice = CRYPTUI_WIZ_DIGITAL_SIGN_CERT;
	info.pSigningCertContext = certificate;

	if (!CryptUIWizDigitalSign(CRYPTUI_WIZ_NO_UI, NULL, NULL, &info, NULL))
		return debug_message("CryptUIWizDigitalSign failed");

	return TRUE;
}

/****************************************************************************/

BOOL found()
{
	if (!dvi_hdmi_limit_found)
	if (!sl_dvi_hdmi_limit_found)
	if (!sl_dl_limit_found)
	if (!dp_dvi_hdmi_limit_found)
	if (!hdmi_dvi_limit_found)
	if (!hdmi_limit_found)
	if (!hdmi13_limit_found)
	if (!tmds_limit_found)
	if (!crossfire_limit_found)
	if (!vga_limit_found)
	if (!hblank_limit_found)
	if (!res_limit_found)
	if (!low_res_limit_found)
	if (!bios_check_found)
		return FALSE;

	return TRUE;
}

/****************************************************************************/

BOOL patched(unsigned char *buffer, unsigned size)
{
	unsigned index;

	for (index = 256; index + 256 < size; index++)
		if (memcmp(&buffer[index], patch1, sizeof patch1) == 0 || memcmp(&buffer[index], patch2, sizeof patch2) == 0)
			return TRUE;

	return FALSE;
}

/****************************************************************************/

BOOL patch_hblank_limit64(unsigned char *bytes, unsigned *value)
{
	if (bytes[-6] == 0xC7 && bytes[-5] == 0x83 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
	if (bytes[7] == 0x8D && bytes[8] == 0x87 && bytes[9] == 0xBD && bytes[10] == 0x1B && bytes[11] == 0x00 && bytes[12] == 0x00)
	if (bytes[16] == 0x8D && bytes[17] == 0x87 && bytes[18] == 0x80 && bytes[19] == 0x1B && bytes[20] == 0x00 && bytes[21] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-18] == 0x89 && bytes[-17] == 0x83 && bytes[-16] == bytes[-4] + 4 && bytes[-15] == 0x00 && bytes[-14] == 0x00 && bytes[-13] == 0x00)
	if (bytes[-12] == 0x89 && bytes[-11] == 0x83 && bytes[-10] == bytes[-4] + 8 && bytes[-9] == 0x00 && bytes[-8] == 0x00 && bytes[-7] == 0x00)
	if (bytes[-6] == 0xC7 && bytes[-5] == 0x83 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-6] == 0xC7 && bytes[-5] == 0x83 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
	if (bytes[4] == 0x89 && bytes[5] == 0x83 && bytes[6] == bytes[-4] - 8 && bytes[7] == 0x00 && bytes[8] == 0x00 && bytes[9] == 0x00)
	if (bytes[10] == 0x89 && bytes[11] == 0x83 && bytes[12] == bytes[-4] - 4 && bytes[13] == 0x00 && bytes[14] == 0x00 && bytes[15] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-21] == 0xC7 && bytes[-19] == bytes[-4] - 4 && bytes[-18] == 0x00 && bytes[-17] == 0x00 && bytes[-16] == 0x00)
	if (bytes[-15] == 0x00 && (bytes[-14] == 0x20 || bytes[-14] == 0x40) && bytes[-13] == 0x00 && bytes[-12] == 0x00)
	if (bytes[-6] == 0xC7 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
	if (bytes[9] == 0xC7 && bytes[11] == bytes[-4] + 4 && bytes[12] == 0x00 && bytes[13] == 0x00 && bytes[14] == 0x00)
	if (bytes[15] == 0x04 && bytes[16] == 0x00 && bytes[17] == 0x00 && bytes[18] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	return FALSE;
}

/****************************************************************************/

BOOL patch_hblank_limit32(unsigned char *bytes, unsigned *value)
{
	if (bytes[-6] == 0xC7 && bytes[-5] == 0x86 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
	if (bytes[4] == 0x89 && bytes[5] == 0x86 && bytes[6] == bytes[-4] + 4 && bytes[7] == 0x00 && bytes[8] == 0x00 && bytes[9] == 0x00)
	if (bytes[10] == 0x89 && bytes[11] == 0x86 && bytes[12] == bytes[-4] + 8 && bytes[13] == 0x00 && bytes[14] == 0x00 && bytes[15] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-18] == 0x89 && bytes[-17] == 0x86 && bytes[-16] == bytes[-4] - 8 && bytes[-15] == 0x00 && bytes[-14] == 0x00 && bytes[-13] == 0x00)
	if (bytes[-12] == 0x89 && bytes[-11] == 0x86 && bytes[-10] == bytes[-4] - 4 && bytes[-9] == 0x00 && bytes[-8] == 0x00 && bytes[-7] == 0x00)
	if (bytes[-6] == 0xC7 && bytes[-5] == 0x86 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-18] == 0x89 && bytes[-17] == 0x86 && bytes[-16] == bytes[-4] + 4 && bytes[-15] == 0x00 && bytes[-14] == 0x00 && bytes[-13] == 0x00)
	if (bytes[-12] == 0x89 && bytes[-11] == 0x86 && bytes[-10] == bytes[-4] + 8 && bytes[-9] == 0x00 && bytes[-8] == 0x00 && bytes[-7] == 0x00)
	if (bytes[-6] == 0xC7 && bytes[-5] == 0x86 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-6] == 0xC7 && bytes[-5] == 0x86 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
	if (bytes[7] == 0x8D && bytes[8] == 0x87 && bytes[9] == 0xBD && bytes[10] == 0x1B && bytes[11] == 0x00 && bytes[12] == 0x00)
	if (bytes[16] == 0x8D && bytes[17] == 0x87 && bytes[18] == 0x80 && bytes[19] == 0x1B && bytes[20] == 0x00 && bytes[21] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-20] == 0x89 && bytes[-19] == 0x86 && bytes[-18] == bytes[-4] + 4 && bytes[-17] == 0x00 && bytes[-16] == 0x00 && bytes[-15] == 0x00)
	if (bytes[-14] == 0x89 && bytes[-13] == 0x86 && bytes[-12] == bytes[-4] + 8 && bytes[-11] == 0x00 && bytes[-10] == 0x00 && bytes[-9] == 0x00)
	if (bytes[-6] == 0xC7 && bytes[-5] == 0x86 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	if (bytes[-19] == 0xC7 && bytes[-17] == bytes[-4] - 4 && bytes[-16] == 0x00 && bytes[-15] == 0x00 && bytes[-14] == 0x00)
	if (bytes[-13] == 0x00 && (bytes[-12] == 0x20 || bytes[-12] == 0x40) && bytes[-11] == 0x00 && bytes[-10] == 0x00)
	if (bytes[-6] == 0xC7 && bytes[-3] == 0x00 && bytes[-2] == 0x00 && bytes[-1] == 0x00)
	if (bytes[7] == 0xC7 && bytes[9] == bytes[-4] + 4 && bytes[10] == 0x00 && bytes[11] == 0x00 && bytes[12] == 0x00)
	if (bytes[13] == 0x04 && bytes[14] == 0x00 && bytes[15] == 0x00 && bytes[16] == 0x00)
		return replace_value(value, old_hblank_limit, new_hblank_limit, &hblank_limit_found, &hblank_limit_patched);

	return FALSE;
}

/****************************************************************************/

BOOL patch_old_low_res_limit(unsigned char *bytes, unsigned *value_x)
{
	unsigned offset;
	unsigned *value_y;

	if ((*value_x == old_low_res_limit_x || *value_x == new_low_res_limit_x) && bytes[4] == 0x72)
	{
		for (offset = 4; offset < 16; offset++)
		{
			value_y = (unsigned *)&bytes[offset];

			if ((*value_y == old_low_res_limit_y || *value_y == new_low_res_limit_y) && bytes[offset + 4] == 0x72)
			{
				if (*value_x == new_low_res_limit_x && *value_y == new_low_res_limit_y)
				{
					low_res_limit_patched++;
					return TRUE;
				}

				low_res_limit_found++;
				*value_x = new_low_res_limit_x;
				*value_y = new_low_res_limit_y;
				return TRUE;
			}
		}
	}

	return FALSE;
}

/****************************************************************************/

BOOL patch_low_res_limit(unsigned char *bytes, unsigned *value)
{
	if (bytes[-1] >= 0xB8 && bytes[-1] <= 0xBF && bytes[4] == 0x3B && bytes[6] == 0x72)
		return replace_value(value, old_low_res_limit, new_low_res_limit, &low_res_limit_found, &low_res_limit_patched);

	if (!low_res_limit_found)
		return patch_old_low_res_limit(bytes, value);

	return FALSE;
}

/****************************************************************************/

BOOL patch_bios_check64(unsigned char *bytes)
{
	if (bytes[0] == 0x75 && bytes[2] == 0x8B && bytes[3] == 0x84 && bytes[4] == 0x24 && bytes[9] == 0x39 && bytes[10] == 0x44 && bytes[11] == 0x24)
	if (bytes[13] == 0x75 && bytes[15] == 0x8B && bytes[16] == 0x84 && bytes[17] == 0x24 && bytes[22] == 0x39 && bytes[23] == 0x44 && bytes[24] == 0x24)
	if (bytes[26] == 0x75 && bytes[28] == 0x8B && bytes[29] == 0x84 && bytes[30] == 0x24 && bytes[35] == 0x39 && bytes[36] == 0x44 && bytes[37] == 0x24)
	if (bytes[39] == 0x75 && bytes[41] == 0x33 && bytes[42] == 0xC0)
	{
		if (bytes[1] == 0x00 && bytes[14] == 0x00 && bytes[27] == 0x00 && bytes[40] == 0x00)
		{
			bios_check_patched++;
			return TRUE;
		}

		bios_check_found++;
		bytes[1] = 0x00;
		bytes[14] = 0x00;
		bytes[27] = 0x00;
		bytes[40] = 0x00;
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/

BOOL patch_bios_check32(unsigned char *bytes)
{
	if (bytes[0] == 0x75 && bytes[2] == 0x8B && bytes[3] == 0x45 && bytes[5] == 0x3B && bytes[6] == 0x85)
	if (bytes[11] == 0x75 && bytes[13] == 0x8B && bytes[14] == 0x45 && bytes[16] == 0x3B && bytes[17] == 0x85)
	if (bytes[22] == 0x75 && bytes[24] == 0x8B && bytes[25] == 0x45 && bytes[27] == 0x3B && bytes[28] == 0x85)
	if (bytes[33] == 0x75 && bytes[35] == 0x33 && bytes[36] == 0xC0)
	{
		if (bytes[1] == 0x00 && bytes[12] == 0x00 && bytes[23] == 0x00 && bytes[34] == 0x00)
		{
			bios_check_patched++;
			return TRUE;
		}

		bios_check_found++;
		bytes[1] = 0x00;
		bytes[12] = 0x00;
		bytes[23] = 0x00;
		bytes[34] = 0x00;
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/

BOOL patch64(unsigned char *buffer, unsigned size)
{
	unsigned index;
	unsigned end;
	unsigned char *bytes;
	unsigned *value;

	for (index = 256, end = size - 256; index < end; index++)
	{
		bytes = &buffer[index];
		value = (unsigned *)bytes;

		if (!option_bios)
		{
			// DVI/HDMI limit: 17.4.1+
			if (bytes[-3] == 0xC7 && bytes[12] == 0xC7 && bytes[19] == 0xEB)
				if (replace_value(value, old_sl_limit, new_sl_limit, &dvi_hdmi_limit_found, &dvi_hdmi_limit_patched))
					new_version++;

			// DVI/HDMI limit: 15.11-17.3.3
			if (bytes[-5] == 0xEB && bytes[-3] == 0xC7 && bytes[4] == 0xC7)
				replace_value(value, old_sl_limit, new_sl_limit, &dvi_hdmi_limit_found, &dvi_hdmi_limit_patched);

			// DVI/HDMI limit: 11.9-15.11 Beta
			if (bytes[-1] >= 0xB8 && bytes[-1] <= 0xBF && (*value == old_sl_limit || *value == new_sl_limit))
				if (search_bytes(bytes, 4, 100, "\x00\x80\x07\x00", 4) && search_bytes(bytes, 4, 100, "\x00\x80\x00\x00", 4))
					replace_value(value, old_sl_limit, new_sl_limit, &dvi_hdmi_limit_found, &dvi_hdmi_limit_patched);

			// SL-DVI/HDMI limit: 19.4.1+
			if (bytes[-3] == 0x81 && bytes[-2] == 0x78 && bytes[4] == 0x76 && bytes[6] == 0xB8)
				replace_value(value, old_sl_limit, new_sl_limit, &sl_dvi_hdmi_limit_found, &sl_dvi_hdmi_limit_patched);

			if (!option_165)
			{
				// SL-DVI limit on DL-DVI: 17.4.1+
				if (bytes[-13] == 0x48 && bytes[-3] == 0x81 && bytes[4] == 0x77 && bytes[6] == 0x83)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);

				// SL-DVI limit on DL-DVI: 11.9-17.3.3
				if (bytes[-3] == 0x81 && bytes[-2] == 0x7A && bytes[4] == 0x77 && bytes[6] == 0x41)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);
			}

			// DP-DVI/HDMI limit: 17.4.1+
			if (bytes[-3] == 0xC7 && bytes[12] == 0xC7 && bytes[19] == 0x48)
				if (replace_value(value, old_sl_limit, new_sl_limit, &dp_dvi_hdmi_limit_found, &dp_dvi_hdmi_limit_patched))
					new_version++;

			// HDMI-DVI limit: 17.7.2+
			if (bytes[-17] == 0x0F && bytes[-16] == 0x85 && bytes[-3] == 0xC7)
				if (replace_value(value, old_sl_limit, new_sl_limit, &hdmi_dvi_limit_found, &hdmi_dvi_limit_patched))
					new_version++;

			// HDMI limit 1: 12.9-15.11 Beta
			if (memcmp(&bytes[-7], "\x02\x00\x00\x00", 4) == 0 && bytes[-3] == 0xC7)
				replace_value(value, old_sl_limit, new_sl_limit, &hdmi_limit_found, &hdmi_limit_patched);

			// HDMI limit 2: 14.6-15.11 Beta
			if (memcmp(&bytes[-8], "\x83\x23\x00\xEB", 4) == 0 && bytes[-3] == 0xC7)
				replace_value(value, old_sl_limit, new_sl_limit, &hdmi_limit_found, &hdmi_limit_patched);

			// HDMI 1.3+ limit: 11.9+
			if ((bytes[-17] != 0x0F || bytes[-16] != 0x85) && memcmp(&bytes[-7], "\x02\x00\x00\x00", 4) != 0 && bytes[-5] != 0xEB && bytes[-3] == 0xC7 && bytes[-1] < 0x20 && bytes[12] != 0xC7)
				replace_value(value, old_hdmi13_limit, new_hdmi13_limit, &hdmi13_limit_found, &hdmi13_limit_patched);

			// TMDS limit: 12.6+
			if (bytes[-11] == 0xE8 && bytes[-6] == 0x48 && bytes[-5] == 0x8B && bytes[-4] == 0xCB && bytes[-3] == 0xC7)
				replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

			// TMDS limit: 11.9-12.4
			if (bytes[-15] == 0x48 && bytes[-14] == 0x8B && bytes[-13] == 0xCB && bytes[-8] == 0xE8 && bytes[-3] == 0xC7)
				replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

			// CrossFire limit: 11.9+
			if (bytes[-3] != 0xCC && bytes[-2] != 0xCC && (bytes[-1] == 0xB8 || bytes[-1] == 0xB9) && bytes[7] == 0xCC && bytes[8] == 0xCC)
				replace_value(value, old_crossfire_limit, new_crossfire_limit, &crossfire_limit_found, &crossfire_limit_patched);

			// VGA limit: 17.4.1+
			if (bytes[-13] == 0x48 && bytes[-12] == 0x8B && bytes[-4] == 0xFF && bytes[-3] == 0xC7 && bytes[-1] == 0x0C)
				replace_value(value, old_vga_limit, new_vga_limit, &vga_limit_found, &vga_limit_patched);

			// VGA limit: 11.9-17.3.3
			if (bytes[-10] != 0xFF && bytes[-8] == 0x48 && bytes[-7] == 0x8B && bytes[-3] == 0xC7 && bytes[-1] == 0x0C)
				replace_value(value, old_vga_limit, new_vga_limit, &vga_limit_found, &vga_limit_patched);

			// HBlank limit: 15.7+
			if (patch_hblank_limit64(bytes, value))
			{
				if (vga_limit_found || vga_limit_patched)
				{
					end = index + 1000000;

					if (end > size - 256)
						end = size - 256;
				}
			}

			// 10-resolution limit: 11.9-17.3.3
			if (bytes[-5] == 0x72 && bytes[-3] == 0x83 && bytes[-1] == 0x0A && bytes[2] == 0x32 && bytes[3] == 0xC0)
				replace_bytes(bytes, "\x72", "\xEB", 1, &res_limit_found, &res_limit_patched);

			// Low-resolution limit: 11.9-17.3.3
			patch_low_res_limit(bytes, value);
		}

		// BIOS signature check: 14.1+
		if (patch_bios_check64(bytes))
		{
			if (option_bios)
				return TRUE;

			if (index < 5000000)
				index = 5000000;
		}
	}

	return TRUE;
}

/****************************************************************************/

BOOL patch32(unsigned char *buffer, unsigned size)
{
	unsigned index;
	unsigned end;
	unsigned char *bytes;
	unsigned *value;

	for (index = 256, end = size - 256; index < end; index++)
	{
		bytes = &buffer[index];
		value = (unsigned *)bytes;

		if (!option_bios)
		{
			// DVI/HDMI limit: 17.4.1+
			if (bytes[-3] == 0xC7 && bytes[7] == 0xC7 && bytes[14] == 0xEB)
				if (replace_value(value, old_sl_limit, new_sl_limit, &dvi_hdmi_limit_found, &dvi_hdmi_limit_patched))
					new_version++;

			// DVI/HDMI limit: 15.11-17.3.3
			if (bytes[-5] == 0xEB && bytes[-3] == 0xC7 && bytes[4] == 0xC7)
				replace_value(value, old_sl_limit, new_sl_limit, &dvi_hdmi_limit_found, &dvi_hdmi_limit_patched);

			// DVI/HDMI limit: 11.9-15.11 Beta
			if (bytes[-1] >= 0xB8 && bytes[-1] <= 0xBF && (*value == old_sl_limit || *value == new_sl_limit))
				if (search_bytes(bytes, 4, 100, "\x00\x80\x07\x00", 4) && search_bytes(bytes, 4, 100, "\x00\x80\x00\x00", 4))
					replace_value(value, old_sl_limit, new_sl_limit, &dvi_hdmi_limit_found, &dvi_hdmi_limit_patched);

			if (!option_165)
			{
				// SL-DVI limit on DL-DVI: 11.9-12.3, 13.6+
				if (bytes[-6] == 0x8B && bytes[-3] == 0x81 && bytes[-2] == 0x78 && bytes[4] == 0x77 && bytes[6] == 0x83)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);

				// SL-DVI limit on DL-DVI: 12.4-13.5
				if (bytes[-6] == 0x8B && bytes[-3] == 0x81 && bytes[-2] == 0x78 && bytes[7] == 0x77 && bytes[9] == 0x83)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);
			}

			// DP-DVI/HDMI limit: 17.4.1+
			if (bytes[-3] == 0xC7 && bytes[7] == 0xC7 && bytes[14] == 0x8B)
				if (replace_value(value, old_sl_limit, new_sl_limit, &dp_dvi_hdmi_limit_found, &dp_dvi_hdmi_limit_patched))
					new_version++;

			// HDMI-DVI limit: 17.7.2+
			if (bytes[-3] == 0xC7 && bytes[7] == 0x8B && bytes[10] == 0xE8)
				if (replace_value(value, old_sl_limit, new_sl_limit, &hdmi_dvi_limit_found, &hdmi_dvi_limit_patched))
					new_version++;

			// HDMI limit 1: 12.9-15.11 Beta
			if (memcmp(&bytes[-7], "\x02\x00\x00\x00", 4) == 0 && bytes[-3] == 0xC7)
				replace_value(value, old_sl_limit, new_sl_limit, &hdmi_limit_found, &hdmi_limit_patched);

			// HDMI limit 2: 14.6-15.11 Beta
			if (memcmp(&bytes[-8], "\x83\x23\x00\xEB", 4) == 0 && bytes[-3] == 0xC7)
				replace_value(value, old_sl_limit, new_sl_limit, &hdmi_limit_found, &hdmi_limit_patched);

			// HDMI 1.3+ limit: 11.9+
			if (memcmp(&bytes[-7], "\x02\x00\x00\x00", 4) != 0 && bytes[-5] != 0xEB && bytes[-3] == 0xC7 && bytes[-1] < 0x20 && bytes[7] != 0xC7 && (bytes[7] != 0x8B || bytes[10] != 0xE8))
				replace_value(value, old_hdmi13_limit, new_hdmi13_limit, &hdmi13_limit_found, &hdmi13_limit_patched);

			// TMDS limit: 12.6+
			if (bytes[-10] == 0xE8 && bytes[-5] == 0x8B && bytes[-4] == 0xCE && bytes[-3] == 0xC7)
				replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

			// TMDS limit: 11.9-12.4
			if (bytes[-10] == 0x8B && bytes[-9] == 0xCE && bytes[-8] == 0xE8 && bytes[-3] == 0xC7)
				replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

			// CrossFire limit: 11.9+
			if (bytes[-3] != 0xCC && bytes[-2] != 0xCC && bytes[-1] == 0xB8 && bytes[8] == 0xCC && bytes[9] == 0xCC)
				replace_value(value, old_crossfire_limit, new_crossfire_limit, &crossfire_limit_found, &crossfire_limit_patched);

			// VGA limit: 11.9+
			if (bytes[-11] != 0x00 && bytes[-4] != 0x00 && bytes[-3] == 0xC7 && bytes[-1] == 0x0C && bytes[8] != 0x8B && search_bytes(bytes, 4, 10, "\x5D\xC2\x04\x00", 4))
				replace_value(value, old_vga_limit, new_vga_limit, &vga_limit_found, &vga_limit_patched);

			// HBlank limit: 15.7+
			if (patch_hblank_limit32(bytes, value))
			{
				if (vga_limit_found || vga_limit_patched)
				{
					end = index + 1000000;

					if (end > size - 256)
						end = size - 256;
				}
			}

			// 10-resolution limit: 12.9-17.3.3
			if (bytes[-4] == 0x83 && bytes[-2] == 0x0A && bytes[-1] == 0x5B && bytes[2] == 0x32 && bytes[3] == 0xC0)
				replace_bytes(bytes, "\x72", "\xEB", 1, &res_limit_found, &res_limit_patched);

			// 10-resolution limit: 11.9-12.8
			if (bytes[-5] == 0x72 && bytes[-3] == 0x83 && bytes[-1] == 0x0A && bytes[2] == 0x32 && bytes[3] == 0xC0)
				replace_bytes(bytes, "\x72", "\xEB", 1, &res_limit_found, &res_limit_patched);

			// Low-resolution limit: 11.9-17.3.3
			patch_low_res_limit(bytes, value);
		}

		// BIOS signature check: 14.1+
		if (patch_bios_check32(bytes))
		{
			if (option_bios)
				return TRUE;

			if (index < 5000000)
				index = 5000000;
		}
	}

	return TRUE;
}

/****************************************************************************/

const char *get_driver_path()
{
	HKEY key;
	DWORD size;
	static char data[MAX_PATH];
	const char *path;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key1, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key2, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key3, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
		return NULL;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath", NULL, NULL, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return NULL;
	}

	RegCloseKey(key);
	path = data;

	if (strnicmp(path, "\\SystemRoot\\", 12) == 0)
		path += 12;

	if (strnicmp(path, "System32\\", 9) == 0)
		path += 9;

	return path;
}

/****************************************************************************/

BOOL set_driver_path()
{
	HKEY key;
	DWORD type;
	DWORD size;
	char data[MAX_PATH];

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key1, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key2, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key3, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
		return FALSE;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath", NULL, &type, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	if (RegSetValueEx(key, "ImagePath.bak", 0, type, (LPBYTE)&data, size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	strcpy(data, "\\SystemRoot\\System32\\");
	strcat(data, driver_sys);
	size = (strlen(data) + 1) * sizeof *data;

	if (RegSetValueEx(key, "ImagePath", 0, type, (LPBYTE)&data, size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	return TRUE;
}

/****************************************************************************/

const char *get_backup_path()
{
	HKEY key;
	DWORD size;
	static char data[MAX_PATH];
	const char *path;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key1, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key2, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key3, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
		return NULL;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath.bak", NULL, NULL, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return NULL;
	}

	RegCloseKey(key);
	path = data;

	if (strnicmp(path, "\\SystemRoot\\", 12) == 0)
		path += 12;

	if (strnicmp(path, "System32\\", 9) == 0)
		path += 9;

	if (!readable_file(path))
		return NULL;

	return path;
}

/****************************************************************************/

BOOL restore_driver_path()
{
	HKEY key;
	DWORD type;
	DWORD size;
	char data[MAX_PATH];

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key1, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key2, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key3, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
		return FALSE;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath.bak", NULL, &type, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	if (RegSetValueEx(key, "ImagePath", 0, type, (LPBYTE)&data, size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	RegDeleteValue(key, "ImagePath.bak");
	RegCloseKey(key);
	return TRUE;
}

/****************************************************************************/

const char *replace_file_name(const char *path, const char *new_file_name)
{
	static char new_path[MAX_PATH * 2];
	char *file_name;

	strcpy(new_path, path);
	file_name = strrchr(new_path, '\\');
	file_name++;
	strcpy(file_name, new_file_name);
	return new_path;
}

/****************************************************************************/

const char *append_file_name(const char *path, const char *file_name)
{
	static char new_path[MAX_PATH * 2];

	strcpy(new_path, path);
	strcat(new_path, "\\");
	strcat(new_path, file_name);
	return new_path;
}

/****************************************************************************/

BOOL is_symbolic_link(const char *src_file)
{
	DWORD result;

	result = GetFileAttributes(src_file);

	if (result == INVALID_FILE_ATTRIBUTES)
		return FALSE;

	if (result & FILE_ATTRIBUTE_REPARSE_POINT)
		return TRUE;

	return FALSE;
}

/****************************************************************************/

int file_size(const char *src_file)
{
	struct stat src_stat;

	if (stat(src_file, &src_stat) != 0)
		return -1;

	return src_stat.st_size;
}

/****************************************************************************/

BOOL remove_driver_links()
{
	int index;
	HANDLE find;
	WIN32_FIND_DATA file;
	char src_file[MAX_PATH * 2];

	for (index = 0; driver_files[index]; index++)
	{
		find = FindFirstFile(append_file_name(driver_dir, driver_files[index]), &file);

		if (find != INVALID_HANDLE_VALUE)
		{
			do
			{
				strcpy(src_file, append_file_name(driver_dir, file.cFileName));

				if (is_symbolic_link(src_file) || file_size(src_file) == 0)
					unlink(src_file);
			}
			while (FindNextFile(find, &file));

			FindClose(find);
		}
	}

	if (chdir("..\\Sysnative") == 0)
	{
		strcpy(src_file, append_file_name("..\\System32", driver_dir));
		rmdir(src_file);

		if (is_symbolic_link(src_file) || file_size(src_file) == 0)
			unlink(src_file);
	}

	return TRUE;
}

/****************************************************************************/

BOOL create_driver_links(const char *driver_file)
{
	int index;
	HANDLE find;
	WIN32_FIND_DATA file;
	char src_file[MAX_PATH * 2];
	char dst_file[MAX_PATH * 2];

	remove_driver_links();

	for (index = 0; driver_files[index]; index++)
	{
		find = FindFirstFile(replace_file_name(driver_file, driver_files[index]), &file);

		if (find != INVALID_HANDLE_VALUE)
		{
			do
			{
				strcpy(src_file, append_file_name(driver_dir, file.cFileName));
				strcpy(dst_file, append_file_name("..\\..", replace_file_name(driver_file, file.cFileName)));

				if (!CreateSymbolicLink(src_file, dst_file, 0))
					return FALSE;
			}
			while (FindNextFile(find, &file));

			FindClose(find);
		}
	}

	for (index = 0; driver_files[index]; index++)
	{
		find = FindFirstFile(driver_files[index], &file);

		if (find != INVALID_HANDLE_VALUE)
		{
			do
			{
				strcpy(src_file, append_file_name(driver_dir, file.cFileName));
				strcpy(dst_file, append_file_name("..\\..\\..\\System32", file.cFileName));

				if (!CreateSymbolicLink(src_file, dst_file, 0) && !is_symbolic_link(src_file))
					return FALSE;
			}
			while (FindNextFile(find, &file));

			FindClose(find);
		}
	}

	if (chdir("..\\Sysnative") == 0)
	{
		for (index = 0; driver_files[index]; index++)
		{
			find = FindFirstFile(append_file_name("..\\System32", driver_files[index]), &file);

			if (find != INVALID_HANDLE_VALUE)
			{
				do
				{
					strcpy(src_file, append_file_name(driver_dir, file.cFileName));
					strcpy(dst_file, append_file_name("..\\..\\..\\SysWOW64", file.cFileName));

					if (!CreateSymbolicLink(src_file, dst_file, 0) && !is_symbolic_link(src_file))
						return FALSE;
				}
				while (FindNextFile(find, &file));

				FindClose(find);
			}
		}

		strcpy(src_file, append_file_name("..\\System32", driver_dir));
		strcpy(dst_file, append_file_name("..\\..\\System32", driver_dir));

		if (!CreateSymbolicLink(src_file, dst_file, SYMBOLIC_LINK_FLAG_DIRECTORY))
			return FALSE;
	}

	return TRUE;
}

/****************************************************************************/

BOOL remove_driver_files()
{
	remove_driver_links();
	remove_file(driver_sys);
	rmdir(driver_dir);
	return TRUE;
}

/****************************************************************************/

BOOL remove_old_backup_files()
{
	remove_file(old_driver_bak);
	return TRUE;
}

/****************************************************************************/

BOOL remove_old_files()
{
	int index;

	for (index = 0; old_files[index]; index++)
		remove_file(old_files[index]);

	return TRUE;
}

/* Main *********************************************************************/

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	const char *windir;
	unsigned bits;
	const char *driver_file;
	FILE *file;
	unsigned char *buffer;
	unsigned size;
	BOOL file_patched;
	const char *backup_file;
	char text[1024];
	BOOL self_signed = FALSE;

	windir = getenv("windir");

	if (!windir)
		windir = "C:\\Windows";

	if (chdir(windir) != 0)
		return error_message("Failed to locate Windows directory.");

	if (chdir("Sysnative") == 0)
		bits = 64;
	else if (chdir("System32") == 0)
		bits = 32;
	else
		return error_message("Failed to locate system directory.");

	driver_file = get_driver_path();

	if (!driver_file)
		return error_message("Failed to locate driver file.");

	size = file_size(driver_file);

	if (size < 0)
	{
		if (errno == ENOENT)
			return error_message("Driver file not found.");

		return error_message("Failed to access driver file.");
	}

	if (size == 0)
		return error_message("Driver file is empty.");

	if (size > max_file_size)
		return error_message("Driver file too large.");

	buffer = (unsigned char *)malloc(size);

	if (!buffer)
		return error_message("Failed to allocate memory.");

	file = fopen(driver_file, "rb");

	if (!file)
		return error_message("Failed to open driver file.");

	if (fread(buffer, 1, size, file) != size)
	{
		fclose(file);
		return error_message("Failed to read driver file.");
	}

	fclose(file);

	if (stricmp(driver_file, driver_sys) == 0)
	{
		file_patched = TRUE;
		backup_file = get_backup_path();

		if (backup_file && stricmp(backup_file, driver_sys) == 0)
			backup_file = NULL;
	}
	else if (!patched(buffer, size))
	{
		file_patched = FALSE;
		backup_file = NULL;
	}
	else if (stricmp(driver_file, old_driver_sys) == 0)
	{
		file_patched = TRUE;
		backup_file = old_driver_bak;

		if (!readable_file(backup_file))
			backup_file = NULL;
	}
	else
	{
		file_patched = TRUE;
		backup_file = NULL;
	}

	parse_options();

	if (bits == 64)
	{
		patch64(buffer, size);
		strcpy(text, "64-bit driver found.\n\n");
	}
	else if (bits == 32)
	{
		patch32(buffer, size);
		strcpy(text, "32-bit driver found.\n\n");
	}

	if (!option_bios)
	{
		strcat(text, "DVI/HDMI limit:          \t");
		strcat_found(text, dvi_hdmi_limit_found, dvi_hdmi_limit_patched);

		if (sl_dvi_hdmi_limit_found || sl_dvi_hdmi_limit_patched)
		{
			strcat(text, "SL-DVI/HDMI limit:    \t");
			strcat_found(text, sl_dvi_hdmi_limit_found, sl_dvi_hdmi_limit_patched);
		}

		if (!option_165)
		{
			strcat(text, "SL-DVI limit on DL-DVI:\t");
			strcat_found(text, sl_dl_limit_found, sl_dl_limit_patched);
		}

		if (new_version || dp_dvi_hdmi_limit_found || dp_dvi_hdmi_limit_patched)
		{
			strcat(text, "DP-DVI/HDMI limit:   \t");
			strcat_found(text, dp_dvi_hdmi_limit_found, dp_dvi_hdmi_limit_patched);
		}

		if (new_version || hdmi_dvi_limit_found || hdmi_dvi_limit_patched)
		{
			strcat(text, "HDMI-DVI limit:          \t");
			strcat_found(text, hdmi_dvi_limit_found, hdmi_dvi_limit_patched);
		}

		if (hdmi_limit_found || hdmi_limit_patched)
		{
			strcat(text, "HDMI limit:                 \t");
			strcat_found(text, !!hdmi_limit_found, hdmi_limit_patched);
		}

		if (new_version || hdmi13_limit_found || hdmi13_limit_patched)
		{
			strcat(text, "HDMI 1.3+ limit:         \t");
			strcat_found(text, !!hdmi13_limit_found, hdmi13_limit_patched);
		}

		if (tmds_limit_found || tmds_limit_patched)
		{
			strcat(text, "TMDS limit:                 \t");
			strcat_found(text, tmds_limit_found, tmds_limit_patched);
		}

		strcat(text, "CrossFire limit:            \t");
		strcat_found(text, crossfire_limit_found, crossfire_limit_patched);
		strcat(text, "VGA limit:                    \t");
		strcat_found(text, vga_limit_found, vga_limit_patched);

		if (hblank_limit_found || hblank_limit_patched)
		{
			strcat(text, "HBlank limit:               \t");
			strcat_found(text, !!hblank_limit_found, hblank_limit_patched);
		}

		if (res_limit_found || res_limit_patched)
		{
			strcat(text, "10-resolution limit:    \t");
			strcat_found(text, res_limit_found, res_limit_patched);
		}

		if (low_res_limit_found || low_res_limit_patched)
		{
			strcat(text, "Low-resolution limit: \t");
			strcat_found(text, low_res_limit_found, low_res_limit_patched);
		}
	}

	if (new_version || bios_check_found || bios_check_patched || option_bios)
	{
		strcat(text, "BIOS signature check:\t");
		strcat_found(text, bios_check_found, bios_check_patched);
	}

	strcat(text, "\n");

	if (!found())
	{
		if (!file_patched)
		{
			strcat(text, "No values found.");
			MessageBox(NULL, text, title, MB_OK);
			return 0;
		}

		if (!backup_file)
		{
			strcat(text, "No backup found.");
			MessageBox(NULL, text, title, MB_OK);
			return 0;
		}

		strcat(text, "Restore from backup?");

		if (MessageBox(NULL, text, title, MB_YESNO) != IDYES)
			return 0;

		remove_old_files();

		if (stricmp(driver_file, driver_sys) == 0)
		{
			if (!restore_driver_path())
				return error_message("Failed to restore driver path.");

			remove_driver_files();
		}
		else
		{
			if (!replace_file(backup_file, driver_file))
				return error_message("Failed to restore driver file.");
		}

		MessageBox(NULL, "Driver successfully restored.", "Restore", MB_ICONINFORMATION);
		return 0;
	}

	strcat(text, "Patch found values?");

	if (MessageBox(NULL, text, title, MB_YESNO) != IDYES)
		return 0;

	remove_old_files();

	if (!write_file(buffer, size, driver_new))
		return error_message("Failed to write new driver file.");

	if (!sign_file(driver_new))
	{
		if (!self_sign_file(driver_new))
		{
			unlink(driver_new);
			return error_message("Failed to sign new driver file.");
		}

		self_signed = TRUE;
	}

	if (backup_file)
	{
		if (!replace_file(driver_new, driver_file))
		{
			unlink(driver_new);
			return error_message("Failed to replace driver file.");
		}
	}
	else
	{
		mkdir(driver_dir);

		if (!replace_file(driver_new, driver_sys))
		{
			unlink(driver_new);
			rmdir(driver_dir);
			return error_message("Failed to move driver file.");
		}

		if (!create_driver_links(driver_file))
		{
			remove_driver_files();
			return error_message("Failed to create driver links.");
		}

		if (!set_driver_path())
		{
			remove_driver_files();
			return error_message("Failed to set new driver path.");
		}

		remove_old_backup_files();
	}

	if (self_signed)
	{
		MessageBox(NULL, "Driver successfully patched, but signing failed.\nDriver has been self-signed. Test mode is required.", "Patch", MB_ICONWARNING);
		return 1;
	}

	MessageBox(NULL, "Driver successfully patched and signed.", "Patch", MB_ICONINFORMATION);
	return 0;
}
