/* Defines ******************************************************************/

#define _CRT_SECURE_NO_WARNINGS
#define _CRT_NONSTDC_NO_DEPRECATE

/* Includes *****************************************************************/

#include <windows.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include <direct.h>
#include <cryptuiapi.h>

/* Libraries ****************************************************************/

#pragma comment(lib, "crypt32.lib")
#pragma comment(lib, "cryptui.lib")

/* Constants ****************************************************************/

const char *title = "NVIDIA Pixel Clock Patcher 1.4.14";

const char *driver_dir = "drivers\\nvlddmkm-patched";
const char *driver_sys = "drivers\\nvlddmkm-patched\\nvlddmkm.sys";
const char *driver_old = "drivers\\nvlddmkm-patched.sys";
const char *driver_new = "drivers\\nvlddmkm-patched.sys.new";

const char *driver_files[] =
{
	"cudnn_*.dll",
	"nv*.dll",
	"opencl*.dll",
	"vulkan*.dll",
	NULL
};

const char *old_driver_sys = "drivers\\nvlddmkm.sys";
const char *old_driver_bak = "drivers\\nvlddmkm.sys.bak";

const char *old_driver2_sys = "drivers\\nvlddmkm2.sys";
const char *old_driver2_bak = "drivers\\nvlddmkm2.sys.bak";

const char *old_files[] =
{
	"drivers\\nvlddmkm-patched.sys.new",
	"drivers\\nvlddmkm-patched.sys.tmp",
	"drivers\\nvlddmkm.sys.new",
	"drivers\\nvlddmkm.sys.tmp",
	"drivers\\nvlddmkm2.sys.new",
	"drivers\\patcher.tmp",
	NULL
};

const char *service_key = "SYSTEM\\CurrentControlSet\\Services\\nvlddmkm";

const unsigned char patch1[] = {0x45, 0x64, 0x67, 0x61, 0x72, 0x64, 0x20, 0x52, 0x6F, 0x62, 0x65, 0x72, 0x74, 0x6F, 0x20, 0x56, 0x69, 0x65, 0x72, 0x61};
const unsigned char patch2[] = {0x50, 0x69, 0x78, 0x65, 0x6C, 0x20, 0x43, 0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72};

const unsigned max_file_size = 100000000;

/* Limits *******************************************************************/

const unsigned old_dl_limit = 33000;
const unsigned new_dl_limit = 66000;

const unsigned old_sl_limit = 16500;
const unsigned new_sl_limit = 66000;

const unsigned old_sl_dl_limit = 16500;
const unsigned new_sl_dl_limit = 23000;

const unsigned old_tmds_limit = 34000;
const unsigned new_tmds_limit = 66000;

const unsigned old_sli_limit = 400000;
const unsigned alt_sli_limit = 540000;
const unsigned new_sli_limit = 660000;

const unsigned old_fermi_limit = 400000;
const unsigned new_fermi_limit = 660000;

/* Globals ******************************************************************/

unsigned dl_limit_found = 0;
unsigned dl_limit_patched = 0;

unsigned sl_limit_found = 0;
unsigned sl_limit_patched = 0;

unsigned sl_check_found = 0;
unsigned sl_check_patched = 0;

unsigned sl_dl_limit_found = 0;
unsigned sl_dl_limit_patched = 0;

unsigned hdmi_dvi_limit_found = 0;
unsigned hdmi_dvi_limit_patched = 0;

unsigned tmds_limit_found = 0;
unsigned tmds_limit_patched = 0;

unsigned sli_limit1_found = 0;
unsigned sli_limit1_patched = 0;

unsigned sli_limit2_found = 0;
unsigned sli_limit2_patched = 0;

unsigned sli_limit3_found = 0;
unsigned sli_limit3_patched = 0;

unsigned fermi_limit_found = 0;
unsigned fermi_limit_patched = 0;

unsigned fermi_check_found = 0;
unsigned fermi_check_patched = 0;

/* Options ******************************************************************/

BOOL option_full = FALSE;
BOOL option_165 = FALSE;
BOOL option_660 = FALSE;

/* Functions ****************************************************************/

BOOL parse_options()
{
	char path[MAX_PATH];
	char *file;
	char *option;

	if (!GetModuleFileName(NULL, path, MAX_PATH))
		return FALSE;

	file = strrchr(path, '\\');

	if (!file)
		file = path;

	option = strrchr(file, '.');

	if (option)
		*option = 0;

	strlwr(file);
	option = strtok(file, "-");

	if (!option)
		return TRUE;

	while (option = strtok(NULL, "-"))
	{
		if (strcmp(option, "full") == 0)
		{
			option_full = TRUE;
			continue;
		}

		if (strcmp(option, "165") == 0 || strcmp(option, "dl") == 0 || strcmp(option, "dual") == 0)
		{
			option_165 = TRUE;
			continue;
		}

		if (strcmp(option, "660") == 0 || strcmp(option, "sl") == 0 || strcmp(option, "single") == 0 || strcmp(option, "hdmi") == 0)
		{
			option_660 = TRUE;
			continue;
		}
	}

	return TRUE;
}

/****************************************************************************/

int error_message(char *text)
{
	MessageBox(NULL, text, title, MB_ICONERROR);
	return 1;
}

/****************************************************************************/

BOOL search_bytes(unsigned char *buffer, int start, int end, char *bytes, unsigned size)
{
	int index;

	for (index = start; index <= end; index++)
		if (memcmp(&buffer[index], bytes, size) == 0)
			return TRUE;

	return FALSE;
}

/****************************************************************************/

BOOL replace_value(unsigned *value, unsigned old_value, unsigned new_value, unsigned *value_found, unsigned *value_patched)
{
	if (*value == old_value || *value == new_value)
	{
		if (*value == new_value)
		{
			(*value_patched)++;
			return TRUE;
		}

		(*value_found)++;
		*value = new_value;
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/

BOOL replace_values(unsigned *value1, unsigned old_value1, unsigned new_value1, unsigned *value2, unsigned old_value2, unsigned new_value2, unsigned *values_found, unsigned *values_patched)
{
	if (*value1 == old_value1 || *value1 == new_value1)
	if (*value2 == old_value2 || *value2 == new_value2)
	{
		if (*value1 == new_value1)
		if (*value2 == new_value2)
		{
			(*values_patched)++;
			return TRUE;
		}

		(*values_found)++;
		*value1 = new_value1;
		*value2 = new_value2;
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/

BOOL replace_bytes(unsigned char *bytes, char *old_bytes, char *new_bytes, unsigned size, unsigned *bytes_found, unsigned *bytes_patched)
{
	if (!old_bytes || memcmp(bytes, old_bytes, size) == 0 || memcmp(bytes, new_bytes, size) == 0)
	{
		if (memcmp(bytes, new_bytes, size) == 0)
		{
			(*bytes_patched)++;
			return TRUE;
		}

		(*bytes_found)++;
		memcpy(bytes, new_bytes, size);
		return TRUE;
	}

	return FALSE;
}

/****************************************************************************/

char *strcat_found(char *text, unsigned value_found, unsigned value_patched)
{
	if (value_found == 0)
	{
		if (value_patched == 0)
			return strcat(text, "not found\n");

		return strcat(text, "already patched\n");
	}

	if (value_found == 1)
		return strcat(text, "found\n");

	return strcat(text, "multiple found\n");
}

/****************************************************************************/

BOOL readable_file(const char *src_file)
{
	FILE *file;

	file = fopen(src_file, "rb");

	if (!file)
		return FALSE;

	fclose(file);
	return TRUE;
}

/****************************************************************************/

BOOL replace_file(const char *src_file, const char *dst_file)
{
	char *tmp_file;

	tmp_file = tempnam(NULL, "patcher");
	rename(dst_file, tmp_file);

	if (rename(src_file, dst_file) != 0)
	{
		rename(tmp_file, dst_file);
		free(tmp_file);
		return FALSE;
	}

	if (unlink(tmp_file) != 0)
		MoveFileEx(tmp_file, NULL, MOVEFILE_DELAY_UNTIL_REBOOT);

	free(tmp_file);
	return TRUE;
}

/****************************************************************************/

BOOL remove_file(const char *dst_file)
{
	char *tmp_file;

	tmp_file = tempnam(NULL, "patcher");
	rename(dst_file, tmp_file);

	if (unlink(tmp_file) != 0)
		MoveFileEx(tmp_file, NULL, MOVEFILE_DELAY_UNTIL_REBOOT);

	free(tmp_file);
	return TRUE;
}

/****************************************************************************/

BOOL write_file(unsigned char *src_buffer, unsigned src_size, const char *dst_file)
{
	FILE *file;

	file = fopen(dst_file, "wb");

	if (!file)
		return FALSE;

	if (fwrite(src_buffer, 1, src_size, file) != src_size)
	{
		fclose(file);
		unlink(dst_file);
		return FALSE;
	}

	if (fclose(file) != 0)
	{
		unlink(dst_file);
		return FALSE;
	}

	return TRUE;
}

/****************************************************************************/

BOOL debug_message(const char *message)
{
	char text[1024];

	sprintf(text, "%s: 0x%lx", message, GetLastError());
	MessageBox(NULL, text, "Debug", MB_ICONERROR);
	return FALSE;
}

/****************************************************************************/

BOOL sign_file(const char *file)
{
	static BYTE pfx_data[] = {0x30, 0x82, 0x15, 0x0E, 0x02, 0x01, 0x03, 0x30, 0x82, 0x14, 0xCA, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x14, 0xBB, 0x04, 0x82, 0x14, 0xB7, 0x30, 0x82, 0x14, 0xB3, 0x30, 0x82, 0x06, 0x04, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x05, 0xF5, 0x04, 0x82, 0x05, 0xF1, 0x30, 0x82, 0x05, 0xED, 0x30, 0x82, 0x05, 0xE9, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x04, 0xF6, 0x30, 0x82, 0x04, 0xF2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 0x0E, 0x04, 0x08, 0xB2, 0x7A, 0x24, 0x9E, 0xFC, 0x83, 0xBA, 0x48, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x04, 0xD0, 0x37, 0x94, 0x3C, 0x68, 0xF5, 0x9D, 0xAE, 0xBC, 0xCA, 0x29, 0x5C, 0x1E, 0x80, 0x8A, 0x18, 0x28, 0xA5, 0xD4, 0xEC, 0xB8, 0x0E, 0xF8, 0x2B, 0xE2, 0x29, 0x37, 0xED, 0xFF, 0xBC, 0xA6, 0xF7, 0xC7, 0xCD, 0x6C, 0x02, 0x21, 0x06, 0xBE, 0x9F, 0x04, 0x62, 0x2E, 0x6E, 0x1A, 0x4E, 0x46, 0x2A, 0xB8, 0x50, 0x17, 0xFF, 0x4A, 0x68, 0xA2, 0x6A, 0xC8, 0xE3, 0x5F, 0x71, 0x54, 0xC0, 0xC3, 0xBF, 0xE5, 0x12, 0x64, 0x22, 0xF0, 0x19, 0x65, 0x1E, 0x0E, 0x76, 0xBD, 0xF5, 0xFF, 0x1B, 0x78, 0x21, 0x32, 0xB1, 0x32, 0x72, 0xEA, 0xAB, 0x85, 0x85, 0x67, 0x36, 0x49, 0xB5, 0xBF, 0xD2, 0x3E, 0x96, 0x6C, 0x0D, 0x62, 0xED, 0xCC, 0xBF, 0x80, 0xFB, 0x8B, 0x05, 0x78, 0x35, 0x21, 0xF5, 0x72, 0xDF, 0xE2, 0xE2, 0xB0, 0x7D, 0xE9, 0x4B, 0xED, 0xEC, 0xC7, 0x03, 0x95, 0x23, 0xF8, 0x10, 0x30, 0x10, 0x23, 0x71, 0x22, 0x6F, 0xA5, 0x2C, 0xCD, 0x35, 0xDD, 0xB7, 0x4F, 0x4D, 0x38, 0xB7, 0xA3, 0x71, 0x00, 0x59, 0x78, 0x90, 0xDD, 0xFE, 0x5F, 0xA4, 0x67, 0xAE, 0x00, 0x1C, 0xB4, 0x3F, 0xC7, 0x40, 0xE6, 0x82, 0x25, 0xC2, 0x40, 0x05, 0xBD, 0x6A, 0x0D, 0x9A, 0x0F, 0x9F, 0xCC, 0x27, 0xF3, 0xEE, 0xC7, 0x16, 0x88, 0xCD, 0xA7, 0x7E, 0xE2, 0x8A, 0x2D, 0x7D, 0x20, 0x6E, 0xC5, 0xD6, 0xCC, 0x01, 0xDF, 0x2D, 0x70, 0x53, 0xFB, 0xD3, 0x15, 0x09, 0xBC, 0xA7, 0x5B, 0xD8, 0xEC, 0x72, 0xFB, 0x21, 0xC2, 0xCA, 0xFB, 0x1D, 0x6F, 0x87, 0x34, 0xA9, 0x6D, 0xB5, 0xB9, 0x22, 0xAA, 0xD6, 0x31, 0x8A, 0xB2, 0x92, 0x60, 0x3D, 0x11, 0xC8, 0x98, 0x8D, 0xF3, 0x62, 0xCD, 0xC5, 0xF3, 0x56, 0x98, 0x2B, 0xA4, 0x4F, 0x83, 0xBB, 0xD8, 0x54, 0x6B, 0xB7, 0x92, 0x1E, 0x50, 0x23, 0x64, 0x0E, 0x5E, 0x97, 0xCA, 0x69, 0xA9, 0x49, 0x9A, 0xDE, 0x22, 0xC2, 0xFC, 0xA2, 0x76, 0x53, 0xE9, 0xCA, 0xAA, 0xE9, 0xFD, 0x05, 0x0E, 0xBA, 0xED, 0x9E, 0x31, 0x1F, 0x54, 0xBC, 0x73, 0x7A, 0xEF, 0x3E, 0x6D, 0x11, 0x39, 0x25, 0x30, 0x41, 0xF6, 0xF1, 0x0F, 0xF0, 0x9E, 0x28, 0x29, 0x26, 0x84, 0xB8, 0xD5, 0x06, 0x21, 0x0D, 0x8C, 0xA5, 0x97, 0xF0, 0xD7, 0x45, 0x4D, 0x95, 0x18, 0x6A, 0x44, 0xD7, 0xAC, 0xE4, 0x6A, 0x1A, 0xCD, 0x2A, 0xC3, 0x64, 0x7A, 0xAC, 0x44, 0x77, 0x4E, 0x18, 0x63, 0x01, 0x01, 0xC4, 0xE1, 0x1C, 0x95, 0x7E, 0xEC, 0x32, 0x09, 0x10, 0x6F, 0x57, 0x71, 0xC8, 0x50, 0x26, 0xFC, 0x49, 0xA0, 0x04, 0xA6, 0xDA, 0x1B, 0x22, 0x8C, 0xB8, 0xE2, 0xBA, 0x50, 0xFD, 0x1C, 0x08, 0xF5, 0x07, 0x84, 0x7C, 0x62, 0xE6, 0xDF, 0x0E, 0x7D, 0x5B, 0x53, 0x80, 0x2C, 0xBD, 0xA5, 0x21, 0x8D, 0x6C, 0xA5, 0x7F, 0x4B, 0x39, 0xA4, 0x29, 0x3C, 0x6C, 0x14, 0x45, 0x92, 0x75, 0xDD, 0x6C, 0x27, 0xFB, 0x60, 0x92, 0x69, 0x57, 0xB4, 0xCA, 0x19, 0x02, 0x12, 0x21, 0x78, 0xA8, 0x2D, 0x99, 0x75, 0x59, 0x89, 0x11, 0xBB, 0xE1, 0xAD, 0x83, 0xA4, 0x98, 0x86, 0xD3, 0xD4, 0xF5, 0xDA, 0x3E, 0xB7, 0x08, 0x88, 0x17, 0x2B, 0xA1, 0x52, 0xEB, 0x90, 0x29, 0x36, 0x05, 0x5F, 0xFA, 0x54, 0x96, 0x02, 0xAB, 0xBE, 0x16, 0xFB, 0x80, 0xE8, 0xFF, 0xA5, 0xE0, 0x71, 0xF2, 0xF4, 0x2F, 0x21, 0x99, 0x73, 0xD8, 0x5A, 0x3D, 0x48, 0xF1, 0xA2, 0x5C, 0x9C, 0x15, 0x08, 0x64, 0xB3, 0x50, 0xB7, 0xE2, 0x2B, 0x95, 0x6A, 0x47, 0xFD, 0xBF, 0x6F, 0x7B, 0xEE, 0xBC, 0x86, 0x4B, 0xE1, 0xCE, 0x6D, 0x8D, 0x89, 0x3B, 0x7E, 0x87, 0xB4, 0x0A, 0x9D, 0x3F, 0xD2, 0x5F, 0xF9, 0xB7, 0xD8, 0xF2, 0x69, 0x44, 0x00, 0x90, 0xAE, 0x3B, 0xD7, 0x35, 0xF8, 0xE2, 0x18, 0xC9, 0xA9, 0x67, 0x19, 0x4D, 0xE3, 0xA1, 0xD2, 0x34, 0x3D, 0xB5, 0xC5, 0x64, 0x8B, 0x3A, 0x01, 0x4C, 0x91, 0x9E, 0xD3, 0x80, 0x97, 0x93, 0x46, 0x8E, 0x14, 0x6E, 0xCF, 0x8E, 0xFB, 0xE1, 0x72, 0x0F, 0x50, 0x97, 0xC0, 0xBB, 0xE2, 0x31, 0xAF, 0x75, 0xE2, 0xBE, 0xF8, 0xC0, 0x0E, 0x46, 0x81, 0xFE, 0xF4, 0x51, 0x2D, 0x19, 0x6A, 0x87, 0x46, 0x33, 0x24, 0x03, 0xD5, 0x5D, 0xED, 0x53, 0x91, 0x51, 0xDB, 0x9E, 0x63, 0xA1, 0x1F, 0x37, 0x63, 0x82, 0x2C, 0x82, 0xB8, 0x04, 0xE5, 0xA4, 0x80, 0x99, 0xA4, 0x6E, 0xD3, 0x68, 0xE1, 0x5A, 0x97, 0x1B, 0x95, 0xFB, 0xB6, 0x8D, 0xF3, 0x06, 0xD0, 0xDB, 0xE2, 0x50, 0xBA, 0x03, 0xC3, 0x3E, 0x30, 0xAF, 0xBC, 0x3F, 0xC7, 0x1B, 0xE1, 0xF5, 0x02, 0x74, 0x61, 0xCA, 0x7F, 0xC5, 0x6D, 0xF0, 0x3C, 0x8C, 0xED, 0x7D, 0xDF, 0x4B, 0x0F, 0xE4, 0x80, 0x46, 0x53, 0x3A, 0x53, 0x06, 0xBB, 0x13, 0x95, 0xCB, 0x45, 0x37, 0x6E, 0x19, 0xC3, 0x42, 0xA6, 0x4E, 0xAF, 0x6C, 0x6F, 0xF2, 0xEE, 0xC0, 0xB4, 0xD4, 0xDB, 0xB7, 0x38, 0x40, 0xA1, 0x22, 0x82, 0x76, 0xBC, 0x22, 0x73, 0xC9, 0x24, 0xDD, 0xB4, 0xEA, 0xFD, 0x1F, 0x20, 0x39, 0x66, 0x8F, 0xA8, 0xF5, 0x33, 0x3D, 0xA0, 0xDE, 0x94, 0xDF, 0x96, 0x87, 0xD6, 0x3A, 0xA0, 0x08, 0x6E, 0xA1, 0xD8, 0x45, 0x63, 0x31, 0x2D, 0x04, 0x91, 0x1D, 0xFF, 0x3A, 0xD0, 0xE0, 0xF5, 0xDC, 0x1E, 0x4C, 0x1A, 0x79, 0x3B, 0xE1, 0x2B, 0x13, 0x48, 0x5E, 0x26, 0xEB, 0x48, 0xD1, 0x62, 0x1D, 0x19, 0xDC, 0x6D, 0x3C, 0xD7, 0x19, 0x8A, 0xA5, 0xCC, 0x95, 0x5F, 0xBE, 0x5B, 0xF3, 0xC5, 0x33, 0x82, 0x4E, 0xD1, 0xE4, 0xAB, 0x2D, 0x7F, 0x80, 0x91, 0x98, 0x2A, 0x46, 0x25, 0xD1, 0xF5, 0x38, 0xEB, 0x0E, 0xB1, 0xDD, 0x4C, 0x6F, 0x5D, 0xF4, 0xD3, 0x0C, 0xD4, 0x91, 0x21, 0xDC, 0x31, 0xA2, 0xA0, 0x63, 0x43, 0x52, 0x9A, 0x6C, 0xCF, 0x00, 0x57, 0xBC, 0x1A, 0x2F, 0xF6, 0xA1, 0xEA, 0x25, 0xFE, 0x44, 0x1A, 0x64, 0x89, 0xF0, 0xD5, 0x91, 0x99, 0x92, 0x03, 0xC6, 0xA7, 0x48, 0x76, 0xAE, 0x6C, 0x92, 0xEA, 0x93, 0x70, 0x69, 0xDD, 0xAF, 0x1E, 0x79, 0x5A, 0xA8, 0x8B, 0x88, 0xAE, 0x1B, 0x37, 0x10, 0x17, 0x02, 0x84, 0x17, 0x4B, 0x13, 0xD9, 0xBA, 0xA3, 0x86, 0x7B, 0x7D, 0xC4, 0xBD, 0x4C, 0x48, 0xBD, 0xAB, 0x1D, 0x43, 0x99, 0xCE, 0xBA, 0x0B, 0x79, 0x36, 0xED, 0x5F, 0xAA, 0xC4, 0xA3, 0x01, 0x43, 0x59, 0x5D, 0x48, 0x11, 0x79, 0x24, 0xB4, 0xDB, 0x48, 0x01, 0x4A, 0x67, 0x82, 0xCC, 0x77, 0xD8, 0x99, 0x8D, 0x67, 0xDC, 0x80, 0xC7, 0x06, 0xFD, 0xD5, 0xE7, 0xAD, 0xC5, 0xE8, 0x32, 0xB8, 0x4B, 0x62, 0x7D, 0x88, 0x18, 0xA2, 0xC2, 0xD4, 0x8B, 0x4B, 0xD3, 0x26, 0x78, 0x5D, 0x08, 0xDF, 0xB3, 0x21, 0x29, 0x33, 0xCC, 0x2B, 0xCB, 0x4F, 0xA5, 0x14, 0xB3, 0x51, 0x7C, 0xD5, 0x18, 0xDE, 0xC6, 0x5C, 0x30, 0x1F, 0x17, 0x87, 0x59, 0x0E, 0x26, 0xB9, 0x41, 0x49, 0x26, 0xCF, 0xCD, 0x86, 0x24, 0x49, 0xCE, 0x30, 0xDC, 0x7C, 0xE3, 0x5A, 0x30, 0x88, 0x46, 0x07, 0xAE, 0x27, 0xE1, 0x5B, 0x22, 0x37, 0x07, 0x6C, 0xBD, 0x49, 0xE9, 0xE8, 0xBA, 0x75, 0xF9, 0x89, 0x00, 0xDC, 0x56, 0x20, 0xBE, 0x1C, 0xC3, 0x3E, 0x4E, 0xD5, 0xFB, 0xF7, 0xD0, 0xAF, 0x87, 0x7B, 0x49, 0x3F, 0x30, 0x8E, 0xAD, 0x96, 0xEA, 0x8F, 0x58, 0xD7, 0x13, 0x7B, 0x6F, 0x78, 0xA8, 0x46, 0xB4, 0x36, 0x90, 0x14, 0xF1, 0xDC, 0x94, 0x16, 0x8D, 0x73, 0x2F, 0xF2, 0xB1, 0xB2, 0x4E, 0xE7, 0x2E, 0x60, 0x95, 0xC3, 0x45, 0x44, 0xFF, 0xC7, 0xF1, 0xC9, 0x40, 0x03, 0x82, 0xDB, 0xD9, 0x98, 0xDA, 0x4F, 0xC0, 0xAE, 0x31, 0xA8, 0xCD, 0xB7, 0xB1, 0x4C, 0xAC, 0x9E, 0xCA, 0x9A, 0xB7, 0xC8, 0x6B, 0x23, 0xDF, 0x14, 0x4C, 0xBB, 0x9B, 0x4D, 0x04, 0x72, 0x34, 0x81, 0xA6, 0x42, 0x3A, 0xA4, 0xEF, 0x56, 0x75, 0x41, 0x1C, 0x7A, 0xFC, 0x92, 0xB2, 0xDB, 0xB1, 0xC4, 0xC4, 0x0E, 0x6B, 0xC8, 0xF4, 0x0A, 0xD8, 0xE0, 0x1E, 0x1B, 0xB3, 0x67, 0x6C, 0x84, 0xDD, 0x53, 0x69, 0x39, 0x94, 0x53, 0x07, 0x7F, 0x9C, 0xD7, 0x2D, 0x3B, 0x29, 0x7C, 0xFE, 0x27, 0x02, 0xD0, 0xF6, 0x06, 0x4F, 0x4E, 0xA3, 0xC0, 0xB4, 0x07, 0x0A, 0x6E, 0x81, 0xA3, 0x5D, 0xBC, 0x96, 0x10, 0xE1, 0x72, 0x2D, 0xDF, 0x59, 0x87, 0xED, 0xDF, 0x93, 0xBC, 0x80, 0x8C, 0xFE, 0x3B, 0xFD, 0x40, 0x10, 0x28, 0x9B, 0x2B, 0x4F, 0x32, 0x55, 0x4A, 0x2E, 0xCE, 0x46, 0x5F, 0x05, 0xCA, 0x1D, 0xC2, 0xA9, 0x15, 0x99, 0x11, 0x90, 0x99, 0xE5, 0x73, 0xA1, 0x4A, 0x4C, 0x99, 0x44, 0xA3, 0xF7, 0x91, 0xAA, 0x9F, 0x5E, 0xBF, 0x3C, 0x56, 0x3D, 0x53, 0x2E, 0x30, 0x9C, 0x39, 0x6A, 0xAF, 0x98, 0x2B, 0xE9, 0x6A, 0x30, 0xBE, 0x49, 0x05, 0xE6, 0x51, 0xB4, 0x1D, 0xFA, 0xFB, 0xDC, 0xA4, 0x2C, 0xEF, 0xFB, 0xCE, 0x22, 0x6E, 0x1B, 0x0F, 0xAB, 0x9B, 0x26, 0x2F, 0x91, 0x3B, 0x15, 0xE8, 0xF6, 0x84, 0x13, 0xB2, 0x8A, 0x31, 0x81, 0xDF, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x5B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x4E, 0x1E, 0x4C, 0x00, 0x7B, 0x00, 0x43, 0x00, 0x32, 0x00, 0x31, 0x00, 0x43, 0x00, 0x44, 0x00, 0x30, 0x00, 0x32, 0x00, 0x44, 0x00, 0x2D, 0x00, 0x46, 0x00, 0x42, 0x00, 0x37, 0x00, 0x33, 0x00, 0x2D, 0x00, 0x34, 0x00, 0x35, 0x00, 0x30, 0x00, 0x31, 0x00, 0x2D, 0x00, 0x38, 0x00, 0x39, 0x00, 0x41, 0x00, 0x38, 0x00, 0x2D, 0x00, 0x31, 0x00, 0x31, 0x00, 0x30, 0x00, 0x36, 0x00, 0x31, 0x00, 0x37, 0x00, 0x32, 0x00, 0x43, 0x00, 0x41, 0x00, 0x34, 0x00, 0x35, 0x00, 0x45, 0x00, 0x7D, 0x30, 0x6B, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5E, 0x1E, 0x5C, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x45, 0x00, 0x6E, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x63, 0x00, 0x65, 0x00, 0x64, 0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x76, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x30, 0x30, 0x82, 0x0E, 0xA7, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x0E, 0x98, 0x30, 0x82, 0x0E, 0x94, 0x02, 0x01, 0x00, 0x30, 0x82, 0x0E, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x06, 0x30, 0x0E, 0x04, 0x08, 0xB0, 0x7C, 0x01, 0x87, 0x42, 0xF0, 0x06, 0x54, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x0E, 0x60, 0x5C, 0xAC, 0xC4, 0x17, 0xC5, 0x95, 0x4B, 0x80, 0x91, 0x8A, 0x4F, 0x53, 0x33, 0xBD, 0x2E, 0x28, 0x13, 0x1A, 0x26, 0x58, 0x77, 0x8D, 0x33, 0x56, 0x3C, 0x02, 0xEE, 0xE3, 0xED, 0x44, 0x58, 0x2B, 0x47, 0x94, 0xC8, 0x66, 0x75, 0x32, 0xC1, 0xE9, 0xB2, 0xDF, 0x0E, 0x6D, 0x9A, 0x05, 0x08, 0x0E, 0xFB, 0xA4, 0x70, 0x38, 0x4D, 0xAF, 0x15, 0xB9, 0x41, 0x62, 0xBE, 0xD5, 0x27, 0x7F, 0x86, 0x44, 0x27, 0x4B, 0xD1, 0x64, 0x01, 0x2D, 0x76, 0x0E, 0x59, 0xC1, 0xB9, 0x54, 0x92, 0x6C, 0xBA, 0x87, 0xE2, 0x27, 0x74, 0x89, 0xDE, 0xA0, 0xB7, 0x41, 0xFA, 0x4E, 0x3C, 0xFA, 0xF2, 0x0A, 0xD2, 0x02, 0x45, 0x36, 0x3D, 0x71, 0x06, 0x0A, 0xA3, 0xE9, 0xDC, 0x72, 0x05, 0xB9, 0xD0, 0x48, 0x7F, 0x79, 0x06, 0x9B, 0xD8, 0x70, 0x67, 0x99, 0x65, 0x8F, 0xAC, 0x35, 0x0F, 0x9A, 0x52, 0xAD, 0xCA, 0x0B, 0xB0, 0x18, 0x36, 0x65, 0x9A, 0xF1, 0xE2, 0xB3, 0xF6, 0x04, 0x90, 0x2B, 0x12, 0x5F, 0x3D, 0xE2, 0x38, 0x32, 0xF5, 0xBA, 0x6B, 0x23, 0x88, 0x9B, 0x1C, 0x48, 0xC5, 0xA5, 0x08, 0xD6, 0x02, 0x78, 0xEF, 0xF5, 0x50, 0xAA, 0xF7, 0x2E, 0xAA, 0xD1, 0x87, 0x5F, 0x65, 0x10, 0x72, 0x81, 0x0C, 0x63, 0x5B, 0x95, 0x38, 0x8B, 0xEB, 0x96, 0x34, 0x77, 0xBC, 0x52, 0xB1, 0x2D, 0x7B, 0xD3, 0x25, 0xC7, 0x0F, 0xF2, 0x33, 0xFC, 0x0B, 0xA4, 0xD4, 0xEA, 0xB5, 0x4A, 0x79, 0x94, 0x2C, 0x63, 0x02, 0xE0, 0xC3, 0xCE, 0x9D, 0xFE, 0x38, 0x16, 0x44, 0xCF, 0x3E, 0xFC, 0x01, 0xBE, 0x47, 0x82, 0xDF, 0x3C, 0x83, 0xAD, 0xB6, 0x5C, 0x4D, 0xEC, 0xA3, 0xDC, 0xDF, 0xF4, 0x75, 0x19, 0x7F, 0xB5, 0x80, 0xF4, 0x3E, 0x90, 0xC6, 0xC5, 0xA9, 0x01, 0x93, 0x55, 0x48, 0x06, 0x4B, 0xEE, 0xBA, 0x7C, 0xC5, 0xA9, 0xE4, 0x45, 0xF5, 0x03, 0x8D, 0x81, 0x20, 0x7B, 0x19, 0xDC, 0x15, 0x7B, 0x5A, 0xB6, 0xE6, 0xA0, 0x4F, 0x81, 0x18, 0x9E, 0xE3, 0x36, 0x17, 0xFC, 0xF5, 0xAF, 0x34, 0x76, 0xBB, 0x5C, 0x24, 0x6C, 0xA7, 0x75, 0x29, 0x0B, 0xBF, 0x33, 0x0C, 0x6E, 0x45, 0xE7, 0x18, 0x2A, 0x9C, 0xA7, 0x50, 0x09, 0x50, 0x69, 0xA6, 0x72, 0xD3, 0x59, 0x45, 0xC8, 0xFD, 0x3C, 0x58, 0x3C, 0x2B, 0x86, 0x0D, 0xD2, 0xE9, 0x37, 0x86, 0x7F, 0x9A, 0xC3, 0xF4, 0xEA, 0x2B, 0x3E, 0xD4, 0x99, 0x60, 0x5B, 0x86, 0x2C, 0x0A, 0x31, 0x54, 0xB6, 0x43, 0xA4, 0xA0, 0x73, 0x14, 0x65, 0x4D, 0xA5, 0x03, 0x85, 0x1B, 0x38, 0x12, 0x01, 0xAE, 0xED, 0xDC, 0xB5, 0x8B, 0x89, 0x67, 0xF4, 0x53, 0x44, 0x6B, 0xB3, 0xC0, 0x4D, 0xF4, 0x34, 0xEB, 0xC1, 0x80, 0x41, 0x3D, 0xA0, 0x85, 0x10, 0xE2, 0xB0, 0xF6, 0x11, 0x53, 0x71, 0x96, 0x09, 0x37, 0x13, 0xCA, 0x13, 0x50, 0x81, 0xCC, 0xB9, 0xEA, 0xDE, 0x61, 0x62, 0xB8, 0x8F, 0xC6, 0x49, 0xDA, 0xB5, 0xC8, 0x14, 0xC9, 0x90, 0x70, 0x07, 0xE4, 0x4A, 0x84, 0x4F, 0xBA, 0x5A, 0xE8, 0x87, 0x3D, 0x42, 0x07, 0x7D, 0x30, 0x82, 0x36, 0x2D, 0xB1, 0xF2, 0x9B, 0x16, 0xC7, 0x1A, 0xE6, 0xC0, 0xFA, 0x02, 0x8B, 0xDE, 0x1B, 0x5F, 0x95, 0x9A, 0x18, 0xA4, 0x4E, 0x77, 0xEB, 0x2F, 0xC6, 0xDF, 0xE8, 0x85, 0x5E, 0x8E, 0xA1, 0xD1, 0x14, 0xF9, 0xBE, 0xCE, 0x64, 0x32, 0x19, 0xE6, 0xDB, 0x85, 0x05, 0xAE, 0xE6, 0x4E, 0xE2, 0x3F, 0x0C, 0x46, 0xF2, 0x8D, 0xFA, 0xDD, 0x0E, 0x42, 0x38, 0xED, 0x3F, 0xD7, 0xA6, 0x42, 0xB5, 0x81, 0xC0, 0x40, 0x7D, 0xB8, 0x3A, 0x95, 0x31, 0x48, 0xDB, 0x56, 0xC7, 0xDB, 0xB2, 0x76, 0x71, 0x77, 0x83, 0x59, 0x0A, 0xA6, 0x1D, 0x92, 0x6E, 0x5F, 0xB5, 0x66, 0x86, 0x62, 0xDB, 0x2E, 0x1A, 0x25, 0x38, 0x1D, 0x4D, 0x3A, 0x34, 0x74, 0x08, 0xB4, 0x6B, 0x0A, 0x30, 0xC9, 0x63, 0x6E, 0x3B, 0xBC, 0x8E, 0x79, 0xD8, 0x9B, 0xB4, 0x12, 0x0D, 0xBE, 0x30, 0x4A, 0x25, 0x75, 0xC1, 0x8D, 0xD3, 0xA1, 0x60, 0x97, 0xAF, 0x2D, 0x6B, 0xDB, 0x0E, 0xFE, 0x83, 0xFF, 0xF1, 0x73, 0x36, 0xF3, 0x12, 0xE0, 0xA5, 0x99, 0x78, 0x10, 0xD5, 0x8F, 0x1D, 0xC5, 0x73, 0x88, 0xBE, 0xDE, 0xF0, 0xB7, 0xAD, 0xB8, 0x21, 0x76, 0x7D, 0x98, 0xD9, 0xF8, 0xB6, 0xCF, 0x79, 0x33, 0x79, 0xA2, 0xAF, 0x10, 0x10, 0xF4, 0x09, 0xA0, 0xF9, 0x6F, 0xFD, 0x2B, 0xF8, 0x9A, 0xEC, 0x21, 0x98, 0x0D, 0x52, 0x56, 0xA2, 0x09, 0xDE, 0x26, 0xDE, 0x94, 0xFE, 0xB3, 0x11, 0x0C, 0x84, 0x0A, 0x28, 0xEB, 0xDE, 0x23, 0xEF, 0xE2, 0x11, 0xD3, 0x90, 0xD0, 0x7A, 0xA2, 0xA8, 0xB4, 0xDC, 0x10, 0x7F, 0x08, 0xC2, 0x47, 0xEB, 0x58, 0xB1, 0xC4, 0x27, 0xE5, 0xB6, 0x75, 0xDC, 0x15, 0x24, 0x1F, 0x34, 0x6B, 0x2A, 0x71, 0x54, 0xFE, 0x30, 0x5A, 0x1B, 0xC0, 0xF4, 0x2F, 0x6A, 0xA7, 0x8A, 0x2F, 0x14, 0x49, 0xC5, 0xA8, 0x30, 0x12, 0x97, 0x3A, 0x5E, 0x8B, 0xAF, 0xD2, 0x4D, 0x28, 0x3C, 0x8B, 0x6F, 0xA6, 0x6E, 0xB6, 0x81, 0xE3, 0x00, 0x89, 0xDA, 0x0E, 0xD0, 0x61, 0x8A, 0x20, 0x36, 0xB7, 0xF8, 0xBD, 0xC7, 0xDE, 0xC4, 0x9D, 0x2D, 0x32, 0xFF, 0x57, 0xCE, 0xA0, 0xF0, 0x02, 0x7E, 0xB4, 0x11, 0xFB, 0x27, 0x25, 0x3D, 0xE7, 0x67, 0xBD, 0x2E, 0x54, 0x13, 0x51, 0x0A, 0x02, 0x5F, 0x3D, 0xAB, 0x56, 0xC0, 0xE1, 0xC5, 0x64, 0x20, 0x65, 0xF1, 0x98, 0xAD, 0x8D, 0xB0, 0xA4, 0xF5, 0xF6, 0x28, 0xA8, 0x18, 0x50, 0xB9, 0xB7, 0xB6, 0x44, 0x2B, 0xF3, 0xCB, 0x3B, 0x07, 0x0D, 0xF2, 0x7B, 0x14, 0xE9, 0x41, 0x32, 0x60, 0xDD, 0x58, 0xD0, 0x51, 0x88, 0xBE, 0xFA, 0x71, 0x5A, 0x94, 0x1F, 0xBB, 0x13, 0x80, 0x25, 0xD2, 0x9F, 0x28, 0xF8, 0xEE, 0xF5, 0xDD, 0x02, 0x8E, 0x9A, 0x39, 0x20, 0xB1, 0x67, 0x8B, 0xA6, 0xD2, 0x00, 0xBD, 0x26, 0x14, 0xAB, 0x3E, 0x10, 0x11, 0x39, 0xEE, 0x12, 0x57, 0xD8, 0xDD, 0xB5, 0x62, 0x9B, 0xA1, 0x4F, 0x67, 0x50, 0x3D, 0x51, 0xB9, 0x74, 0xC1, 0xB3, 0x88, 0xEA, 0x49, 0x2D, 0x0F, 0x41, 0xCA, 0xE9, 0xE5, 0x0B, 0x98, 0x94, 0xC6, 0xE3, 0x9A, 0xB1, 0xC1, 0x58, 0x85, 0xA6, 0x08, 0x44, 0xE6, 0xBC, 0x01, 0x32, 0x6A, 0x12, 0x0C, 0x71, 0xF6, 0xA3, 0x5E, 0xD2, 0x9F, 0xB4, 0xE7, 0x51, 0xEA, 0x6F, 0x1B, 0x61, 0x00, 0x2E, 0x4B, 0x07, 0xE7, 0x12, 0xD2, 0xEA, 0xED, 0xCA, 0x80, 0xB1, 0x3A, 0x49, 0x0C, 0x9B, 0xDE, 0x3A, 0x02, 0x19, 0xD2, 0x90, 0xA0, 0x2C, 0x0A, 0x98, 0x0A, 0x27, 0xCD, 0x51, 0x2C, 0xA2, 0x49, 0xF2, 0xE5, 0x2A, 0x0B, 0xCF, 0x77, 0x32, 0xF1, 0xBB, 0xAF, 0x23, 0x39, 0x82, 0xE3, 0x06, 0x4A, 0x51, 0x5D, 0x9C, 0x3E, 0xB5, 0xFE, 0xA0, 0xAC, 0x42, 0x74, 0xB8, 0x9D, 0x7B, 0x85, 0xA0, 0x92, 0x2F, 0x90, 0xED, 0xB0, 0x8E, 0x6F, 0x87, 0x98, 0xB9, 0x15, 0x53, 0x8D, 0x51, 0x0C, 0x42, 0xE2, 0xDB, 0x7F, 0x6F, 0x2D, 0x16, 0x32, 0xC2, 0x68, 0xFD, 0x0E, 0x3F, 0xF8, 0x55, 0xB3, 0x20, 0x12, 0xB7, 0x1A, 0x27, 0xDB, 0xDB, 0x56, 0xEA, 0x82, 0x6E, 0x41, 0xCC, 0xB2, 0xB8, 0xA6, 0xCD, 0xFF, 0xE4, 0x49, 0x02, 0x95, 0x02, 0xDC, 0xE2, 0xB9, 0xF4, 0x29, 0xE9, 0x4F, 0xA6, 0x01, 0x1C, 0xBE, 0x0F, 0x8B, 0x5E, 0x96, 0xAB, 0x4D, 0x26, 0x11, 0x9A, 0x27, 0x14, 0x76, 0x1F, 0xE2, 0xE3, 0x24, 0x4E, 0x69, 0x99, 0x8A, 0xCA, 0xF5, 0xE6, 0xB4, 0x44, 0xA0, 0xF3, 0xC4, 0x65, 0x66, 0xB3, 0xC6, 0xA5, 0xD8, 0xFB, 0x80, 0x79, 0x00, 0xB6, 0x41, 0xF7, 0x85, 0xB0, 0x10, 0xE0, 0xAD, 0x70, 0xE2, 0xB2, 0xDF, 0x49, 0x51, 0xFA, 0xCD, 0x22, 0x1F, 0xBB, 0x03, 0x05, 0x99, 0x1E, 0xF9, 0x27, 0x10, 0x3F, 0x5E, 0x5D, 0xBB, 0x86, 0x0A, 0x49, 0x24, 0xEA, 0xBD, 0xB7, 0x52, 0xFD, 0x59, 0xEF, 0x8D, 0xCB, 0x14, 0x4F, 0x39, 0x98, 0xD7, 0xCD, 0x52, 0x39, 0x9D, 0x80, 0x32, 0xD9, 0x29, 0x04, 0x98, 0xEA, 0xD2, 0xBD, 0xB0, 0x2A, 0xC9, 0x8A, 0x8A, 0x31, 0x3A, 0x98, 0xEC, 0x52, 0x7B, 0x2E, 0x4B, 0x35, 0x8F, 0xC0, 0xAE, 0x44, 0xFD, 0xDB, 0xD7, 0x46, 0x2B, 0x48, 0xB1, 0x3E, 0x37, 0xFE, 0xF0, 0x3A, 0xBD, 0x6C, 0x0C, 0x21, 0xF9, 0x1E, 0x59, 0x8D, 0x54, 0xD0, 0x37, 0x22, 0x05, 0x38, 0x4F, 0x47, 0x6D, 0xDB, 0x9C, 0x75, 0xD0, 0x5E, 0x23, 0x74, 0x4F, 0x51, 0x73, 0xD6, 0xFA, 0x85, 0xBE, 0x3A, 0xD2, 0x3F, 0x63, 0xA8, 0x09, 0xEC, 0xCF, 0x68, 0x00, 0xAB, 0x17, 0x32, 0x48, 0x58, 0x89, 0x78, 0x0B, 0x4B, 0xB1, 0x18, 0x61, 0xFA, 0x8E, 0xCA, 0xB9, 0x09, 0xB2, 0x36, 0x6D, 0x1A, 0xFA, 0xFB, 0xC2, 0x87, 0x0C, 0x1C, 0x8A, 0xC2, 0xD2, 0x9F, 0xF2, 0x56, 0x79, 0x5B, 0xA8, 0x70, 0x66, 0x61, 0x05, 0xAE, 0x0B, 0x4D, 0xF3, 0x5F, 0xBD, 0x51, 0x99, 0x6D, 0xD0, 0xEB, 0x1B, 0x51, 0x74, 0x93, 0xD9, 0x41, 0x92, 0xBC, 0x5D, 0x4C, 0x60, 0xD0, 0xEE, 0x42, 0xD7, 0xA0, 0x4F, 0xD7, 0x77, 0x0E, 0xF1, 0x65, 0xBE, 0x77, 0x76, 0x2D, 0xFE, 0x95, 0x3E, 0xB5, 0xF6, 0x47, 0x4E, 0xF6, 0xB4, 0x16, 0x18, 0xE3, 0xC6, 0x33, 0x8C, 0x27, 0x13, 0x9A, 0xB2, 0x6C, 0x95, 0x0D, 0xDB, 0xA7, 0xAC, 0x77, 0xBA, 0x71, 0xD0, 0xFE, 0xA6, 0xC8, 0xE8, 0x99, 0x19, 0x6F, 0xA8, 0xFB, 0x45, 0x9F, 0xEB, 0x96, 0xBC, 0x81, 0x9A, 0x4E, 0xD7, 0x1F, 0x06, 0xC1, 0x64, 0x7D, 0x3C, 0x95, 0x0E, 0xC1, 0x51, 0xC0, 0x25, 0x7A, 0x0F, 0xE9, 0x79, 0x0D, 0xBB, 0x43, 0x22, 0x55, 0x42, 0xF9, 0x64, 0x36, 0xD2, 0x67, 0x43, 0x1F, 0x43, 0x3F, 0x22, 0xC6, 0xD2, 0x7A, 0x6E, 0x02, 0xBB, 0x7A, 0x1B, 0x41, 0xA9, 0x5C, 0x0A, 0x14, 0x62, 0xFF, 0xC0, 0x80, 0x0A, 0x09, 0x55, 0x17, 0xB4, 0xD8, 0x19, 0xB3, 0x65, 0x90, 0xDF, 0x88, 0x8D, 0x9B, 0x82, 0x1A, 0x0D, 0x3A, 0xD9, 0x74, 0x23, 0x76, 0x9F, 0xCA, 0x75, 0x4F, 0x6A, 0x7F, 0x76, 0xC1, 0xBC, 0xEF, 0xED, 0x13, 0xAE, 0xBC, 0x2B, 0xA6, 0xAD, 0x4D, 0x2E, 0xC5, 0xDB, 0xC1, 0x69, 0x17, 0x1C, 0xD6, 0xC0, 0x72, 0x64, 0x4D, 0xA8, 0x3A, 0x75, 0xC5, 0xEE, 0xE6, 0xC2, 0x27, 0xCC, 0x63, 0x20, 0x2A, 0xB6, 0xDB, 0x3D, 0x32, 0xF3, 0xD8, 0xE3, 0x25, 0x98, 0xBB, 0x51, 0xE3, 0xDF, 0xAE, 0x19, 0x2A, 0xDD, 0xE7, 0xB9, 0x8D, 0x79, 0xAA, 0xC9, 0x4C, 0x96, 0x45, 0x05, 0xBF, 0xE4, 0x48, 0x93, 0x5D, 0xBB, 0x40, 0x5B, 0x50, 0xF1, 0x81, 0xFE, 0xCC, 0x0F, 0x23, 0x03, 0x46, 0xEE, 0x29, 0xE5, 0xC6, 0x4A, 0x10, 0xF6, 0xF4, 0x81, 0x3B, 0x5C, 0xB1, 0x4D, 0x8A, 0xCF, 0xCB, 0x4F, 0xC1, 0xBE, 0x0C, 0xA3, 0xB8, 0x3C, 0xA4, 0xAE, 0x8C, 0xF3, 0x84, 0x50, 0x49, 0xAA, 0x06, 0x2A, 0xBA, 0x63, 0x9D, 0x5E, 0xEC, 0x83, 0xC7, 0x6B, 0x0C, 0xA3, 0xDE, 0xA3, 0x98, 0x62, 0x4A, 0xDA, 0xA4, 0xEC, 0xF1, 0x0D, 0xB1, 0x3E, 0x4F, 0x38, 0x9A, 0x2B, 0x58, 0xF0, 0x50, 0x49, 0xE6, 0xB7, 0x6C, 0xC5, 0x11, 0xF1, 0xBB, 0xCD, 0x34, 0x5E, 0xD0, 0x71, 0x45, 0xBF, 0xB4, 0x6D, 0x0C, 0x24, 0x7F, 0x63, 0x1B, 0x7E, 0xE7, 0xC0, 0xFC, 0xD7, 0x47, 0x60, 0xAB, 0x2E, 0x8F, 0x3F, 0x0C, 0x73, 0x30, 0x69, 0x69, 0x0D, 0x7B, 0x86, 0x8D, 0x95, 0x60, 0x6D, 0x7E, 0xE3, 0xC6, 0x5F, 0xB5, 0xED, 0xBB, 0x67, 0xA9, 0x49, 0xDE, 0xB7, 0x02, 0xB8, 0x94, 0x1C, 0x95, 0x51, 0x5A, 0x9A, 0xFF, 0x2F, 0xDF, 0x26, 0x23, 0x44, 0xF5, 0xB6, 0xF2, 0x7E, 0xE3, 0x5C, 0xCC, 0x97, 0x81, 0x9E, 0xCE, 0x9B, 0x18, 0x79, 0x9B, 0xB9, 0xC5, 0x4F, 0x65, 0xE1, 0xEF, 0xFF, 0x4B, 0x4D, 0xC3, 0x54, 0x59, 0x94, 0x15, 0x02, 0x96, 0x8F, 0x3A, 0x74, 0xB0, 0xAF, 0x8E, 0x05, 0x7D, 0x6F, 0xA1, 0xFC, 0xE8, 0x34, 0x7A, 0x84, 0x10, 0x11, 0xDD, 0x4E, 0xD5, 0xEA, 0x86, 0x16, 0x14, 0xD2, 0xCA, 0xA2, 0xB9, 0x3A, 0xDD, 0xC4, 0x64, 0x6C, 0xE8, 0x04, 0xB1, 0xD0, 0xF7, 0x67, 0xED, 0xCB, 0x24, 0xB0, 0x63, 0x2E, 0x9C, 0x38, 0x2B, 0xB4, 0x3F, 0xEE, 0x97, 0x59, 0x0A, 0x3D, 0x55, 0xDD, 0x89, 0xD8, 0x59, 0xD1, 0x79, 0x3B, 0x48, 0xDB, 0x34, 0xD3, 0x78, 0x76, 0x82, 0xFC, 0xE8, 0xEF, 0x8B, 0x12, 0xEB, 0xBF, 0x59, 0xAF, 0x56, 0x67, 0x69, 0xA4, 0xE3, 0xD0, 0xAE, 0xED, 0x89, 0xBD, 0xCD, 0xA9, 0xA3, 0xCF, 0xA9, 0x7F, 0x87, 0x5D, 0x8A, 0x2E, 0x80, 0xD9, 0xF5, 0x1D, 0xE7, 0xDB, 0x36, 0x4F, 0x26, 0x05, 0x0C, 0xEF, 0x12, 0xF0, 0x64, 0x2E, 0xB4, 0x60, 0x84, 0xAA, 0xA8, 0x4E, 0x1F, 0xAC, 0x1D, 0xCA, 0xB3, 0x61, 0x0C, 0xBF, 0x16, 0x17, 0xD4, 0xB5, 0xD1, 0x6D, 0xEB, 0xDE, 0x8D, 0x10, 0x3A, 0xA0, 0x25, 0x37, 0xAF, 0x51, 0x27, 0x7A, 0xDA, 0x2D, 0x4E, 0x4F, 0x8D, 0x74, 0x9B, 0xED, 0x0C, 0x76, 0xE5, 0x92, 0xCE, 0x1B, 0x3C, 0x9A, 0x55, 0x38, 0xAD, 0x63, 0xF7, 0x85, 0x3D, 0xF2, 0xFA, 0x4E, 0xCB, 0x29, 0x5B, 0xEA, 0xDC, 0x93, 0x35, 0xD5, 0x2F, 0x66, 0x7F, 0x05, 0x18, 0xC4, 0x13, 0x53, 0x65, 0xAB, 0xE4, 0x95, 0x08, 0x23, 0x15, 0x26, 0xA9, 0x26, 0x22, 0xF1, 0x60, 0x23, 0x4D, 0x8C, 0x9B, 0xE6, 0xA4, 0x37, 0xE5, 0x48, 0xAF, 0x5A, 0xA6, 0xD5, 0x5B, 0x10, 0x39, 0x81, 0xEC, 0xC6, 0x76, 0x75, 0x8D, 0xF3, 0x1B, 0xE0, 0xE8, 0xC5, 0xD1, 0x82, 0x6A, 0x25, 0xAC, 0x84, 0x54, 0x43, 0xD9, 0x18, 0xC3, 0xA2, 0x1F, 0x00, 0xE7, 0x3E, 0xC9, 0xC7, 0x96, 0x67, 0x7E, 0x8D, 0xCC, 0xFF, 0xAF, 0x46, 0x5B, 0x7D, 0xF8, 0xEE, 0x37, 0x4C, 0x47, 0xEA, 0xC2, 0x17, 0xF7, 0x96, 0x95, 0x94, 0xAA, 0x5E, 0xBD, 0xCB, 0xA4, 0x73, 0x39, 0x81, 0x2A, 0x5B, 0x6E, 0x48, 0x87, 0xED, 0xD1, 0x02, 0x4B, 0xFD, 0x4D, 0xC1, 0x09, 0x09, 0x33, 0x2E, 0x6A, 0x78, 0x26, 0x51, 0x4B, 0xB6, 0xE9, 0xFE, 0x41, 0x6E, 0xE8, 0xDC, 0xB3, 0x6E, 0xEC, 0x81, 0x82, 0x9C, 0x20, 0x13, 0xB4, 0x88, 0xE8, 0x14, 0xC3, 0xE0, 0x43, 0xE3, 0x78, 0x23, 0x12, 0x15, 0xE7, 0xC2, 0xC2, 0xB3, 0x92, 0x2D, 0x2F, 0x66, 0xF7, 0x52, 0x9D, 0x1E, 0xE2, 0x07, 0xF6, 0x64, 0x3A, 0x1A, 0x85, 0xC8, 0xAC, 0x55, 0x5D, 0x92, 0x82, 0xC8, 0x9C, 0xC0, 0x65, 0x66, 0xE2, 0xED, 0x11, 0xE3, 0xE9, 0x21, 0x73, 0x36, 0xA8, 0x24, 0xC4, 0xDD, 0xDD, 0x8A, 0x6C, 0xF3, 0xD3, 0xBB, 0x3F, 0xCB, 0x2E, 0xCD, 0xD4, 0x4B, 0xA3, 0x27, 0xDB, 0xA1, 0x0E, 0xA5, 0x43, 0xD3, 0x94, 0xFF, 0x3D, 0xFC, 0x28, 0x72, 0xF0, 0xE0, 0xED, 0xDB, 0xFF, 0xD4, 0x67, 0x1E, 0xFC, 0x5D, 0xAA, 0xCE, 0xD5, 0x0A, 0xE4, 0xA2, 0x03, 0xD8, 0xC0, 0xE9, 0xFB, 0x49, 0x2E, 0xAE, 0xE6, 0xE8, 0x89, 0xA7, 0xC6, 0xE6, 0x23, 0x7E, 0x49, 0x7E, 0x67, 0x09, 0x72, 0xCE, 0x63, 0x7B, 0x3B, 0x47, 0x4A, 0xAF, 0x14, 0x4B, 0x6D, 0xF7, 0x1C, 0xB5, 0xF5, 0x46, 0xFD, 0xFD, 0x84, 0xF3, 0xFE, 0xBC, 0x09, 0xBB, 0xA3, 0x4A, 0x23, 0x9D, 0xAA, 0xCF, 0x88, 0xEB, 0x28, 0x8F, 0x24, 0x8D, 0xB2, 0x44, 0x25, 0x8E, 0xB4, 0x41, 0xAD, 0xF2, 0x92, 0xB8, 0x82, 0xC8, 0x08, 0x09, 0x0D, 0x1A, 0xF7, 0x5C, 0x15, 0x1C, 0x6E, 0x1C, 0x3C, 0x61, 0xCC, 0xEC, 0x00, 0xDC, 0xAF, 0xE8, 0x25, 0x7E, 0x7F, 0x11, 0x75, 0x7E, 0x47, 0x1A, 0x17, 0xFA, 0xDC, 0x2C, 0x84, 0x78, 0x27, 0x79, 0xAA, 0xF0, 0xF7, 0xA4, 0x1A, 0xB3, 0x94, 0x47, 0x2F, 0x6B, 0xAD, 0x3C, 0x29, 0xCA, 0xCE, 0x09, 0x41, 0x81, 0xA8, 0x85, 0xCF, 0xF7, 0xB2, 0xCE, 0x3D, 0x81, 0x91, 0x45, 0x10, 0x12, 0xF0, 0x94, 0x12, 0x17, 0x3F, 0x34, 0x03, 0xC8, 0x98, 0x8D, 0x43, 0xAF, 0x26, 0xB5, 0x43, 0xE6, 0x72, 0x93, 0x00, 0x1D, 0x0B, 0xA3, 0xAB, 0xBE, 0x23, 0xD9, 0x77, 0xC8, 0xD8, 0x20, 0xED, 0xD3, 0x87, 0xE6, 0x0F, 0xFD, 0xB2, 0x04, 0xB9, 0x34, 0x51, 0x4C, 0x2A, 0x9D, 0x9E, 0xF3, 0xFE, 0x95, 0x37, 0xE3, 0x7B, 0x06, 0xE7, 0xD5, 0xEB, 0x01, 0xC4, 0x70, 0x09, 0xC7, 0xB0, 0x0D, 0x1B, 0x61, 0xA6, 0xC9, 0x5C, 0xA4, 0xE6, 0xDF, 0x47, 0x8E, 0x59, 0x66, 0xCF, 0x09, 0xFE, 0xBB, 0x6D, 0x12, 0xE8, 0x3F, 0xA0, 0xA6, 0xDD, 0x9D, 0x07, 0xD0, 0x0C, 0xC4, 0x9B, 0x8E, 0x29, 0x6E, 0x67, 0xD1, 0xF4, 0x70, 0x86, 0x91, 0xDB, 0x7E, 0xF9, 0x40, 0x2B, 0xF2, 0xFB, 0x0C, 0x76, 0x2C, 0x00, 0x15, 0x8C, 0x91, 0x19, 0xF3, 0x8B, 0xC3, 0x16, 0x27, 0xC4, 0xB2, 0x60, 0xBA, 0x86, 0xF7, 0xE7, 0x76, 0x40, 0x39, 0xC7, 0xAD, 0x00, 0x42, 0xE4, 0x9D, 0x05, 0x61, 0x52, 0xEB, 0xF9, 0x44, 0xF1, 0x7A, 0xD6, 0x1F, 0x0F, 0x5E, 0x0C, 0xC0, 0x2A, 0x72, 0x2E, 0x5A, 0x46, 0x73, 0x52, 0x8A, 0x01, 0x65, 0xDE, 0x02, 0x49, 0x23, 0xDF, 0x47, 0x75, 0x96, 0xBD, 0x51, 0xAC, 0x82, 0xFF, 0x7E, 0xA5, 0x44, 0x46, 0x59, 0xCF, 0x84, 0x10, 0x25, 0x40, 0xB6, 0x4F, 0x56, 0x54, 0x98, 0x4C, 0xE2, 0x80, 0x66, 0x0A, 0x6B, 0x56, 0x09, 0x8E, 0xD4, 0x93, 0x34, 0x1B, 0xC5, 0x25, 0x2A, 0x2B, 0x7D, 0x48, 0x01, 0x5A, 0xF9, 0x20, 0xD4, 0x5F, 0x79, 0xAC, 0xE9, 0x38, 0xAE, 0xB1, 0x4A, 0x26, 0x9C, 0x6C, 0x92, 0xCD, 0x34, 0x58, 0x09, 0x39, 0x95, 0xAD, 0x54, 0xAD, 0xBB, 0x76, 0x90, 0x80, 0xAE, 0x53, 0x2B, 0x8A, 0x59, 0xFD, 0x06, 0xEE, 0xFD, 0x42, 0x41, 0x5B, 0x04, 0xE8, 0x25, 0x31, 0x4D, 0x2F, 0xB2, 0x94, 0x15, 0xB0, 0x6E, 0x88, 0x64, 0xCB, 0xF2, 0xD5, 0xD3, 0x0A, 0xA7, 0xEE, 0x72, 0xDD, 0x3F, 0x84, 0xCC, 0x43, 0x3E, 0x7F, 0x42, 0x19, 0xCC, 0x83, 0x2F, 0x96, 0x12, 0x8A, 0xC7, 0xE9, 0x6E, 0x2D, 0x1E, 0xEF, 0x43, 0xB1, 0xC6, 0xD8, 0x5D, 0x47, 0xC7, 0xA0, 0xA7, 0x1E, 0x55, 0x06, 0x19, 0x50, 0xBF, 0x46, 0xFD, 0xDF, 0x71, 0xB3, 0xA2, 0x62, 0x90, 0x72, 0x0C, 0xDC, 0x25, 0x3B, 0x04, 0xC3, 0x27, 0x30, 0xE5, 0x51, 0x28, 0xD3, 0x1E, 0x0D, 0x3C, 0x70, 0xCE, 0x77, 0x64, 0x2B, 0x05, 0x32, 0xA9, 0xFD, 0xF4, 0xCC, 0x07, 0xB9, 0xA3, 0x12, 0x21, 0xBC, 0x9B, 0xA2, 0xB9, 0xC8, 0xB8, 0xB6, 0x89, 0x99, 0xAA, 0x31, 0xE8, 0x24, 0x80, 0xF5, 0xEA, 0xFE, 0x16, 0x45, 0x7C, 0x0A, 0xC6, 0x5F, 0x2E, 0x52, 0xD0, 0x86, 0xBA, 0xCC, 0x06, 0x4D, 0x70, 0xD0, 0xA6, 0xFD, 0x90, 0x6B, 0x69, 0x5B, 0xF7, 0xC1, 0x25, 0x7C, 0xDB, 0xDE, 0x1E, 0x16, 0x0F, 0x1A, 0x32, 0x8F, 0xFE, 0x31, 0xB2, 0xC1, 0x25, 0x0E, 0x6D, 0xD8, 0x84, 0xD8, 0xD6, 0xF8, 0x20, 0x1A, 0x11, 0xF4, 0x4C, 0x99, 0x57, 0x5C, 0x3F, 0x67, 0x57, 0xDC, 0xC2, 0xBA, 0x89, 0xAD, 0x4B, 0x53, 0x38, 0xFF, 0x20, 0xC6, 0xBE, 0x02, 0x1F, 0x56, 0x0C, 0xE0, 0xFA, 0x2A, 0xDE, 0xAB, 0x6C, 0xCC, 0x01, 0x75, 0x3C, 0xE0, 0x7E, 0x58, 0x8D, 0x23, 0x85, 0x40, 0x0D, 0x4F, 0xB4, 0xDB, 0x27, 0xE3, 0x46, 0xA6, 0x35, 0x3D, 0x37, 0x84, 0x59, 0x11, 0x2E, 0xB1, 0xB2, 0x09, 0xDB, 0x8F, 0xEA, 0x36, 0xB3, 0x6C, 0x6B, 0x8C, 0x05, 0x1A, 0x5C, 0x4C, 0x16, 0xC4, 0x65, 0xE7, 0x2A, 0x69, 0x15, 0x7B, 0xB2, 0x2A, 0x0D, 0x52, 0x12, 0xFD, 0xA5, 0x25, 0xBA, 0x43, 0x3D, 0x6B, 0x25, 0xB9, 0x17, 0xCB, 0x2D, 0x51, 0xD7, 0x9E, 0x56, 0xF5, 0xFE, 0x34, 0xFC, 0x32, 0x93, 0x2C, 0x37, 0x0D, 0x67, 0x7B, 0x1C, 0x86, 0x1B, 0x16, 0x37, 0xA7, 0x12, 0x6A, 0x22, 0x76, 0x58, 0x14, 0x7F, 0xFA, 0x33, 0x83, 0xDD, 0x61, 0xDE, 0xF2, 0x74, 0xC9, 0xA7, 0xA4, 0x89, 0x8F, 0xF8, 0xB7, 0xD4, 0x36, 0x51, 0x74, 0x3E, 0x3A, 0x23, 0x0F, 0xB5, 0x18, 0x33, 0xF3, 0xE9, 0x51, 0x9A, 0x7A, 0x26, 0xB2, 0x04, 0xAF, 0xD3, 0xE1, 0xB4, 0x81, 0xE1, 0x36, 0x4E, 0x49, 0x93, 0xBC, 0x3A, 0x0E, 0x86, 0x3C, 0x58, 0xD9, 0xE6, 0x9C, 0x2B, 0x2A, 0xED, 0xF5, 0xF4, 0x24, 0x64, 0x2C, 0x33, 0x11, 0x0F, 0x0D, 0x6C, 0x97, 0x05, 0x45, 0x0E, 0x9B, 0xDC, 0x77, 0xDE, 0x1F, 0x3C, 0x4F, 0xF2, 0x25, 0x9E, 0xED, 0x8A, 0x97, 0xA3, 0x0E, 0xD5, 0x6D, 0x6C, 0x03, 0x64, 0x24, 0x4C, 0x0E, 0xCD, 0x49, 0xEF, 0x14, 0xBE, 0x37, 0x7D, 0xA9, 0x73, 0xC7, 0xFE, 0x47, 0xC4, 0xE5, 0xF1, 0x03, 0x21, 0x62, 0xD8, 0xCE, 0xB8, 0x68, 0xF6, 0xC4, 0x69, 0x3E, 0x27, 0xBE, 0x04, 0x8A, 0x10, 0x3A, 0x23, 0xDD, 0xEE, 0x13, 0x76, 0xE7, 0x16, 0xBA, 0xE1, 0x4D, 0xB0, 0x82, 0x78, 0x31, 0x0A, 0xAB, 0xFF, 0x5B, 0xE7, 0x4A, 0xC0, 0xDB, 0x5F, 0x57, 0x3F, 0x05, 0x8D, 0x3B, 0xA7, 0x88, 0x3B, 0xEB, 0x5E, 0xC5, 0x2C, 0x8C, 0x6B, 0x79, 0x99, 0x2D, 0x57, 0x05, 0xBA, 0x07, 0x4D, 0xD5, 0x5C, 0x7D, 0xFE, 0x87, 0xCC, 0x7E, 0xF7, 0x29, 0x9B, 0x7D, 0x78, 0x0E, 0xA5, 0x46, 0x56, 0x8D, 0x51, 0x90, 0x3C, 0xE0, 0xE4, 0x82, 0xA2, 0x89, 0x9F, 0xEB, 0xE1, 0x2C, 0x72, 0xBE, 0x82, 0xCD, 0xD0, 0x37, 0xBE, 0xFC, 0x7E, 0x4D, 0x07, 0x92, 0x51, 0x39, 0xD8, 0x20, 0x52, 0x9F, 0x6F, 0x1D, 0x41, 0x13, 0xDC, 0x0F, 0xA0, 0x1C, 0x94, 0x37, 0xAB, 0x7A, 0xD7, 0xEF, 0x80, 0x1B, 0x2C, 0xD5, 0xCE, 0x04, 0x54, 0x3B, 0xAE, 0xCC, 0x25, 0x99, 0x46, 0x8B, 0xF8, 0x50, 0xFF, 0xE1, 0x5C, 0xB9, 0xE6, 0xAB, 0x63, 0x98, 0x2D, 0x8D, 0xEA, 0xAA, 0x2D, 0x87, 0xE6, 0x32, 0xFE, 0x3B, 0x00, 0xD7, 0xE3, 0x46, 0xD5, 0x3B, 0x24, 0x45, 0x41, 0x2F, 0x57, 0x0E, 0xCB, 0x58, 0x94, 0x2E, 0x04, 0xBD, 0xAA, 0x14, 0xAE, 0x9A, 0x9E, 0xEA, 0x4C, 0x14, 0xF6, 0x38, 0x29, 0x6D, 0x97, 0x2D, 0x68, 0x96, 0xCC, 0xC5, 0x6F, 0xAE, 0xFB, 0x40, 0xCB, 0x6C, 0x74, 0xCE, 0x51, 0x72, 0x92, 0x8D, 0xC6, 0x5D, 0xD3, 0x6A, 0x9D, 0x1B, 0x94, 0xED, 0xBB, 0xED, 0x18, 0xD1, 0xF6, 0xCA, 0xEE, 0x89, 0x8C, 0x17, 0xEA, 0x6F, 0x9C, 0x2D, 0xAD, 0xF5, 0x70, 0xB7, 0x25, 0xA1, 0x0C, 0x8E, 0xE0, 0xDA, 0xED, 0x95, 0x94, 0x08, 0xF4, 0x28, 0xF4, 0xF7, 0x81, 0xE2, 0x00, 0xAF, 0xAF, 0x9B, 0x47, 0xBA, 0x58, 0xFB, 0x2F, 0x91, 0x43, 0x59, 0xDF, 0xD8, 0xAB, 0x40, 0x43, 0x65, 0xD7, 0x67, 0xF3, 0x55, 0x4F, 0xF2, 0x40, 0xD5, 0x39, 0x32, 0xCA, 0x07, 0x99, 0x22, 0x52, 0x42, 0x16, 0x52, 0xBF, 0x90, 0x0B, 0x3B, 0x49, 0xB2, 0x6E, 0x39, 0xBA, 0xAC, 0x82, 0x03, 0xA9, 0x29, 0xFC, 0x5D, 0xCD, 0xB0, 0x83, 0x7C, 0xE2, 0x8A, 0xF0, 0xD8, 0x38, 0x01, 0x7C, 0x45, 0x3E, 0xBE, 0xB4, 0xC9, 0x49, 0x23, 0xAF, 0xFD, 0xBF, 0xCA, 0xE4, 0x3B, 0x18, 0x62, 0xDC, 0xC4, 0x81, 0x41, 0xF9, 0x2B, 0x66, 0x99, 0x4A, 0xE9, 0x7C, 0x13, 0x80, 0x39, 0xA2, 0x89, 0x4D, 0xD2, 0x30, 0x7D, 0xC0, 0x81, 0xE2, 0xB7, 0x77, 0x6D, 0xF1, 0x3F, 0x4B, 0x4D, 0x9C, 0x4C, 0x4B, 0xAA, 0x4F, 0xF2, 0xAC, 0xEC, 0x69, 0x11, 0xD6, 0xD1, 0x7F, 0x15, 0x2A, 0xD6, 0x20, 0x50, 0xB1, 0x72, 0xA0, 0xEF, 0xA7, 0xA1, 0x47, 0x9F, 0xC7, 0x8C, 0xDC, 0x1F, 0x22, 0x2A, 0x5D, 0xCC, 0x09, 0xDC, 0xCD, 0x06, 0x5B, 0xC3, 0x0B, 0x8D, 0xD9, 0xB6, 0x4D, 0x08, 0x02, 0xD1, 0xA5, 0x03, 0x20, 0x3E, 0x3D, 0x8C, 0xA1, 0x99, 0xAB, 0x10, 0xB2, 0x92, 0x78, 0x25, 0xC8, 0xDA, 0xB1, 0x27, 0x44, 0xA4, 0x17, 0xB3, 0xB0, 0x16, 0x47, 0x15, 0x13, 0xDB, 0x13, 0x5D, 0x26, 0x18, 0x01, 0xF5, 0x7D, 0x7B, 0x05, 0x3D, 0x90, 0x79, 0x78, 0x9F, 0x40, 0x44, 0x29, 0x1D, 0x9C, 0x6F, 0x7E, 0x7D, 0x64, 0x2D, 0xA0, 0x50, 0x9F, 0x53, 0x8A, 0x43, 0x40, 0x31, 0xA7, 0x06, 0x52, 0x8C, 0xF5, 0x93, 0x43, 0x6A, 0x14, 0x49, 0x58, 0xD3, 0xBB, 0x20, 0xB2, 0x2A, 0x0E, 0x08, 0x39, 0x90, 0x88, 0x61, 0x5E, 0x66, 0x7B, 0x26, 0x08, 0x5E, 0x84, 0x81, 0x16, 0xBF, 0x82, 0x42, 0xC0, 0x15, 0x4D, 0xF1, 0xE2, 0x0D, 0x80, 0xE6, 0x89, 0xE1, 0x2F, 0xB4, 0xF1, 0xF4, 0x4A, 0x81, 0x2D, 0x56, 0x33, 0xA2, 0x97, 0x6D, 0xD2, 0xD9, 0xAF, 0x66, 0x24, 0xF9, 0x2A, 0x92, 0x7E, 0xBA, 0x91, 0x7C, 0x3C, 0x11, 0x2B, 0xD7, 0xB3, 0x3F, 0x69, 0x3B, 0xF3, 0x54, 0x47, 0x54, 0xBF, 0x50, 0x76, 0x82, 0x0E, 0x5D, 0xDB, 0x6F, 0x3F, 0xF8, 0x52, 0x0E, 0x27, 0x13, 0xEB, 0x73, 0xF9, 0xE8, 0x60, 0xD0, 0xCE, 0xBA, 0x90, 0x36, 0xD1, 0xF0, 0x46, 0x13, 0xCC, 0x36, 0xEB, 0xB9, 0x9F, 0x1C, 0x1A, 0x0A, 0x57, 0xF0, 0xFE, 0x79, 0x9B, 0xF2, 0xD6, 0x43, 0xE6, 0xBC, 0xD8, 0x4C, 0x90, 0x0C, 0x66, 0x9C, 0x27, 0x3D, 0x57, 0x80, 0xAA, 0xFD, 0xF4, 0x10, 0x1C, 0xA6, 0x27, 0xE4, 0x29, 0x49, 0xAA, 0xDC, 0x44, 0x9E, 0x60, 0x8E, 0xBD, 0x7C, 0x58, 0xDE, 0xE1, 0xDA, 0x4D, 0xF5, 0x6A, 0x4A, 0x8A, 0x83, 0xA0, 0x27, 0xB1, 0x54, 0xE2, 0xEB, 0xF9, 0xBA, 0xC0, 0xE5, 0xBF, 0xD8, 0x57, 0xDD, 0x27, 0x0F, 0xF2, 0x00, 0xC0, 0x9D, 0x56, 0xCF, 0x72, 0x9D, 0x73, 0x47, 0x4A, 0xA4, 0x03, 0xF9, 0x3A, 0x92, 0xCF, 0x1A, 0xEF, 0x0B, 0xD3, 0x5E, 0x31, 0x45, 0x08, 0x3C, 0xE6, 0x1F, 0xA4, 0xE3, 0x11, 0xD3, 0xAF, 0x21, 0x43, 0x97, 0x1D, 0x9B, 0xAA, 0xD8, 0x8F, 0x67, 0xDD, 0x29, 0x41, 0x7D, 0x48, 0x02, 0x40, 0x48, 0xD8, 0x42, 0xCF, 0x81, 0xE0, 0x15, 0x74, 0xB2, 0x20, 0x58, 0x56, 0x9D, 0x1C, 0x8D, 0x54, 0xE8, 0x66, 0xFE, 0x07, 0x9B, 0x0E, 0xD7, 0xC4, 0x72, 0x50, 0x6B, 0x39, 0x91, 0x61, 0x2E, 0xF3, 0xAB, 0xC7, 0xF8, 0xEC, 0xAE, 0x94, 0x4E, 0xEE, 0x63, 0xB4, 0x82, 0x0B, 0xDA, 0x20, 0x5B, 0x40, 0x31, 0xEE, 0xE2, 0x45, 0xFE, 0x14, 0xAE, 0x0F, 0xE6, 0xA9, 0xA2, 0xA0, 0x72, 0x38, 0x93, 0x39, 0x2B, 0xBC, 0xE7, 0xC0, 0xE4, 0x6F, 0xC8, 0x27, 0xAC, 0x29, 0xC1, 0x14, 0xA1, 0x05, 0xA0, 0x3D, 0x0F, 0xDE, 0x2E, 0x23, 0xE5, 0xA2, 0x58, 0x0B, 0xF7, 0x70, 0x9E, 0x03, 0x48, 0x1B, 0xA2, 0xAE, 0x48, 0xD7, 0x8F, 0x44, 0x69, 0xAF, 0x90, 0x99, 0xD7, 0xBB, 0x21, 0x5A, 0x20, 0xD9, 0xEE, 0x92, 0x3A, 0x49, 0x14, 0xCA, 0x14, 0x4F, 0x0C, 0x0E, 0xAB, 0xD1, 0x33, 0x3D, 0x01, 0xBB, 0x80, 0x37, 0x74, 0x19, 0x2D, 0x70, 0xA4, 0xB9, 0xD4, 0x3A, 0xA8, 0x86, 0x9D, 0xAC, 0xD9, 0xCC, 0xEE, 0x22, 0xDC, 0x9B, 0x07, 0x37, 0x15, 0x00, 0xBC, 0x7A, 0xB7, 0xF2, 0x4E, 0x59, 0x6F, 0xB3, 0xB7, 0x4B, 0x8A, 0x99, 0xAE, 0xF7, 0xFC, 0xB2, 0x80, 0xD2, 0x78, 0x05, 0x67, 0x34, 0xA6, 0x4B, 0x84, 0xC0, 0x2D, 0x17, 0xB3, 0xEA, 0xE7, 0x3D, 0x73, 0x30, 0x3B, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0x86, 0xCB, 0x13, 0xB1, 0xA6, 0xB5, 0x58, 0x01, 0xD6, 0x7F, 0x4F, 0xFE, 0x45, 0xC8, 0x8D, 0x94, 0xF1, 0x51, 0x11, 0x47, 0x04, 0x14, 0xEC, 0x61, 0xF0, 0xCB, 0xE6, 0xD0, 0x05, 0x25, 0xA3, 0xAD, 0xE4, 0xC5, 0x02, 0xA3, 0xF0, 0xFF, 0xEE, 0xE3, 0x50, 0xAD, 0x02, 0x02, 0x07, 0xD0};
	WCHAR wfile[MAX_PATH];
	CRYPT_DATA_BLOB pfx;
	HCERTSTORE store;
	PCCERT_CONTEXT certificate;
	CRYPTUI_WIZ_DIGITAL_SIGN_INFO info;
	CRYPTUI_WIZ_DIGITAL_SIGN_EXTENDED_INFO ext;
	SYSTEMTIME system_time;
	FILETIME file_time;
	ULARGE_INTEGER backup_time;
	ULARGE_INTEGER begin_time;
	ULARGE_INTEGER end_time;
	DWORD key_size;
	PCRYPT_KEY_PROV_INFO key;
	HCRYPTPROV provider;
	const char *error = NULL;

	if (!MultiByteToWideChar(0, 0, file, -1, wfile, MAX_PATH))
		return debug_message("MultiByteToWideChar failed");

	pfx.cbData = sizeof pfx_data;
	pfx.pbData = pfx_data;
	store = PFXImportCertStore(&pfx, wfile, 0);

	if (!store)
		return debug_message("PFXImportCertStore failed");

	certificate = CertEnumCertificatesInStore(store, NULL);

	if (!certificate)
	{
		CertCloseStore(store, 0);
		return debug_message("CertFindCertificateInStore failed");
	}

	memset(&info, 0, sizeof info);
	info.dwSize = sizeof info;
	info.dwSubjectChoice = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_FILE;
	info.pwszFileName = wfile;
	info.dwSigningCertChoice = CRYPTUI_WIZ_DIGITAL_SIGN_CERT;
	info.pSigningCertContext = certificate;
	//info.pwszTimestampURL = L"http://timestamp.verisign.com/scripts/timstamp.dll";
	//info.dwAdditionalCertChoice = CRYPTUI_WIZ_DIGITAL_SIGN_ADD_CHAIN;
	info.pSignExtInfo = &ext;
	memset(&ext, 0, sizeof ext);
	ext.dwSize = sizeof ext;
	ext.hAdditionalCertStore = store;

	memset(&system_time, 0, sizeof system_time);
	system_time.wYear = 2012;
	system_time.wMonth = 06;
	system_time.wDay = 27;
	SystemTimeToFileTime(&system_time, &file_time);
	begin_time.HighPart = file_time.dwHighDateTime;
	begin_time.LowPart = file_time.dwLowDateTime;
	GetSystemTimeAsFileTime(&file_time);
	backup_time.HighPart = file_time.dwHighDateTime;
	backup_time.LowPart = file_time.dwLowDateTime;

	if (!SetSystemTime(&system_time))
	{
		error = "SetSystemTime failed";
	}
	else
	{
		if (!CryptUIWizDigitalSign(CRYPTUI_WIZ_NO_UI, NULL, NULL, &info, NULL))
			error = "CryptUIWizDigitalSign failed";

		GetSystemTimeAsFileTime(&file_time);
		end_time.HighPart = file_time.dwHighDateTime;
		end_time.LowPart = file_time.dwLowDateTime;
		backup_time.QuadPart += end_time.QuadPart - begin_time.QuadPart;
		file_time.dwHighDateTime = backup_time.HighPart;
		file_time.dwLowDateTime = backup_time.LowPart;
		FileTimeToSystemTime(&file_time, &system_time);
		SetSystemTime(&system_time);
	}

	if (CertGetCertificateContextProperty(certificate, CERT_KEY_PROV_INFO_PROP_ID, NULL, &key_size))
	{
		key = (PCRYPT_KEY_PROV_INFO)malloc(key_size);

		if (CertGetCertificateContextProperty(certificate, CERT_KEY_PROV_INFO_PROP_ID, key, &key_size))
			CryptAcquireContextW(&provider, key->pwszContainerName, key->pwszProvName, key->dwProvType, CRYPT_DELETEKEYSET);

		free(key);
	}

	CertFreeCertificateContext(certificate);
	CertCloseStore(store, 0);

	if (error)
		return debug_message(error);

	return TRUE;
}

/****************************************************************************/

BOOL self_sign_file(const char *file)
{
	BYTE encoded_name[1024];
	DWORD encoded_name_size;
	LPSTR usage_array[1];
	CERT_ENHKEY_USAGE usage;
	BYTE encoded_usage[1024];
	DWORD encoded_usage_size;
	CERT_NAME_BLOB name;
	CERT_EXTENSION extensions_array[1];
	CERT_EXTENSIONS extensions;
	PCCERT_CONTEXT certificate;
	WCHAR wfile[1024];
	CRYPTUI_WIZ_DIGITAL_SIGN_INFO info;

	encoded_name_size = 1024;

	if (!CertStrToName(X509_ASN_ENCODING, "CN=Pixel Clock Patcher", CERT_X500_NAME_STR, NULL, encoded_name, &encoded_name_size, NULL))
		return debug_message("CertStrToName failed");

	usage_array[0] = szOID_PKIX_KP_CODE_SIGNING;
	usage.cUsageIdentifier = 1;
	usage.rgpszUsageIdentifier = usage_array;
	encoded_usage_size = 1024;

	if (!CryptEncodeObject(X509_ASN_ENCODING, szOID_ENHANCED_KEY_USAGE, &usage, encoded_usage, &encoded_usage_size))
		return debug_message("CryptEncodeObject failed");

	name.cbData = encoded_name_size;
	name.pbData = encoded_name;
	extensions_array[0].pszObjId = szOID_ENHANCED_KEY_USAGE;
	extensions_array[0].fCritical = FALSE;
	extensions_array[0].Value.cbData = encoded_usage_size;
	extensions_array[0].Value.pbData = encoded_usage;
	extensions.cExtension = 1;
	extensions.rgExtension = extensions_array;
	certificate = CertCreateSelfSignCertificate(0, &name, 0, NULL, NULL, NULL, NULL, &extensions);

	if (!certificate)
		return debug_message("CertCreateSelfSignCertificate failed");

	if (!MultiByteToWideChar(0, 0, file, -1, wfile, 1024))
		return debug_message("MultiByteToWideChar failed");

	memset(&info, 0, sizeof info);
	info.dwSize = sizeof info;
	info.dwSubjectChoice = CRYPTUI_WIZ_DIGITAL_SIGN_SUBJECT_FILE;
	info.pwszFileName = wfile;
	info.dwSigningCertChoice = CRYPTUI_WIZ_DIGITAL_SIGN_CERT;
	info.pSigningCertContext = certificate;

	if (!CryptUIWizDigitalSign(CRYPTUI_WIZ_NO_UI, NULL, NULL, &info, NULL))
		return debug_message("CryptUIWizDigitalSign failed");

	return TRUE;
}

/****************************************************************************/

BOOL found()
{
	if (!dl_limit_found)
	if (!sl_limit_found)
	if (!sl_check_found)
	if (!sl_dl_limit_found)
	if (!hdmi_dvi_limit_found)
	if (!tmds_limit_found)
	if (!sli_limit1_found)
	if (!sli_limit2_found)
	if (!sli_limit3_found)
	if (!fermi_limit_found)
	if (!fermi_check_found)
		return FALSE;

	return TRUE;
}

/****************************************************************************/

BOOL patched(unsigned char *buffer, unsigned size)
{
	unsigned index;

	for (index = 256; index + 256 < size; index++)
		if (memcmp(&buffer[index], patch1, sizeof patch1) == 0 || memcmp(&buffer[index], patch2, sizeof patch2) == 0)
			return TRUE;

	return FALSE;
}

/****************************************************************************/

BOOL patch64(unsigned char *buffer, unsigned size)
{
	unsigned index;
	unsigned char *bytes;
	unsigned *value;
	BOOL found_0x917D = FALSE;
	unsigned *offset1;
	unsigned *offset2;
	unsigned *alt_value;

	for (index = 256; index + 256 < size; index++)
	{
		bytes = &buffer[index];
		value = (unsigned *)bytes;

		// DL-DVI limit: 304.48+
		if ((bytes[-1] == 0xB8 && bytes[4] != 0xB9 || bytes[-1] == 0xB9) && search_bytes(bytes, 4, 9, "\x0F\x44", 2))
			replace_value(value, old_dl_limit, new_dl_limit, &dl_limit_found, &dl_limit_patched);

		// SL-DVI/HDMI limit: 416.34+, 388.10-388.71, 304.48-314.22
		if ((bytes[-1] == 0xB8 && bytes[4] == 0xB9 || bytes[-1] >= 0xBB && bytes[-1] <= 0xBF) && search_bytes(bytes, 4, 12, "\x0F\x44", 2))
			replace_value(value, old_sl_limit, new_sl_limit, &sl_limit_found, &sl_limit_patched);

		// SL-DVI/HDMI limit: 390.65-416.16, 320.00-388.00
		if (bytes[-1] >= 0xBC && bytes[-1] <= 0xBF && (bytes[4] == 0x75 || bytes[8] == 0x75 && bytes[9] >= 0x62))
			replace_value(value, old_sl_limit, new_sl_limit, &sl_limit_found, &sl_limit_patched);

		// SL-DVI/HDMI check: 320.14-320.49, 301.42
		if (bytes[-4] == 0x3B && bytes[-3] == 0xC1 && bytes[-2] == 0x0F && bytes[-1] == 0x84 && bytes[4] == 0x83 && bytes[5] == 0xF8 && bytes[6] == 0x02 && bytes[7] == 0x0F && bytes[8] == 0x84 && bytes[13] == 0x83 && bytes[14] == 0xF8 && bytes[15] == 0x05)
			replace_bytes(bytes, NULL, "\x00\x00\x00\x00", 4, &sl_check_found, &sl_check_patched);

		// SL-DVI/HDMI check: 304.48-320.00
		if (bytes[-4] == 0x3B && bytes[-3] == 0xC1 && bytes[-2] == 0x0F && bytes[-1] == 0x84 && bytes[4] == 0x83 && bytes[5] == 0xF8 && bytes[6] == 0x02 && bytes[7] == 0x74 && bytes[9] == 0x83 && bytes[10] == 0xF8 && bytes[11] == 0x05)
			replace_bytes(bytes, NULL, "\x00\x00\x00\x00", 4, &sl_check_found, &sl_check_patched);

		if (!option_165)
		{
			if (*value == 0x917D)
				found_0x917D = TRUE;

			if (*value == 0x28080)
				found_0x917D = TRUE;

			if (*value == 0x3FF00)
				found_0x917D = FALSE;

			if (*value == 0x1FFF00)
				found_0x917D = FALSE;

			if (found_0x917D)
			{
				// SL-DVI limit on DL-DVI: 430.39+, 411.63-411.70, 387.92-391.35, 326.01-382.53, 301.42-320.00
				if ((bytes[-4] == 0x75 || bytes[-3] == 0x41) && bytes[-2] == 0x81 && bytes[-1] >= 0xFB && bytes[-1] <= 0xFF && bytes[4] != 0x72)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);

				// SL-DVI limit on DL-DVI: 416.16-425.31, 397.31-399.24
				if (bytes[-3] == 0x81 && bytes[-2] == 0x7D)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);

				// SL-DVI limit on DL-DVI: 384.76-385.69, 320.14-320.49
				if (bytes[-4] == 0x81 && bytes[-3] == 0x7C && bytes[-2] == 0x24)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);
			}

			// HDMI-DVI limit: 384.76+
			// SL-DVI limit on DL-DVI: RTX 2000-series
			if (bytes[4] == 0x76 && bytes[6] == 0x44 && bytes[7] == 0x84)
				replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &hdmi_dvi_limit_found, &hdmi_dvi_limit_patched);
		}

		// TMDS limit: 471.11+
		if (bytes[-6] == 0xE8 && bytes[4] == 0x0F || bytes[-3] == 0xEB && bytes[9] == 0x3B)
			replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

		// TMDS limit: 451.48, 452.06+
		if (bytes[4] == 0x3B && (bytes[6] == 0x0F && bytes[7] == 0x86 || bytes[6] == 0x76))
			replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

		// TMDS limit: 451.67
		if (bytes[-1] == 0x3D && bytes[4] == 0x76 && bytes[6] == 0x84 || bytes[-8] == 0x89 && bytes[-2] == 0x81 && bytes[4] == 0x76)
			replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

		// TMDS limit: 416.34-446.14
		if (bytes[-8] == 0x0F && bytes[-7] == 0x84 && bytes[-1] >= 0xBC && bytes[-1] <= 0xBF && (bytes[8] == 0x75 && bytes[9] < 0x62 || bytes[8] != 0x75))
			replace_value(value, old_tmds_limit, new_tmds_limit, &tmds_limit_found, &tmds_limit_patched);

		if (option_full)
		{
			// SLI limit 1: 301.42+
			offset1 = (unsigned *)&bytes[6];
			offset2 = (unsigned *)&bytes[12];

			if (bytes[-1] == 0xB8 && bytes[4] == 0x89 && bytes[5] == 0x82 && bytes[10] == 0x89 && bytes[11] == 0x82 && *offset1 == *offset2 - 4)
				replace_value(value, old_sli_limit, new_sli_limit, &sli_limit1_found, &sli_limit1_patched);

			// SLI limit 2: 334.67-340.65
			offset1 = (unsigned *)&bytes[-4];
			offset2 = (unsigned *)&bytes[6];

			if (bytes[-11] == 0xB9 && bytes[-6] == 0xC7 && bytes[-5] == 0x83 && bytes[4] == 0x89 && bytes[5] == 0x8B && *offset1 == *offset2 - 4)
			{
				alt_value = (unsigned *)&bytes[-10];
				replace_values(value, old_sli_limit, new_sli_limit, alt_value, alt_sli_limit, new_sli_limit, &sli_limit2_found, &sli_limit2_patched);
			}

			// SLI limit 2: 314.22-332.21
			offset1 = (unsigned *)&bytes[-4];
			offset2 = (unsigned *)&bytes[6];

			if (bytes[-6] == 0xC7 && bytes[-5] == 0x82 && bytes[4] == 0xC7 && bytes[5] == 0x82 && *offset1 == *offset2 - 4)
			{
				alt_value = (unsigned *)&bytes[10];
				replace_values(value, old_sli_limit, new_sli_limit, alt_value, alt_sli_limit, new_sli_limit, &sli_limit2_found, &sli_limit2_patched);
			}

			// SLI limit 3: 334.67, 335.23
			offset1 = (unsigned *)&bytes[6];
			offset2 = (unsigned *)&bytes[12];

			if (bytes[-1] == 0xB9 && bytes[4] == 0x89 && bytes[5] == 0x8B && bytes[10] == 0x89 && bytes[11] == 0x8B && *offset1 == *offset2 - 4)
				replace_value(value, old_sli_limit, new_sli_limit, &sli_limit3_found, &sli_limit3_patched);

			// Fermi limit: 301.42+
			if (bytes[-4] == 0x1B && bytes[-3] == 0xC9 && bytes[-2] == 0x81 && bytes[-1] == 0xE1)
				replace_value(value, old_fermi_limit, new_fermi_limit, &fermi_limit_found, &fermi_limit_patched);

			// Fermi check: 361.43+
			if (bytes[-6] == 0x39 && (bytes[0] == 0x0F && bytes[1] == 0x86 || bytes[0] == 0x90 && bytes[1] == 0xE9))
				if (search_bytes(bytes, -128, -64, "\x00\x00\x2C\x00", 4) && search_bytes(bytes, -128, -64, "\x00\x00\x04\x00", 4))
					replace_bytes(bytes, "\x0F\x86", "\x90\xE9", 2, &fermi_check_found, &fermi_check_patched);

			// Fermi check: 301.42-359.12
			if (bytes[-6] == 0x39 && (bytes[0] == 0x76 || bytes[0] == 0xEB))
				if (search_bytes(bytes, -128, -64, "\x00\x00\x2C\x00", 4) && search_bytes(bytes, -128, -64, "\x00\x00\x04\x00", 4))
					replace_bytes(bytes, "\x76", "\xEB", 1, &fermi_check_found, &fermi_check_patched);
		}
	}

	return TRUE;
}

/****************************************************************************/

BOOL patch32(unsigned char *buffer, unsigned size)
{
	unsigned index;
	unsigned char *bytes;
	unsigned *value;
	BOOL found_0x917D = FALSE;
	unsigned *offset1;
	unsigned *offset2;
	unsigned *alt_value;

	for (index = 256; index + 256 < size; index++)
	{
		bytes = &buffer[index];
		value = (unsigned *)bytes;

		if (bytes[-1] >= 0xB8 && bytes[-1] <= 0xBF)
		{
			// DVI/HDMI limit: 388.10+
			if (bytes[11] == 0x0F && bytes[12] == 0x95)
				replace_value(value, old_sl_limit, new_sl_limit, &sl_limit_found, &sl_limit_patched);

			// DVI/HDMI limit: 320.00-388.00
			if (bytes[4] == 0x84 && bytes[5] == 0xC0)
				replace_value(value, old_sl_limit, new_sl_limit, &sl_limit_found, &sl_limit_patched);

			// DVI/HDMI limit: 313.95-314.22
			if (bytes[4] == 0x0F && bytes[5] == 0x95)
				replace_value(value, old_sl_limit, new_sl_limit, &sl_limit_found, &sl_limit_patched);

			// DVI/HDMI limit: 304.48-310.90
			if (bytes[-4] == 0x0F && bytes[-3] == 0x95)
				replace_value(value, old_sl_limit, new_sl_limit, &sl_limit_found, &sl_limit_patched);
		}

		// SL-DVI/HDMI check: 304.48-320.49
		if (bytes[-6] == 0x33 && bytes[-5] == 0xC9 && bytes[-4] == 0x41 && bytes[-3] == 0x3B && bytes[-2] == 0xC1 && bytes[-1] == 0x74 && bytes[1] == 0x83 && bytes[2] == 0xF8 && bytes[3] == 0x02 && bytes[4] == 0x74 && bytes[6] == 0x83 && bytes[7] == 0xF8 && bytes[8] == 0x05 && bytes[9] == 0x74 && bytes[11] == 0x8B && bytes[12] == 0x03)
			replace_bytes(bytes, NULL, "\x00", 1, &sl_check_found, &sl_check_patched);

		// SL-DVI/HDMI check: 301.42
		if (bytes[-4] == 0x83 && bytes[-3] == 0xF8 && bytes[-2] == 0x01 && bytes[-1] == 0x74 && bytes[1] == 0x83 && bytes[2] == 0xF8 && bytes[3] == 0x02 && bytes[4] == 0x74 && bytes[6] == 0x83 && bytes[7] == 0xF8 && bytes[8] == 0x05 && bytes[9] == 0x74 && bytes[11] == 0x8B && bytes[12] == 0x03)
			replace_bytes(bytes, NULL, "\x00", 1, &sl_check_found, &sl_check_patched);

		if (!option_165)
		{
			if (*value == 0x917D)
				found_0x917D = TRUE;

			if (*value == 0x3FF00)
				found_0x917D = FALSE;

			if (*value == 0x1FFF00)
				found_0x917D = FALSE;

			if (found_0x917D)
			{
				// SL-DVI limit on DL-DVI: 301.42+
				if (bytes[-3] == 0x81 && bytes[-2] == 0x7D && bytes[4] == 0x76)
					replace_value(value, old_sl_dl_limit, option_660 ? new_sl_limit : new_sl_dl_limit, &sl_dl_limit_found, &sl_dl_limit_patched);
			}
		}

		if (option_full)
		{
			// SLI limit 1: 301.42+
			offset1 = (unsigned *)&bytes[6];
			offset2 = (unsigned *)&bytes[12];

			if (bytes[-1] == 0xB9 && bytes[4] == 0x89 && bytes[5] == 0x88 && bytes[10] == 0x89 && bytes[11] == 0x88 && *offset1 == *offset2 - 4)
				replace_value(value, old_sli_limit, new_sli_limit, &sli_limit1_found, &sli_limit1_patched);

			// SLI limit 2: 334.67-340.65
			offset1 = (unsigned *)&bytes[-4];
			offset2 = (unsigned *)&bytes[6];

			if (bytes[-11] == 0xBA && bytes[-6] == 0xC7 && bytes[-5] == 0x81 && bytes[4] == 0x89 && bytes[5] == 0x91 && *offset1 == *offset2 - 4)
			{
				alt_value = (unsigned *)&bytes[-10];
				replace_values(value, old_sli_limit, new_sli_limit, alt_value, alt_sli_limit, new_sli_limit, &sli_limit2_found, &sli_limit2_patched);
			}

			// SLI limit 2: 314.22-332.21
			offset1 = (unsigned *)&bytes[-4];
			offset2 = (unsigned *)&bytes[6];

			if (bytes[-6] == 0xC7 && bytes[-5] == 0x80 && bytes[4] == 0xC7 && bytes[5] == 0x80 && *offset1 == *offset2 - 4)
			{
				alt_value = (unsigned *)&bytes[10];
				replace_values(value, old_sli_limit, new_sli_limit, alt_value, alt_sli_limit, new_sli_limit, &sli_limit2_found, &sli_limit2_patched);
			}

			// SLI limit 3: 334.67, 335.23
			offset1 = (unsigned *)&bytes[6];
			offset2 = (unsigned *)&bytes[12];

			if (bytes[-1] == 0xBA && bytes[4] == 0x89 && bytes[5] == 0x91 && bytes[10] == 0x89 && bytes[11] == 0x91 && *offset1 == *offset2 - 4)
				replace_value(value, old_sli_limit, new_sli_limit, &sli_limit3_found, &sli_limit3_patched);

			// Fermi limit: 301.42+
			if (bytes[-3] == 0x1B && bytes[-2] == 0xC0 && bytes[-1] == 0x25)
				replace_value(value, old_fermi_limit, new_fermi_limit, &fermi_limit_found, &fermi_limit_patched);

			// Fermi check: 381.65+
			if (bytes[-6] == 0x39 && (bytes[0] == 0x0F && bytes[1] == 0x86 || bytes[0] == 0x90 && bytes[1] == 0xE9))
				if (search_bytes(bytes, -128, -64, "\x00\x00\x2C\x00", 4) && search_bytes(bytes, -128, -64, "\x00\x00\x04\x00", 4))
					replace_bytes(bytes, "\x0F\x86", "\x90\xE9", 2, &fermi_check_found, &fermi_check_patched);

			// Fermi check: 301.42-378.92
			if (bytes[-6] == 0x39 && (bytes[0] == 0x76 || bytes[0] == 0xEB))
				if (search_bytes(bytes, -128, -64, "\x00\x00\x2C\x00", 4) && search_bytes(bytes, -128, -64, "\x00\x00\x04\x00", 4))
					replace_bytes(bytes, "\x76", "\xEB", 1, &fermi_check_found, &fermi_check_patched);
		}
	}

	return TRUE;
}

/****************************************************************************/

const char *get_driver_path()
{
	HKEY key;
	DWORD size;
	static char data[MAX_PATH];
	const char *path;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
		return NULL;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath", NULL, NULL, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return NULL;
	}

	RegCloseKey(key);
	path = data;

	if (strnicmp(path, "\\SystemRoot\\", 12) == 0)
		path += 12;

	if (strnicmp(path, "System32\\", 9) == 0)
		path += 9;

	return path;
}

/****************************************************************************/

BOOL set_driver_path()
{
	HKEY key;
	DWORD type;
	DWORD size;
	char data[MAX_PATH];

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
		return FALSE;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath", NULL, &type, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	if (RegSetValueEx(key, "ImagePath.bak", 0, type, (LPBYTE)&data, size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	strcpy(data, "\\SystemRoot\\System32\\");
	strcat(data, driver_sys);
	size = (strlen(data) + 1) * sizeof *data;

	if (RegSetValueEx(key, "ImagePath", 0, type, (LPBYTE)&data, size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	return TRUE;
}

/****************************************************************************/

const char *get_backup_path()
{
	HKEY key;
	DWORD size;
	static char data[MAX_PATH];
	const char *path;

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key, 0, KEY_QUERY_VALUE, &key) != ERROR_SUCCESS)
		return NULL;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath.bak", NULL, NULL, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return NULL;
	}

	RegCloseKey(key);
	path = data;

	if (strnicmp(path, "\\SystemRoot\\", 12) == 0)
		path += 12;

	if (strnicmp(path, "System32\\", 9) == 0)
		path += 9;

	if (!readable_file(path))
		return NULL;

	return path;
}

/****************************************************************************/

BOOL restore_driver_path()
{
	HKEY key;
	DWORD type;
	DWORD size;
	char data[MAX_PATH];

	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, service_key, 0, KEY_QUERY_VALUE | KEY_SET_VALUE, &key) != ERROR_SUCCESS)
		return FALSE;

	size = sizeof data;

	if (RegQueryValueEx(key, "ImagePath.bak", NULL, &type, (LPBYTE)data, &size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	if (RegSetValueEx(key, "ImagePath", 0, type, (LPBYTE)&data, size) != ERROR_SUCCESS)
	{
		RegCloseKey(key);
		return FALSE;
	}

	RegDeleteValue(key, "ImagePath.bak");
	RegCloseKey(key);
	return TRUE;
}

/****************************************************************************/

const char *replace_file_name(const char *path, const char *new_file_name)
{
	static char new_path[MAX_PATH * 2];
	char *file_name;

	strcpy(new_path, path);
	file_name = strrchr(new_path, '\\');
	file_name++;
	strcpy(file_name, new_file_name);
	return new_path;
}

/****************************************************************************/

const char *append_file_name(const char *path, const char *file_name)
{
	static char new_path[MAX_PATH * 2];

	strcpy(new_path, path);
	strcat(new_path, "\\");
	strcat(new_path, file_name);
	return new_path;
}

/****************************************************************************/

BOOL is_symbolic_link(const char *src_file)
{
	DWORD result;

	result = GetFileAttributes(src_file);

	if (result == INVALID_FILE_ATTRIBUTES)
		return FALSE;

	if (result & FILE_ATTRIBUTE_REPARSE_POINT)
		return TRUE;

	return FALSE;
}

/****************************************************************************/

int file_size(const char *src_file)
{
	struct stat src_stat;

	if (stat(src_file, &src_stat) != 0)
		return -1;

	return src_stat.st_size;
}

/****************************************************************************/

BOOL remove_driver_links()
{
	int index;
	HANDLE find;
	WIN32_FIND_DATA file;
	char src_file[MAX_PATH * 2];

	for (index = 0; driver_files[index]; index++)
	{
		find = FindFirstFile(append_file_name(driver_dir, driver_files[index]), &file);

		if (find != INVALID_HANDLE_VALUE)
		{
			do
			{
				strcpy(src_file, append_file_name(driver_dir, file.cFileName));

				if (is_symbolic_link(src_file) || file_size(src_file) == 0)
					unlink(src_file);
			}
			while (FindNextFile(find, &file));

			FindClose(find);
		}
	}

	if (chdir("..\\Sysnative") == 0)
	{
		strcpy(src_file, append_file_name("..\\System32", driver_dir));
		rmdir(src_file);

		if (is_symbolic_link(src_file) || file_size(src_file) == 0)
			unlink(src_file);
	}

	return TRUE;
}

/****************************************************************************/

BOOL create_driver_links(const char *driver_file)
{
	int index;
	HANDLE find;
	WIN32_FIND_DATA file;
	char src_file[MAX_PATH * 2];
	char dst_file[MAX_PATH * 2];

	remove_driver_links();

	for (index = 0; driver_files[index]; index++)
	{
		find = FindFirstFile(replace_file_name(driver_file, driver_files[index]), &file);

		if (find != INVALID_HANDLE_VALUE)
		{
			do
			{
				strcpy(src_file, append_file_name(driver_dir, file.cFileName));
				strcpy(dst_file, append_file_name("..\\..", replace_file_name(driver_file, file.cFileName)));

				if (!CreateSymbolicLink(src_file, dst_file, 0))
					return FALSE;
			}
			while (FindNextFile(find, &file));

			FindClose(find);
		}
	}

	for (index = 0; driver_files[index]; index++)
	{
		find = FindFirstFile(driver_files[index], &file);

		if (find != INVALID_HANDLE_VALUE)
		{
			do
			{
				strcpy(src_file, append_file_name(driver_dir, file.cFileName));
				strcpy(dst_file, append_file_name("..\\..\\..\\System32", file.cFileName));

				if (!CreateSymbolicLink(src_file, dst_file, 0) && !is_symbolic_link(src_file))
					return FALSE;
			}
			while (FindNextFile(find, &file));

			FindClose(find);
		}
	}

	if (chdir("..\\Sysnative") == 0)
	{
		for (index = 0; driver_files[index]; index++)
		{
			find = FindFirstFile(append_file_name("..\\System32", driver_files[index]), &file);

			if (find != INVALID_HANDLE_VALUE)
			{
				do
				{
					strcpy(src_file, append_file_name(driver_dir, file.cFileName));
					strcpy(dst_file, append_file_name("..\\..\\..\\SysWOW64", file.cFileName));

					if (!CreateSymbolicLink(src_file, dst_file, 0) && !is_symbolic_link(src_file))
						return FALSE;
				}
				while (FindNextFile(find, &file));

				FindClose(find);
			}
		}

		strcpy(src_file, append_file_name("..\\System32", driver_dir));
		strcpy(dst_file, append_file_name("..\\..\\System32", driver_dir));

		if (!CreateSymbolicLink(src_file, dst_file, SYMBOLIC_LINK_FLAG_DIRECTORY))
			return FALSE;
	}

	return TRUE;
}

/****************************************************************************/

BOOL remove_driver_files()
{
	remove_driver_links();
	remove_file(driver_sys);
	rmdir(driver_dir);
	return TRUE;
}

/****************************************************************************/

BOOL remove_old_driver_files()
{
	remove_file(driver_old);
	return TRUE;
}

/****************************************************************************/

BOOL remove_old_backup_files()
{
	remove_file(old_driver_bak);
	remove_file(old_driver2_bak);
	return TRUE;
}

/****************************************************************************/

BOOL remove_old_files()
{
	int index;

	for (index = 0; old_files[index]; index++)
		remove_file(old_files[index]);

	return TRUE;
}

/* Main *********************************************************************/

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	const char *windir;
	unsigned bits;
	const char *driver_file;
	FILE *file;
	unsigned char *buffer;
	unsigned size;
	BOOL file_patched;
	const char *backup_file;
	char text[1024];
	BOOL self_signed = FALSE;

	windir = getenv("windir");

	if (!windir)
		windir = "C:\\Windows";

	if (chdir(windir) != 0)
		return error_message("Failed to locate Windows directory.");

	if (chdir("Sysnative") == 0)
		bits = 64;
	else if (chdir("System32") == 0)
		bits = 32;
	else
		return error_message("Failed to locate system directory.");

	driver_file = get_driver_path();

	if (!driver_file)
		return error_message("Failed to locate driver file.");

	size = file_size(driver_file);

	if (size < 0)
	{
		if (errno == ENOENT)
			return error_message("Driver file not found.");

		return error_message("Failed to access driver file.");
	}

	if (size == 0)
		return error_message("Driver file is empty.");

	if (size > max_file_size)
		return error_message("Driver file too large.");

	buffer = (unsigned char *)malloc(size);

	if (!buffer)
		return error_message("Failed to allocate memory.");

	file = fopen(driver_file, "rb");

	if (!file)
		return error_message("Failed to open driver file.");

	if (fread(buffer, 1, size, file) != size)
	{
		fclose(file);
		return error_message("Failed to read driver file.");
	}

	fclose(file);

	if (stricmp(driver_file, driver_sys) == 0)
	{
		file_patched = TRUE;
		backup_file = get_backup_path();

		if (backup_file && stricmp(backup_file, driver_sys) == 0)
			backup_file = NULL;
	}
	else if (stricmp(driver_file, driver_old) == 0)
	{
		file_patched = TRUE;
		backup_file = get_backup_path();

		if (backup_file && stricmp(backup_file, driver_old) == 0)
			backup_file = NULL;
	}
	else if (!patched(buffer, size))
	{
		file_patched = FALSE;
		backup_file = NULL;
	}
	else if (stricmp(driver_file, old_driver_sys) == 0)
	{
		file_patched = TRUE;
		backup_file = old_driver_bak;

		if (!readable_file(backup_file))
			backup_file = NULL;
	}
	else if (stricmp(driver_file, old_driver2_sys) == 0)
	{
		file_patched = TRUE;
		backup_file = old_driver2_bak;

		if (!readable_file(backup_file))
			backup_file = NULL;
	}
	else
	{
		file_patched = TRUE;
		backup_file = NULL;
	}

	parse_options();

	if (bits == 64)
	{
		patch64(buffer, size);

		if (option_full && !sli_limit1_found && !sli_limit1_patched && !fermi_limit_found && !fermi_limit_patched)
			return error_message("This driver does not require the full patch.");

		strcpy(text, "64-bit driver found.\n\n");
		strcat(text, "DL-DVI limit:               \t");
		strcat_found(text, dl_limit_found, dl_limit_patched);
		strcat(text, "SL-DVI/HDMI limit:    \t");
		strcat_found(text, sl_limit_found, sl_limit_patched);
	}
	else if (bits == 32)
	{
		patch32(buffer, size);
		strcpy(text, "32-bit driver found.\n\n");
		strcat(text, "DVI/HDMI limit:          \t");
		strcat_found(text, sl_limit_found, sl_limit_patched);
	}

	if (!option_165)
	{
		if (sl_check_found || sl_check_patched)
		{
			strcat(text, "SL-DVI/HDMI check:  \t");
			strcat_found(text, sl_check_found, sl_check_patched);
		}

		strcat(text, "SL-DVI limit on DL-DVI:\t");
		strcat_found(text, sl_dl_limit_found, sl_dl_limit_patched);
	}

	if (hdmi_dvi_limit_found || hdmi_dvi_limit_patched)
	{
		strcat(text, "HDMI-DVI limit:          \t");
		strcat_found(text, hdmi_dvi_limit_found, hdmi_dvi_limit_patched);
	}

	if (tmds_limit_found || tmds_limit_patched)
	{
		strcat(text, "TMDS limit:               \t");
		strcat_found(text, !!tmds_limit_found, tmds_limit_patched);
	}

	if (option_full)
	{
		if (sli_limit2_found || sli_limit2_patched || sli_limit3_found || sli_limit3_patched)
		{
			strcat(text, "SLI limit 1:                    \t");
			strcat_found(text, sli_limit1_found, sli_limit1_patched);
			strcat(text, "SLI limit 2:                    \t");
			strcat_found(text, sli_limit2_found, sli_limit2_patched);

			if (sli_limit3_found || sli_limit3_patched)
			{
				strcat(text, "SLI limit 3:                    \t");
				strcat_found(text, sli_limit3_found, sli_limit3_patched);
			}
		}
		else
		{
			strcat(text, "SLI limit:                       \t");
			strcat_found(text, sli_limit1_found, sli_limit1_patched);
		}

		strcat(text, "Fermi limit:                  \t");
		strcat_found(text, fermi_limit_found, fermi_limit_patched);
		strcat(text, "Fermi check:               \t");
		strcat_found(text, fermi_check_found, fermi_check_patched);
	}

	strcat(text, "\n");

	if (!found())
	{
		if (!file_patched)
		{
			strcat(text, "No values found.");
			MessageBox(NULL, text, title, MB_OK);
			return 0;
		}

		if (!backup_file)
		{
			strcat(text, "No backup found.");
			MessageBox(NULL, text, title, MB_OK);
			return 0;
		}

		strcat(text, "Restore from backup?");

		if (MessageBox(NULL, text, title, MB_YESNO) != IDYES)
			return 0;

		remove_old_files();

		if (stricmp(driver_file, driver_sys) == 0)
		{
			if (!restore_driver_path())
				return error_message("Failed to restore driver path.");

			remove_driver_files();
		}
		else if (stricmp(driver_file, driver_old) == 0)
		{
			if (!restore_driver_path())
				return error_message("Failed to restore driver path.");

			remove_old_driver_files();
		}
		else
		{
			if (!replace_file(backup_file, driver_file))
				return error_message("Failed to restore driver file.");
		}

		MessageBox(NULL, "Driver successfully restored.", "Restore", MB_ICONINFORMATION);
		return 0;
	}

	strcat(text, "Patch found values?");

	if (MessageBox(NULL, text, title, MB_YESNO) != IDYES)
		return 0;

	remove_old_files();

	if (!write_file(buffer, size, driver_new))
		return error_message("Failed to write new driver file.");

	if (!sign_file(driver_new))
	{
		if (!self_sign_file(driver_new))
		{
			unlink(driver_new);
			return error_message("Failed to sign new driver file.");
		}

		self_signed = TRUE;
	}

	if (backup_file)
	{
		if (!replace_file(driver_new, driver_file))
		{
			unlink(driver_new);
			return error_message("Failed to replace driver file.");
		}
	}
	else
	{
		mkdir(driver_dir);

		if (!replace_file(driver_new, driver_sys))
		{
			unlink(driver_new);
			rmdir(driver_dir);
			return error_message("Failed to move driver file.");
		}

		if (!create_driver_links(driver_file))
		{
			remove_driver_files();
			return error_message("Failed to create driver links.");
		}

		if (!set_driver_path())
		{
			remove_driver_files();
			return error_message("Failed to set new driver path.");
		}

		remove_old_backup_files();
	}

	if (self_signed)
	{
		MessageBox(NULL, "Driver successfully patched, but signing failed.\nDriver has been self-signed. Test mode is required.", "Patch", MB_ICONWARNING);
		return 1;
	}

	MessageBox(NULL, "Driver successfully patched and signed.", "Patch", MB_ICONINFORMATION);
	return 0;
}
