//---------------------------------------------------------------------------
#ifndef DetailedResolutionClassH
#define DetailedResolutionClassH
//---------------------------------------------------------------------------
#include "ItemClass.h"
//---------------------------------------------------------------------------
class DetailedResolutionClass : public ItemClass
{
private:
	static const int MinTiming;
	static const int MaxTiming;
	static const char *TimingText[];

	static bool (DetailedResolutionClass::*TimingFunction[])();
	static const int LCDStandard[][13];
	static const int LCDNative[][12];
	static const int LCDReduced[][13];
	static const int CRTStandard[][13];
	static const int OldStandard[][13];
	static const int AspectVSync[][3];

	static const int C;
	static const int J;
	static const int K;
	static const int M;

	static const int CPrime;
	static const int MPrime;

	static const int MinHActive[];
	static const int MaxHActive[];
	static const int MinHFront[];
	static const int MaxHFront[];
	static const int MinHSync[];
	static const int MaxHSync[];
	static const int MinHBack[];
	static const int MaxHBack[];
	static const int MinHBlank[];
	static const int MaxHBlank[];
	static const int MinHTotal[];
	static const int MaxHTotal[];

	static const int MinVActive[];
	static const int MaxVActive[];
	static const int MinVFront[];
	static const int MaxVFront[];
	static const int MinVSync[];
	static const int MaxVSync[];
	static const int MinVBack[];
	static const int MaxVBack[];
	static const int MinVBlank[];
	static const int MaxVBlank[];
	static const int MinVTotal[];
	static const int MaxVTotal[];

	static const long long MinVRate[];
	static const long long MaxVRate[];
	static const long long MinHRate[];
	static const long long MaxHRate[];
	static const long long MinPClock[];
	static const long long MaxPClock[];

	static const bool InterlacedAvailable[];
	static const bool NativeAvailable[];

	static bool Copied;
	static int CopyType;
	static int CopyHActive;
	static int CopyHFront;
	static int CopyHSync;
	static int CopyHBlank;
	static bool CopyHPolarity;
	static int CopyVActive;
	static int CopyVFront;
	static int CopyVSync;
	static int CopyVBlank;
	static bool CopyVPolarity;
	static int CopyStereo;
	static long long CopyPClock;
	static bool CopyInterlaced;
	static bool CopyNative;

	int Type;
	int Timing;
	int Last;
	int HActive;
	int HFront;
	int HSync;
	int HBack;
	int HBlank;
	int HTotal;
	bool HPolarity;
	int VActive;
	int VFront;
	int VSync;
	int VBack;
	int VBlank;
	int VTotal;
	bool VPolarity;
	int Stereo;
	int LastRate;
	long long VRate, ActualVRate;
	long long HRate, ActualHRate;
	long long PClock;
	bool Interlaced;
	bool Native;
	int VActiveI;
	int VFrontI;
	int VSyncI;
	int VBackI;
	int VBlankI;
	int VTotalI;
	long long VRateI;

	bool ResetAvailable;
	int ResetHActive;
	int ResetHFront;
	int ResetHSync;
	int ResetHBlank;
	bool ResetHPolarity;
	int ResetVActive;
	int ResetVFront;
	int ResetVSync;
	int ResetVBlank;
	bool ResetVPolarity;
	int ResetStereo;
	long long ResetPClock;
	bool ResetInterlaced;
	bool ResetNative;

public:
	DetailedResolutionClass(int = 0);
	bool Read(const unsigned char *, int);
	bool Init();
	bool Write(unsigned char *, int);
	bool GetText(char *, int, const char *);
	bool SetType(int);
	bool GetTimingText(int, char *, int);
	int GetTiming();
	bool SetTiming(int);
	bool CopyPossible();
	bool Copy();
	bool PastePossible();
	bool Paste();
	bool UpdateReset();
	bool ResetPossible();
	bool Reset();
	bool IsLast(int);
	int GetHActive();
	int GetHFront();
	int GetHSync();
	int GetHBack();
	int GetHBlank();
	int GetHTotal();
	bool GetHPolarity();
	int GetVActive();
	int GetVFront();
	int GetVSync();
	int GetVBack();
	int GetVBlank();
	int GetVTotal();
	bool GetVPolarity();
	bool GetVActiveLinesText(char *, int);
	bool GetVFrontLinesText(char *, int);
	bool GetVSyncLinesText(char *, int);
	bool GetVBackLinesText(char *, int);
	bool GetVBlankLinesText(char *, int);
	bool GetVTotalLinesText(char *, int);
	bool IsLastRate(int);
	long long GetVRate();
	long long GetHRate();
	long long GetPClock();
	long long GetActualVRate();
	long long GetActualHRate();
	bool GetActualVRateText(char *, int, const char *);
	bool GetActualHRateText(char *, int, const char *);
	bool SetLast(int);
	bool SetHActive(int);
	bool SetHFront(int);
	bool SetHSync(int);
	bool SetHBack(int);
	bool SetHBlank(int);
	bool SetHTotal(int);
	bool SetHPolarity(bool);
	bool SetVActive(int);
	bool SetVFront(int);
	bool SetVSync(int);
	bool SetVBack(int);
	bool SetVBlank(int);
	bool SetVTotal(int);
	bool SetVPolarity(bool);
	bool SetLastRate(int);
	bool SetVRate(long long);
	bool SetHRate(long long);
	bool SetPClock(long long);
	bool InterlacedPossible();
	bool GetInterlaced();
	bool SetInterlaced(bool);
	bool NativePossible();
	bool GetNative();
	bool SetNative(bool);
	bool Update();
	bool UpdateInterlaced();
	bool UpdateInterlacedRate();
	bool CalculateNative(bool);
	bool CalculateLCDStandard();
	bool CalculateLCDNative();
	bool CalculateLCDReduced();
	bool CalculateCRTStandard();
	bool CalculateOldStandard();
	bool CalculateCVT();
	bool CalculateCVTRB();
	bool CalculateGTF();
	long long GetHPeriodForCVT();
	long long GetHPeriodForCVTRB();
	long long GetHPeriodForGTF();
	int GetHFrontForCVT();
	int GetHFrontForGTF();
	int GetHSyncForCVT();
	int GetHSyncForGTF();
	int GetHBackForCVT();
	int GetHBackForGTF();
	int GetHBlankForCVT();
	int GetHBlankForGTF();
	int GetVFrontForCVT();
	int GetVFrontForGTF();
	int GetVSyncForCVT();
	int GetVSyncForGTF();
	int GetVBackForCVT();
	int GetVBackForCVTRB();
	int GetVBackForGTF();
	bool CalculateHBack();
	bool CalculateHBackFromHTotal();
	bool CalculateHBlank();
	bool CalculateHTotal();
	bool CalculateVBack();
	bool CalculateVBackFromVTotal();
	bool CalculateVBlank();
	bool CalculateVTotal();
	bool CalculatePClockForCVT();
	bool CalculatePClockForCVTRB();
	bool CalculatePClockForGTF();
	bool CalculatePClockFromVRate();
	bool CalculatePClockFromHRate();
	bool CalculateActualVRate();
	bool CalculateActualHRate();
	bool IsValid();
	bool IsValidTiming();
	bool IsValidHActive();
	bool IsValidHFront();
	bool IsValidHSync();
	bool IsValidHBack();
	bool IsValidHBlank();
	bool IsValidHTotal();
	bool IsValidVActive();
	bool IsValidVFront();
	bool IsValidVSync();
	bool IsValidVBack();
	bool IsValidVBlank();
	bool IsValidVTotal();
	bool IsValidRate();
	bool IsValidVRate();
	bool IsValidHRate();
	bool IsValidPClock();
	bool IsValidActualVRate();
	bool IsValidActualHRate();
	bool IsSupported();
	bool IsSupportedHActive();
	bool IsSupportedHFront();
	bool IsSupportedHSync();
	bool IsSupportedHBack();
	bool IsSupportedHBlank();
	bool IsSupportedHTotal();
	bool IsSupportedVActive();
	bool IsSupportedVFront();
	bool IsSupportedVSync();
	bool IsSupportedVBack();
	bool IsSupportedVBlank();
	bool IsSupportedVTotal();
	bool IsSupportedVRate();
	bool IsSupportedHRate();
	bool IsSupportedPClock();
	bool IsSupportedActualVRate();
	bool IsSupportedActualHRate();
	int GetMinHBack(int);
	int GetMaxHBack(int);
	int GetMinHBlank(int);
	int GetMaxHBlank(int);
	int GetMinHTotal(int);
	int GetMaxHTotal(int);
	int GetMinVBack(int);
	int GetMaxVBack(int);
	int GetMinVBlank(int);
	int GetMaxVBlank(int);
	int GetMinVTotal(int);
	int GetMaxVTotal(int);
	long long Min(long long, long long);
	long long Max(long long, long long);
	long long MinMax(long long, long long, long long);
};
//---------------------------------------------------------------------------
#endif
