//---------------------------------------------------------------------------
#include "Common.h"
#pragma hdrstop

#include "HDMI2SupportClass.h"
//---------------------------------------------------------------------------
const int HDMI2SupportClass::MinTMDSRate = 5;
const int HDMI2SupportClass::MaxTMDSRate = 1275;
const int HDMI2SupportClass::ModTMDSRate = 5;
const int HDMI2SupportClass::FeaturesMask = 207;
const int HDMI2SupportClass::MinColorFormat = 0;
const int HDMI2SupportClass::MaxColorFormat = 2;
//---------------------------------------------------------------------------
HDMI2SupportClass::HDMI2SupportClass()
{
	Version = 1;
	TMDSRate = 600;
	Features[0] = 0;
	Features[1] = 0;
	OtherSize = 0;
	MaxOtherSize = sizeof OtherData;
	std::memset(OtherData, 0, MaxOtherSize);
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::Read(const unsigned char *Data, int MaxSize)
{
	int Type;
	int Size;

	if (!Data)
		return false;

	if (MaxSize < 8)
		return false;

	Type = Data[0] >> 5;
	Size = Data[0] & 31;

	if (Type != 3)
		return false;

	if (Size < 7)
		return false;

	if (std::memcmp(&Data[1], "\xD8\x5D\xC4", 3) != 0)
		return false;

	if (Data[4] != 0)
		Version = Data[4];
	else
		Version = 1;

	if (Data[5] != 0)
		TMDSRate = Data[5] * 5;
	else
		TMDSRate = BLANK;

	Features[0] = Data[6];
	Features[1] = Data[7];
	OtherSize = Size - 7;

	if (OtherSize < 0 || OtherSize > MaxOtherSize)
		OtherSize = 0;

	std::memset(OtherData, 0, MaxOtherSize);
	std::memcpy(OtherData, &Data[8], OtherSize);
	return true;
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::Write(unsigned char *Data, int MaxSize)
{
	if (!Data)
		return false;

	if (MaxSize < 8)
		return false;

	std::memset(Data, 0, MaxSize);
	Data[1] = 0xD8;
	Data[2] = 0x5D;
	Data[3] = 0xC4;
	Data[4] = Version;

	if (TMDSRate != BLANK)
		Data[5] = TMDSRate / 5;

	Data[6] = Features[0];
	Data[7] = Features[1];

	if (OtherSize > 0)
		std::memcpy(&Data[8], OtherData, OtherSize);

	Data[0] = 3 << 5;
	Data[0] |= OtherSize + 7;
	return true;
}
//---------------------------------------------------------------------------
int HDMI2SupportClass::GetTMDSRate()
{
	return TMDSRate;
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::SetTMDSRate(int Value)
{
	TMDSRate = Value;
	return true;
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::GetFeature(int Index)
{
	if (!(FeaturesMask & (1 << Index)))
		return false;

	return Features[0] & (1 << Index);
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::SetFeature(int Index, bool Enabled)
{
	if (!(FeaturesMask & (1 << Index)))
		return false;

	if (Enabled)
		Features[0] |= 1 << Index;
	else
		Features[0] &= ~(1 << Index);

	return true;
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::GetColorFormat(int Index)
{
	if (Index < MinColorFormat || Index > MaxColorFormat)
		return false;

	return Features[1] & (1 << Index);
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::SetColorFormat(int Index, bool Enabled)
{
	if (Index < MinColorFormat || Index > MaxColorFormat)
		return false;

	if (Enabled)
		Features[1] |= 1 << Index;
	else
		Features[1] &= ~(1 << Index);

	return true;
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::IsValid()
{
	return IsValidTMDSRate();
}
//---------------------------------------------------------------------------
bool HDMI2SupportClass::IsValidTMDSRate()
{
	if (TMDSRate == BLANK)
		return true;

	return TMDSRate >= MinTMDSRate && TMDSRate <= MaxTMDSRate && TMDSRate % ModTMDSRate == 0;
}
//---------------------------------------------------------------------------
