//---------------------------------------------------------------------------
#ifndef HDMI2SupportClassH
#define HDMI2SupportClassH
//---------------------------------------------------------------------------
#include "ItemClass.h"
//---------------------------------------------------------------------------
class HDMI2SupportClass : public ItemClass
{
private:
	static const int MinTMDSRate;
	static const int MaxTMDSRate;
	static const int ModTMDSRate;
	static const int FeaturesMask;
	static const int MinColorFormat;
	static const int MaxColorFormat;

	int Version;
	int TMDSRate;
	int Features[2];
	int OtherSize;
	int MaxOtherSize;
	unsigned char OtherData[24];

public:
	HDMI2SupportClass();
	bool Read(const unsigned char *, int);
	bool Write(unsigned char *, int);
	int GetTMDSRate();
	bool SetTMDSRate(int);
	bool GetFeature(int);
	bool SetFeature(int, bool);
	bool GetColorFormat(int);
	bool SetColorFormat(int, bool);
	bool IsValid();
	bool IsValidTMDSRate();
};
//---------------------------------------------------------------------------
#endif
