//---------------------------------------------------------------------------
#include "Common.h"
#pragma hdrstop

#include "TVResolutionClass.h"
//---------------------------------------------------------------------------
const char *TVResolutionClass::AspectText[] =
{
	"",
	"",
	"",
	"",
	"4:3",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"1250",
	"",
	"",
	"",
	"16:9",
	"17:9",
	"",
	"",
	"",
	"21:9",
};

const int TVResolutionClass::MinMode = 0;
const int TVResolutionClass::MaxMode = 13;
const int TVResolutionClass::MinFormat = 0;
const int TVResolutionClass::MaxFormat = 15;

const unsigned char TVResolutionClass::Modes[][17] =
{
	// 640x480
	{1},

	// 720x480
	{3, 49, 57, 2, 48, 56},

	// 720x576
	{18, 43, 53, 17, 42, 52},

	// 1280x720
	{60, 61, 62, 108, 19, 4, 41, 47, 65, 66, 67, 109, 68, 69, 70, 71},

	// 1680x720
	{79, 80, 81, 110, 82, 83, 84, 85},

	// 1920x1080
	{32, 33, 34, 111, 31, 16, 64, 63, 72, 73, 74, 112, 75, 76, 77, 78},

	// 1920x1080i
	{20, 5, 40, 46, 39},

	// 2560x1080
	{86, 87, 88, 113, 89, 90, 91, 92},

	// 3840x2160
	{93, 94, 95, 114, 96, 97, 117, 118, 103, 104, 105, 116, 106, 107, 119, 120},

	// 4096x2160
	{98, 99, 100, 115, 101, 102, 218, 219},

	// 5120x2160
	{121, 122, 123, 124, 125, 126, 127, 193},

	// 7680x4320
	{194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209},

	// 10240x4320
	{210, 211, 212, 213, 214, 215, 216, 217},

	// Other resolution
	{0},
};

const int TVResolutionClass::MinCode = 0;
const int TVResolutionClass::MaxCode = 255;
const int TVResolutionClass::MinNative = 1;
const int TVResolutionClass::MaxNative = 64;

const short TVResolutionClass::Codes[256][6] =
{
	{0},                            //   0
	{ 640,  480, 0,  4,  60, 1},    //   1
	{ 720,  480, 0,  4,  60, 0},    //   2
	{ 720,  480, 0, 16,  60, 1},    //   3
	{1280,  720, 0, 16,  60, 1},    //   4
	{1920, 1080, 1, 16,  60, 1},    //   5
	{1440,  480, 1,  4,  60, 0},    //   6
	{1440,  480, 1, 16,  60, 0},    //   7
	{1440,  240, 0,  4,  60, 0},    //   8
	{1440,  240, 0, 16,  60, 0},    //   9
	{2880,  480, 1,  4,  60, 0},    //  10
	{2880,  480, 1, 16,  60, 0},    //  11
	{2880,  240, 0,  4,  60, 0},    //  12
	{2880,  240, 0, 16,  60, 0},    //  13
	{1440,  480, 0,  4,  60, 0},    //  14
	{1440,  480, 0, 16,  60, 0},    //  15
	{1920, 1080, 0, 16,  60, 1},    //  16
	{ 720,  576, 0,  4,  50, 0},    //  17
	{ 720,  576, 0, 16,  50, 1},    //  18
	{1280,  720, 0, 16,  50, 1},    //  19
	{1920, 1080, 1, 16,  50, 1},    //  20
	{1440,  576, 1,  4,  50, 0},    //  21
	{1440,  576, 1, 16,  50, 0},    //  22
	{1440,  288, 0,  4,  50, 0},    //  23
	{1440,  288, 0, 16,  50, 0},    //  24
	{2880,  576, 1,  4,  50, 0},    //  25
	{2880,  576, 1, 16,  50, 0},    //  26
	{2880,  288, 0,  4,  50, 0},    //  27
	{2880,  288, 0, 16,  50, 0},    //  28
	{1440,  576, 0,  4,  50, 0},    //  29
	{1440,  576, 0, 16,  50, 0},    //  30
	{1920, 1080, 0, 16,  50, 1},    //  31
	{1920, 1080, 0, 16,  24, 1},    //  32
	{1920, 1080, 0, 16,  25, 1},    //  33
	{1920, 1080, 0, 16,  30, 1},    //  34
	{2880,  480, 0,  4,  60, 0},    //  35
	{2880,  480, 0, 16,  60, 0},    //  36
	{2880,  576, 0,  4,  50, 0},    //  37
	{2880,  576, 0, 16,  50, 0},    //  38
	{1920, 1080, 1, 12,  50, 0},    //  39
	{1920, 1080, 1, 16, 100, 1},    //  40
	{1280,  720, 0, 16, 100, 1},    //  41
	{ 720,  576, 0,  4, 100, 0},    //  42
	{ 720,  576, 0, 16, 100, 1},    //  43
	{1440,  576, 1,  4, 100, 0},    //  44
	{1440,  576, 1, 16, 100, 0},    //  45
	{1920, 1080, 1, 16, 120, 1},    //  46
	{1280,  720, 0, 16, 120, 1},    //  47
	{ 720,  480, 0,  4, 120, 0},    //  48
	{ 720,  480, 0, 16, 120, 1},    //  49
	{1440,  480, 1,  4, 120, 0},    //  50
	{1440,  480, 1, 16, 120, 0},    //  51
	{ 720,  576, 0,  4, 200, 0},    //  52
	{ 720,  576, 0, 16, 200, 1},    //  53
	{1440,  576, 1,  4, 200, 0},    //  54
	{1440,  576, 1, 16, 200, 0},    //  55
	{ 720,  480, 0,  4, 240, 0},    //  56
	{ 720,  480, 0, 16, 240, 1},    //  57
	{1440,  480, 1,  4, 240, 0},    //  58
	{1440,  480, 1, 16, 240, 0},    //  59
	{1280,  720, 0, 16,  24, 1},    //  60
	{1280,  720, 0, 16,  25, 1},    //  61
	{1280,  720, 0, 16,  30, 1},    //  62
	{1920, 1080, 0, 16, 120, 1},    //  63
	{1920, 1080, 0, 16, 100, 1},    //  64
	{1280,  720, 0, 21,  24, 0},    //  65
	{1280,  720, 0, 21,  25, 0},    //  66
	{1280,  720, 0, 21,  30, 0},    //  67
	{1280,  720, 0, 21,  50, 0},    //  68
	{1280,  720, 0, 21,  60, 0},    //  69
	{1280,  720, 0, 21, 100, 0},    //  70
	{1280,  720, 0, 21, 120, 0},    //  71
	{1920, 1080, 0, 21,  24, 0},    //  72
	{1920, 1080, 0, 21,  25, 0},    //  73
	{1920, 1080, 0, 21,  30, 0},    //  74
	{1920, 1080, 0, 21,  50, 0},    //  75
	{1920, 1080, 0, 21,  60, 0},    //  76
	{1920, 1080, 0, 21, 100, 0},    //  77
	{1920, 1080, 0, 21, 120, 0},    //  78
	{1680,  720, 0, 21,  24, 1},    //  79
	{1680,  720, 0, 21,  25, 1},    //  80
	{1680,  720, 0, 21,  30, 1},    //  81
	{1680,  720, 0, 21,  50, 1},    //  82
	{1680,  720, 0, 21,  60, 1},    //  83
	{1680,  720, 0, 21, 100, 1},    //  84
	{1680,  720, 0, 21, 120, 1},    //  85
	{2560, 1080, 0, 21,  24, 1},    //  86
	{2560, 1080, 0, 21,  25, 1},    //  87
	{2560, 1080, 0, 21,  30, 1},    //  88
	{2560, 1080, 0, 21,  50, 1},    //  89
	{2560, 1080, 0, 21,  60, 1},    //  90
	{2560, 1080, 0, 21, 100, 1},    //  91
	{2560, 1080, 0, 21, 120, 1},    //  92
	{3840, 2160, 0, 16,  24, 1},    //  93
	{3840, 2160, 0, 16,  25, 1},    //  94
	{3840, 2160, 0, 16,  30, 1},    //  95
	{3840, 2160, 0, 16,  50, 1},    //  96
	{3840, 2160, 0, 16,  60, 1},    //  97
	{4096, 2160, 0, 17,  24, 1},    //  98
	{4096, 2160, 0, 17,  25, 1},    //  99
	{4096, 2160, 0, 17,  30, 1},    // 100
	{4096, 2160, 0, 17,  50, 1},    // 101
	{4096, 2160, 0, 17,  60, 1},    // 102
	{3840, 2160, 0, 21,  24, 0},    // 103
	{3840, 2160, 0, 21,  25, 0},    // 104
	{3840, 2160, 0, 21,  30, 0},    // 105
	{3840, 2160, 0, 21,  50, 0},    // 106
	{3840, 2160, 0, 21,  60, 0},    // 107
	{1280,  720, 0, 16,  48, 1},    // 108
	{1280,  720, 0, 21,  48, 0},    // 109
	{1680,  720, 0, 21,  48, 1},    // 110
	{1920, 1080, 0, 16,  48, 1},    // 111
	{1920, 1080, 0, 21,  48, 0},    // 112
	{2560, 1080, 0, 21,  48, 1},    // 113
	{3840, 2160, 0, 16,  48, 1},    // 114
	{4096, 2160, 0, 17,  48, 1},    // 115
	{3840, 2160, 0, 21,  48, 0},    // 116
	{3840, 2160, 0, 16, 100, 1},    // 117
	{3840, 2160, 0, 16, 120, 1},    // 118
	{3840, 2160, 0, 21, 100, 0},    // 119
	{3840, 2160, 0, 21, 120, 0},    // 120
	{5120, 2160, 0, 21,  24, 1},    // 121
	{5120, 2160, 0, 21,  25, 1},    // 122
	{5120, 2160, 0, 21,  30, 1},    // 123
	{5120, 2160, 0, 21,  48, 1},    // 124
	{5120, 2160, 0, 21,  50, 1},    // 125
	{5120, 2160, 0, 21,  60, 1},    // 126
	{5120, 2160, 0, 21, 100, 1},    // 127
	{0},                            // 128
	{0},                            // 129
	{0},                            // 130
	{0},                            // 131
	{0},                            // 132
	{0},                            // 133
	{0},                            // 134
	{0},                            // 135
	{0},                            // 136
	{0},                            // 137
	{0},                            // 138
	{0},                            // 139
	{0},                            // 140
	{0},                            // 141
	{0},                            // 142
	{0},                            // 143
	{0},                            // 144
	{0},                            // 145
	{0},                            // 146
	{0},                            // 147
	{0},                            // 148
	{0},                            // 149
	{0},                            // 150
	{0},                            // 151
	{0},                            // 152
	{0},                            // 153
	{0},                            // 154
	{0},                            // 155
	{0},                            // 156
	{0},                            // 157
	{0},                            // 158
	{0},                            // 159
	{0},                            // 160
	{0},                            // 161
	{0},                            // 162
	{0},                            // 163
	{0},                            // 164
	{0},                            // 165
	{0},                            // 166
	{0},                            // 167
	{0},                            // 168
	{0},                            // 169
	{0},                            // 170
	{0},                            // 171
	{0},                            // 172
	{0},                            // 173
	{0},                            // 174
	{0},                            // 175
	{0},                            // 176
	{0},                            // 177
	{0},                            // 178
	{0},                            // 179
	{0},                            // 180
	{0},                            // 181
	{0},                            // 182
	{0},                            // 183
	{0},                            // 184
	{0},                            // 185
	{0},                            // 186
	{0},                            // 187
	{0},                            // 188
	{0},                            // 189
	{0},                            // 190
	{0},                            // 191
	{0},                            // 192
	{5120, 2160, 0, 21, 120, 1},    // 193
	{7680, 4320, 0, 16,  24, 1},    // 194
	{7680, 4320, 0, 16,  25, 1},    // 195
	{7680, 4320, 0, 16,  30, 1},    // 196
	{7680, 4320, 0, 16,  48, 1},    // 197
	{7680, 4320, 0, 16,  50, 1},    // 198
	{7680, 4320, 0, 16,  60, 1},    // 199
	{7680, 4320, 0, 16, 100, 1},    // 200
	{7680, 4320, 0, 16, 120, 1},    // 201
	{7680, 4320, 0, 21,  24, 0},    // 202
	{7680, 4320, 0, 21,  25, 0},    // 203
	{7680, 4320, 0, 21,  30, 0},    // 204
	{7680, 4320, 0, 21,  48, 0},    // 205
	{7680, 4320, 0, 21,  50, 0},    // 206
	{7680, 4320, 0, 21,  60, 0},    // 207
	{7680, 4320, 0, 21, 100, 0},    // 208
	{7680, 4320, 0, 21, 120, 0},    // 209
	{10240, 4320, 0, 21,  24, 1},   // 210
	{10240, 4320, 0, 21,  25, 1},   // 211
	{10240, 4320, 0, 21,  30, 1},   // 212
	{10240, 4320, 0, 21,  48, 1},   // 213
	{10240, 4320, 0, 21,  50, 1},   // 214
	{10240, 4320, 0, 21,  60, 1},   // 215
	{10240, 4320, 0, 21, 100, 1},   // 216
	{10240, 4320, 0, 21, 120, 1},   // 217
	{4096, 2160, 0, 17, 100, 1},    // 218
	{4096, 2160, 0, 17, 120, 1},    // 219
};
//---------------------------------------------------------------------------
TVResolutionClass::TVResolutionClass()
{
	Mode = 0;
	Format = 0;
	Code = 1;
	LastCode = BLANK;
	Native = false;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::Read(const unsigned char *Data, int MaxSize)
{
	if (!Data)
		return false;

	if (MaxSize < 1)
		return false;

	Code = Data[0] & 127;
	Native = Data[0] & 128;

	if (!NativePossible())
	{
		Code = Data[0];
		Native = false;
	}

	for (Mode = MinMode; Mode < MaxMode; Mode++)
	{
		for (Format = MinFormat; Modes[Mode][Format] != 0; Format++)
			if (Modes[Mode][Format] == Code)
				break;

		if (Modes[Mode][Format] != 0)
			break;
	}

	if (Mode == MaxMode)
		LastCode = Code;
	else
		LastCode = BLANK;

	return true;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::Write(unsigned char *Data, int MaxSize)
{
	if (!Data)
		return false;

	if (MaxSize < 1)
		return false;

	if (!IsValid())
		return false;

	Data[0] = Code;

	if (Native)
		Data[0] |= 128;

	return true;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::GetText(char *Text, int TextSize)
{
	if (!IsValid())
		return false;

	int Width = Codes[Code][0];
	int Height = Codes[Code][1];
	int Interlaced = Codes[Code][2];
	int Aspect = Codes[Code][3];
	int Refresh = Codes[Code][4];

	if (Width != 0)
		std::snprintf(Text, TextSize, "%dx%d%s (%s) @ %d Hz", Width, Height, Interlaced ? "i" : "", AspectText[Aspect], Refresh);
	else
		std::snprintf(Text, TextSize, "Other (%d)", Code);

	return true;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::GetModeText(int Mode, char *Text, int TextSize)
{
	if (Mode < MinMode || Mode > MaxMode)
		return false;

	int Code = Modes[Mode][0];
	int Width = Codes[Code][0];
	int Height = Codes[Code][1];
	int Interlaced = Codes[Code][2];

	if (Width != 0)
		std::snprintf(Text, TextSize, "%dx%d%s", Width, Height, Interlaced ? "i" : "");
	else
		std::snprintf(Text, TextSize, "Other resolution");

	return true;
}
//---------------------------------------------------------------------------
int TVResolutionClass::GetMode()
{
	if (!IsValidMode())
		return -1;

	return Mode;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::SetMode(int Value)
{
	if (Value == Mode)
		return true;

	Mode = Value;
	Format = BLANK;

	if (Mode == MaxMode)
		Code = LastCode;
	else
		Code = BLANK;

	if (!NativePossible())
		Native = false;

	return true;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::GetFormatText(int Format, char *Text, int TextSize)
{
	if (!IsValidMode())
		return false;

	if (Format < MinFormat || Format > MaxFormat)
		return false;

	if (Modes[Mode][Format] == 0)
		return false;

	int Code = Modes[Mode][Format];
	int Width = Codes[Code][0];
	int Aspect = Codes[Code][3];
	int Refresh = Codes[Code][4];

	if (Width != 0)
		std::snprintf(Text, TextSize, "%d Hz (%s)", Refresh, AspectText[Aspect]);
	else
		std::snprintf(Text, TextSize, "Other (%d)", Code);

	return true;
}
//---------------------------------------------------------------------------
int TVResolutionClass::GetFormat()
{
	if (!IsValidModeFormat())
		return -1;

	return Format;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::SetFormat(int Value)
{
	Format = Value;

	if (!IsValidModeFormat())
		Code = BLANK;
	else
		Code = Modes[Mode][Format];

	if (!NativePossible())
		Native = false;

	return true;
}
//---------------------------------------------------------------------------
int TVResolutionClass::GetCode()
{
	return Code;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::SetCode(int Value)
{
	Code = Value;
	LastCode = Code;

	if (!NativePossible())
		Native = false;

	return true;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::GetNative()
{
	return Native;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::SetNative(bool Enabled)
{
	Native = Enabled;
	return true;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::NativePossible()
{
	return !IsValidCode() || Code >= MinNative && Code <= MaxNative;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::IsValid()
{
	return IsValidMode() && IsValidCode();
}
//---------------------------------------------------------------------------
bool TVResolutionClass::IsValidMode()
{
	return Mode >= MinMode && Mode <= MaxMode;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::IsValidModeFormat()
{
	return IsValidMode() && Format >= MinFormat && Format <= MaxFormat && Modes[Mode][Format];
}
//---------------------------------------------------------------------------
bool TVResolutionClass::IsValidCode()
{
	return Code >= MinCode && Code <= MaxCode;
}
//---------------------------------------------------------------------------
bool TVResolutionClass::IsSupported()
{
	return IsValidCode() && Codes[Code][5];
}
//---------------------------------------------------------------------------
bool TVResolutionClass::IsOther()
{
	return Mode == MaxMode;
}
//---------------------------------------------------------------------------
